/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsUUID;

public class CmsDeleteDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsDeleteDialog.class);
    private static final long serialVersionUID = 1L;
    private VerticalLayout m_resourceBox;
    private Label m_deleteResource;
    private Label m_linksLabel;
    private Button m_okButton;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private OptionGroup m_deleteSiblings;

    public CmsDeleteDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_deleteSiblings.addItem((Object)CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.m_deleteSiblings.setItemCaption((Object)CmsResource.DELETE_PRESERVE_SIBLINGS, CmsVaadinUtils.getMessageText("GUI_DELETE_PRESERVE_SIBLINGS_0", new Object[0]));
        this.m_deleteSiblings.addItem((Object)CmsResource.DELETE_REMOVE_SIBLINGS);
        this.m_deleteSiblings.setItemCaption((Object)CmsResource.DELETE_REMOVE_SIBLINGS, CmsVaadinUtils.getMessageText("GUI_DELETE_ALL_SIBLINGS_0", new Object[0]));
        this.m_deleteSiblings.setValue((Object)CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.m_deleteSiblings.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDeleteDialog.this.displayBrokenLinks();
            }
        });
        this.m_deleteSiblings.setVisible(this.hasSiblings());
        this.displayResourceInfo(this.m_context.getResources());
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteDialog.this.submit();
            }
        });
        this.displayBrokenLinks();
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsDeleteDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsDeleteDialog.this.submit();
            }
        });
    }

    public static Multimap<CmsResource, CmsResource> getBrokenLinks(CmsObject cms, List<CmsResource> selectedResources, boolean includeSiblings) throws CmsException {
        return CmsDeleteDialog.getBrokenLinks(cms, selectedResources, includeSiblings, false);
    }

    public static Multimap<CmsResource, CmsResource> getBrokenLinks(CmsObject cms, List<CmsResource> selectedResources, boolean includeSiblings, boolean reverse) throws CmsException {
        HashSet<CmsResource> descendants = new HashSet<CmsResource>();
        for (CmsResource root : selectedResources) {
            descendants.add(root);
            if (!root.isFolder()) continue;
            descendants.addAll(cms.readResources(cms.getSitePath(root), CmsResourceFilter.IGNORE_EXPIRATION));
        }
        if (includeSiblings) {
            for (Object res : new HashSet(descendants)) {
                if (!((CmsResource)res).isFile()) continue;
                descendants.addAll(cms.readSiblings((CmsResource)res, CmsResourceFilter.IGNORE_EXPIRATION));
            }
        }
        HashSet<CmsUUID> deleteIds = new HashSet<CmsUUID>();
        for (CmsResource deleteRes : descendants) {
            deleteIds.add(deleteRes.getStructureId());
        }
        HashMultimap linkMap = HashMultimap.create();
        for (CmsResource resource : descendants) {
            List<CmsRelation> relations = cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES);
            ArrayList<CmsResource> result1 = new ArrayList<CmsResource>();
            for (CmsRelation relation : relations) {
                CmsResource source1;
                if (deleteIds.contains(relation.getSourceId()) || (source1 = relation.getSource(cms, CmsResourceFilter.ALL)).getState().isDeleted()) continue;
                result1.add(source1);
            }
            ArrayList<CmsResource> linkSources = result1;
            for (CmsResource source : linkSources) {
                if (reverse) {
                    linkMap.put((Object)resource, (Object)source);
                    continue;
                }
                linkMap.put((Object)source, (Object)resource);
            }
        }
        return linkMap;
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    void displayBrokenLinks() {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_resourceBox.removeAllComponents();
        this.m_deleteResource.setValue(CmsVaadinUtils.getMessageText("GUI_DELETE_MULTI_CONFIRMATION_0", new Object[0]));
        this.m_okButton.setVisible(true);
        boolean canIgnoreBrokenLinks = OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(cms, CmsRole.VFS_MANAGER);
        try {
            Multimap<CmsResource, CmsResource> brokenLinks = CmsDeleteDialog.getBrokenLinks(cms, this.m_context.getResources(), CmsResource.DELETE_REMOVE_SIBLINGS.equals(this.m_deleteSiblings.getValue()));
            if (brokenLinks.isEmpty()) {
                this.m_linksLabel.setVisible(false);
                String noLinksBroken = CmsVaadinUtils.getMessageText("GUI_DELETE_RELATIONS_NOT_BROKEN_0", new Object[0]);
                this.m_resourceBox.addComponent((Component)new Label(noLinksBroken));
            } else {
                if (!canIgnoreBrokenLinks) {
                    this.m_deleteResource.setValue(CmsVaadinUtils.getMessageText("GUI_DELETE_RELATIONS_NOT_ALLOWED_0", new Object[0]));
                    this.m_okButton.setVisible(false);
                }
                for (CmsResource source : brokenLinks.keySet()) {
                    this.m_resourceBox.addComponent((Component)new CmsResourceInfo(source));
                    for (CmsResource target : brokenLinks.get((Object)source)) {
                        this.m_resourceBox.addComponent(this.indent(new CmsResourceInfo(target)));
                    }
                }
            }
        }
        catch (CmsException e) {
            this.m_context.error(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submit() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            ArrayList changedIds = Lists.newArrayList();
            CmsResource.CmsResourceDeleteMode mode = (CmsResource.CmsResourceDeleteMode)this.m_deleteSiblings.getValue();
            for (CmsResource resource : this.m_context.getResources()) {
                changedIds.add(resource.getStructureId());
                CmsLockActionRecord lockRecord = CmsLockUtil.ensureLock(cms, resource);
                try {
                    cms.deleteResource(cms.getSitePath(resource), mode);
                }
                finally {
                    if (!lockRecord.getChange().equals((Object)CmsLockActionRecord.LockChange.locked) || resource.getState().isNew()) continue;
                    try {
                        cms.unlockResource(resource);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (CmsLockException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            this.m_context.finish(changedIds);
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }

    private boolean hasSiblings() {
        for (CmsResource res : this.m_context.getResources()) {
            if (res.getSiblingCount() <= 1) continue;
            return true;
        }
        return false;
    }

    private Component indent(CmsResourceInfo resourceInfo) {
        boolean simple = false;
        if (simple) {
            return resourceInfo;
        }
        HorizontalLayout hl = new HorizontalLayout();
        Label label = new Label("");
        label.setWidth("35px");
        hl.addComponent((Component)label);
        hl.addComponent((Component)resourceInfo);
        hl.setExpandRatio((Component)resourceInfo, 1.0f);
        hl.setWidth("100%");
        return hl;
    }
}

