/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsQuickLaunchLocationCache;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.shared.rpc.I_CmsEmbeddedDialogClientRPC;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsEmbeddedDialogContext
extends AbstractExtension
implements I_CmsDialogContext {
    private static Pattern PROTOCOL_PATTERN = Pattern.compile("^http.?://.*");
    private static final long serialVersionUID = -7446784547935775629L;
    private String m_appId;
    private I_CmsDialogContext.ContextType m_contextType;
    private boolean m_keepFrameOnClose;
    private List<CmsResource> m_resources;
    private Window m_window;

    public CmsEmbeddedDialogContext(String appId, I_CmsDialogContext.ContextType contextType, List<CmsResource> resources) {
        this.extend((AbstractClientConnector)UI.getCurrent());
        this.m_appId = appId;
        this.m_contextType = contextType;
        this.m_resources = resources != null ? resources : Collections.emptyList();
    }

    public void closeWindow(boolean keepFrame) {
        if (this.m_window != null) {
            this.m_keepFrameOnClose = keepFrame;
            this.m_window.close();
            this.m_window = null;
        }
    }

    @Override
    public void error(Throwable error) {
        this.closeWindow(true);
        CmsErrorDialog.showErrorDialog(error, new Runnable(){

            @Override
            public void run() {
                CmsEmbeddedDialogContext.this.removeDialogFrame();
            }
        });
    }

    @Override
    public void finish(CmsProject project, String siteRoot) {
        if (project != null || siteRoot != null) {
            String serverLink;
            String sitePath = null;
            if (siteRoot != null) {
                int index;
                CmsQuickLaunchLocationCache locationCache = CmsQuickLaunchLocationCache.getLocationCache(A_CmsUI.get().getHttpSession());
                sitePath = locationCache.getPageEditorLocation(siteRoot);
                if (sitePath == null && (sitePath = locationCache.getFileExplorerLocation(siteRoot)) != null && (index = sitePath.indexOf("/.content")) >= 0) {
                    sitePath = sitePath.substring(0, index);
                }
            } else if (this.m_resources != null && !this.m_resources.isEmpty()) {
                sitePath = A_CmsUI.getCmsObject().getSitePath(this.m_resources.get(0));
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(sitePath)) {
                sitePath = "/";
            }
            if (!PROTOCOL_PATTERN.matcher(serverLink = OpenCms.getLinkManager().getServerLink(this.getCms(), sitePath)).matches()) {
                serverLink = "http://" + serverLink;
            }
            this.getClientRPC().finishForProjectOrSiteChange(sitePath, serverLink);
        } else {
            this.finish(null);
        }
    }

    @Override
    public void finish(Collection<CmsUUID> result) {
        this.closeWindow(true);
        String resources = "";
        if (result != null) {
            for (CmsUUID id : result) {
                resources = resources + id.toString() + ";";
            }
        }
        this.getClientRPC().finish(resources);
    }

    @Override
    public void focus(CmsUUID structureId) {
    }

    @Override
    public List<CmsUUID> getAllStructureIdsInView() {
        return Collections.emptyList();
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public CmsObject getCms() {
        return A_CmsUI.getCmsObject();
    }

    @Override
    public I_CmsDialogContext.ContextType getContextType() {
        return this.m_contextType;
    }

    @Override
    public List<CmsResource> getResources() {
        return this.m_resources;
    }

    public void leavePage(String uri) {
        this.getClientRPC().leavePage(uri);
    }

    @Override
    public void navigateTo(String appId) {
        String targetUri = OpenCms.getSystemInfo().getWorkplaceContext() + "#!" + appId;
        this.getClientRPC().leavePage(targetUri);
    }

    @Override
    public void onViewChange() {
        if (this.m_window != null) {
            this.m_window.center();
        }
    }

    @Override
    public void reload() {
        this.closeWindow(true);
        this.reloadParent();
    }

    public void setPrincipal(String principalName) {
        this.getClientRPC().setPrincipal(principalName);
    }

    @Override
    public void setWindow(Window window) {
        this.m_window = window;
        this.m_window.addCloseListener(new Window.CloseListener(){
            private static final long serialVersionUID = 1L;

            public void windowClose(Window.CloseEvent e) {
                CmsEmbeddedDialogContext.this.handleWindowClose();
            }
        });
    }

    @Override
    public void start(String title, Component dialog) {
        this.start(title, dialog, CmsBasicDialog.DialogWidth.narrow);
    }

    @Override
    public void start(String title, Component dialog, CmsBasicDialog.DialogWidth width) {
        if (dialog != null) {
            this.m_keepFrameOnClose = false;
            this.m_window = CmsBasicDialog.prepareWindow(width);
            this.m_window.setCaption(title);
            this.m_window.setContent(dialog);
            UI.getCurrent().addWindow(this.m_window);
            this.m_window.addCloseListener(new Window.CloseListener(){
                private static final long serialVersionUID = 1L;

                public void windowClose(Window.CloseEvent e) {
                    CmsEmbeddedDialogContext.this.handleWindowClose();
                }
            });
            if (dialog instanceof CmsBasicDialog) {
                ((CmsBasicDialog)dialog).initActionHandler(this.m_window);
            }
        }
    }

    @Override
    public void updateUserInfo() {
        this.getClientRPC().reloadParent();
    }

    protected I_CmsEmbeddedDialogClientRPC getClientRPC() {
        return (I_CmsEmbeddedDialogClientRPC)this.getRpcProxy(I_CmsEmbeddedDialogClientRPC.class);
    }

    void handleWindowClose() {
        if (!this.m_keepFrameOnClose) {
            this.removeDialogFrame();
        }
    }

    void removeDialogFrame() {
        this.getClientRPC().finish(null);
    }

    private void reloadParent() {
        this.getClientRPC().reloadParent();
    }
}

