/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.server.Page;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.gwt.CmsCoreService;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsStringUtil;

public class CmsSiteSelectDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsSiteSelectDialog.class);
    private static final String CAPTION_PROPERTY = "caption";
    private static final long serialVersionUID = 4455901453008760434L;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private ComboBox m_siteComboBox;

    public CmsSiteSelectDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.setContent((Component)this.initForm());
        this.m_cancelButton = this.createButtonCancel();
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteSelectDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsSiteSelectDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsSiteSelectDialog.this.submit();
            }
        });
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    void submit() {
        String siteRoot = (String)this.m_siteComboBox.getValue();
        if (!this.m_context.getCms().getRequestContext().getSiteRoot().equals(siteRoot)) {
            A_CmsUI.get().changeSite(siteRoot);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(siteRoot) || OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
                Page.getCurrent().open(CmsCoreService.getFileExplorerLink(A_CmsUI.getCmsObject(), siteRoot), "_top");
                return;
            }
        } else {
            siteRoot = null;
        }
        this.m_context.finish(null, siteRoot);
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        IndexedContainer sites = CmsVaadinUtils.getAvailableSitesContainer(this.m_context.getCms(), CAPTION_PROPERTY);
        this.m_siteComboBox = this.prepareComboBox(sites, "GUI_LABEL_SITE_0");
        this.m_siteComboBox.select((Object)this.m_context.getCms().getRequestContext().getSiteRoot());
        form.addComponent((Component)this.m_siteComboBox);
        Property.ValueChangeListener changeListener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSiteSelectDialog.this.submit();
            }
        };
        this.m_siteComboBox.addValueChangeListener(changeListener);
        return form;
    }

    private ComboBox prepareComboBox(IndexedContainer container, String captionKey) {
        ComboBox result = new ComboBox(CmsVaadinUtils.getWpMessagesForCurrentLocale().key(captionKey), (Container)container);
        result.setTextInputAllowed(true);
        result.setNullSelectionAllowed(false);
        result.setWidth("100%");
        result.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        result.setItemCaptionPropertyId((Object)CAPTION_PROPERTY);
        result.setFilteringMode(FilteringMode.CONTAINS);
        return result;
    }
}

