/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.common.collect.Lists;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;

public class CmsTouchDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsTouchDialog.class);
    private static final long serialVersionUID = 1L;
    protected I_CmsDialogContext m_context;
    private Button m_cancelButton;
    private CmsDateField m_dateField;
    private CheckBox m_modifySubresourcesField;
    private Button m_okButton;
    private CheckBox m_rewriteContentField;

    public CmsTouchDialog(I_CmsDialogContext context) {
        this.m_context = context;
        boolean hasFolders = false;
        for (CmsResource resource : context.getResources()) {
            if (!resource.isFolder()) continue;
            hasFolders = true;
            break;
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_modifySubresourcesField.setVisible(hasFolders);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsTouchDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsTouchDialog.this.submit();
            }
        });
        this.m_dateField.setValue(LocalDateTime.now());
        this.displayResourceInfo(this.m_context.getResources());
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsTouchDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsTouchDialog.this.submit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touchFiles() throws CmsException {
        Date touchDate = this.m_dateField.getDate();
        boolean validDate = touchDate != null;
        long touchTime = touchDate != null ? touchDate.getTime() : 0L;
        boolean recursive = this.m_modifySubresourcesField.getValue();
        boolean rewriteContent = this.m_rewriteContentField.getValue();
        ArrayList changedIds = Lists.newArrayList();
        for (CmsResource resource : this.m_context.getResources()) {
            CmsLockActionRecord actionRecord = null;
            try {
                actionRecord = CmsLockUtil.ensureLock(this.m_context.getCms(), resource);
                this.touchSingleResource(this.m_context.getCms().getSitePath(resource), touchTime, recursive, validDate, rewriteContent);
                changedIds.add(resource.getStructureId());
            }
            finally {
                if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                try {
                    this.m_context.getCms().unlockResource(resource);
                }
                catch (CmsLockException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        this.m_context.finish(changedIds);
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    void submit() {
        try {
            this.touchFiles();
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }

    private void hardTouch(CmsResource resource) throws CmsException {
        CmsFile file = this.m_context.getCms().readFile(resource);
        CmsObject cms = OpenCms.initCmsObject(this.m_context.getCms());
        cms.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
        file.setContents(file.getContents());
        cms.writeFile(file);
    }

    private void touchSingleResource(String resourceName, long timeStamp, boolean recursive, boolean correctDate, boolean touchContent) throws CmsException {
        CmsObject cms = this.m_context.getCms();
        CmsResource sourceRes = cms.readResource(resourceName, CmsResourceFilter.ALL);
        if (!correctDate) {
            timeStamp = sourceRes.getDateLastModified();
        }
        if (touchContent) {
            if (sourceRes.isFile()) {
                this.hardTouch(sourceRes);
            } else if (recursive) {
                for (CmsResource subRes : cms.readResources(resourceName, CmsResourceFilter.ALL, true)) {
                    if (!subRes.isFile()) continue;
                    this.hardTouch(subRes);
                }
            }
        }
        cms.setDateLastModified(resourceName, timeStamp, recursive);
    }
}

