/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.Label;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.Messages;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsUserDataFormLayout;
import org.opencms.ui.dialogs.I_CmsHasTitle;

public class CmsUserDataDialog
extends CmsBasicDialog
implements I_CmsHasTitle {
    public static final String DIALOG_ID = "edituserdata";
    private static final long serialVersionUID = 8907786853232656944L;
    private static final Log LOG = CmsLog.getLog(CmsUserDataDialog.class);
    private Button m_cancelButton;
    I_CmsDialogContext m_context;
    private CmsUserDataFormLayout m_form;
    private Button m_okButton;
    CmsUser m_user;

    public CmsUserDataDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsObject cms = context.getCms();
        this.m_user = cms.getRequestContext().getCurrentUser();
        if (this.m_user.isManaged()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_USER_NOT_SELF_MANAGED_1", this.m_user.getName()));
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_user)));
        this.m_form.initFields(this.m_user);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserDataDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserDataDialog.this.submit();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsUserDataDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsUserDataDialog.this.submit();
            }
        });
    }

    public CmsUserDataDialog(I_CmsDialogContext context, boolean forcedCheck) {
        this(context);
        if (forcedCheck) {
            this.addComponent((Component)new Label(this.getUserDataCheckMessage()), 0);
            this.m_cancelButton.setVisible(false);
        }
    }

    @Override
    public String getTitle(Locale locale) {
        return org.opencms.ui.components.Messages.get().getBundle(locale).key("GUI_USER_EDIT_0");
    }

    protected String getUserDataCheckMessage() {
        ResourceBundle bundle = null;
        try {
            bundle = CmsResourceBundleLoader.getBundle("org.opencms.userdatacheck.custom", A_CmsUI.get().getLocale());
            return bundle.getString("userdatacheck.text");
        }
        catch (MissingResourceException e) {
            return CmsVaadinUtils.getMessageText("GUI_USER_DATA_CHECK_INFO_0", new Object[0]);
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
        this.m_context.updateUserInfo();
    }

    void submit() {
        try {
            this.m_user = this.m_context.getCms().readUser(this.m_user.getId());
            this.m_form.submit(this.m_user, this.m_context.getCms(), new Runnable(){

                @Override
                public void run() {
                    try {
                        CmsUserDataDialog.this.m_context.getCms().writeUser(CmsUserDataDialog.this.m_user);
                        CmsUserDataDialog.this.m_context.finish(Collections.emptyList());
                        CmsUserDataDialog.this.m_context.updateUserInfo();
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user", (Throwable)e);
        }
    }

    void updateUserInfo() {
        try {
            this.m_user = this.m_context.getCms().readUser(this.m_user.getId());
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_user)));
        }
        catch (CmsException e) {
            LOG.error((Object)"Error updating user info.", (Throwable)e);
        }
    }
}

