/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.google.common.base.Optional;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.dialogs.history.CmsHistoryRow;
import org.opencms.ui.dialogs.history.diff.I_CmsDiffProvider;
import org.opencms.workplace.comparison.CmsHistoryListUtil;

public class CmsShowVersionButtons
implements I_CmsDiffProvider {
    public Button createButton(final CmsObject cms, final CmsHistoryResourceBean version) {
        String label = CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_SHOW_VERSION_BUTTON_1", CmsHistoryRow.formatVersion(version));
        Button result = new Button(label);
        result.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                String v1Param = version.getVersion().getVersionNumber() != null ? "" + version.getVersion().getVersionNumber() : "2147483647";
                String link = CmsHistoryListUtil.getHistoryLink(cms, version.getStructureId(), v1Param);
                link = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, link);
                A_CmsUI.get().openPageOrWarn(link, "_blank");
            }
        });
        return result;
    }

    @Override
    public Optional<Component> diff(CmsObject cms, CmsHistoryResourceBean v1, CmsHistoryResourceBean v2) {
        Panel panel = new Panel("");
        panel.addStyleName("borderless");
        HorizontalLayout hl = new HorizontalLayout();
        panel.setContent((Component)hl);
        hl.addComponent((Component)this.createButton(cms, v1));
        hl.addComponent((Component)this.createButton(cms, v2));
        VerticalLayout outerContainer = new VerticalLayout();
        outerContainer.addComponent((Component)hl);
        outerContainer.setComponentAlignment((Component)hl, Alignment.MIDDLE_RIGHT);
        outerContainer.setMargin(true);
        hl.setSpacing(true);
        return Optional.fromNullable((Object)outerContainer);
    }
}

