/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history.diff;

import com.alkacon.diff.Diff;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsHtml2TextConverter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.comparison.CmsDiffViewMode;
import org.opencms.workplace.comparison.CmsHtmlDifferenceConfiguration;

public class CmsTextDiffPanel
extends VerticalLayout {
    private static final Log LOG = CmsLog.getLog(CmsTextDiffPanel.class);
    private static final long serialVersionUID = 1L;
    private Label m_diffHtml;
    private String m_diffMode = "diff";
    private OptionGroup m_diffModeSelect;
    private String m_text1;
    private String m_text2;
    private String m_textMode = "html";
    private OptionGroup m_textOrHtmlSelect;

    public CmsTextDiffPanel(String text1, String text2, boolean selectTextOrHtml, boolean selectDiffMode) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_text1 = text1;
        this.m_text2 = text2;
        this.m_textOrHtmlSelect.addStyleName("horizontal");
        this.m_textOrHtmlSelect.setValue((Object)"html");
        this.m_textOrHtmlSelect.setVisible(selectTextOrHtml);
        this.m_diffModeSelect.setValue((Object)"diff");
        this.m_diffModeSelect.addStyleName("horizontal");
        this.m_diffModeSelect.setVisible(selectDiffMode);
        this.m_textOrHtmlSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsTextDiffPanel.this.m_textMode = event.getProperty().getValue().toString();
                CmsTextDiffPanel.this.update();
            }
        });
        this.m_diffModeSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsTextDiffPanel.this.m_diffMode = event.getProperty().getValue().toString();
                CmsTextDiffPanel.this.update();
            }
        });
        this.update();
    }

    public String getDiffHtml() throws Exception {
        CmsDiffViewMode mode = "all".equals(this.m_diffMode) ? CmsDiffViewMode.ALL : CmsDiffViewMode.DIFF_ONLY;
        String text1 = this.m_text1;
        String text2 = this.m_text2;
        if ("text".equals(this.m_textMode)) {
            text1 = CmsHtml2TextConverter.html2text(text1, "UTF-8");
            text2 = CmsHtml2TextConverter.html2text(text2, "UTF-8");
        }
        CmsHtmlDifferenceConfiguration conf = new CmsHtmlDifferenceConfiguration(mode == CmsDiffViewMode.ALL ? -1 : 2, A_CmsUI.get().getLocale());
        String diff = Diff.diffAsHtml((String)text1, (String)text2, (I_HtmlDiffConfiguration)conf);
        String html = null;
        html = CmsStringUtil.isNotEmpty(diff) ? diff : this.wrapLinesWithUnchangedStyle(CmsStringUtil.substitute(CmsStringUtil.escapeHtml(this.m_text1), "<br/>", ""));
        return html;
    }

    public void update() {
        try {
            String diffHtml = "<pre>" + this.getDiffHtml() + "</pre>";
            this.m_diffHtml.setContentMode(ContentMode.HTML);
            this.m_diffHtml.setValue(diffHtml);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected String wrapLinesWithUnchangedStyle(String diff) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(diff));
        while ((line = br.readLine()) != null) {
            if ("".equals(line.trim())) {
                line = "&nbsp;";
            }
            result.append("<div class=\"df-unc\"><span class=\"df-unc\">").append(line).append("</span></div>\n");
        }
        return result.toString();
    }
}

