/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.server.Resource;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.dialogs.permissions.CmsPermissionBean;
import org.opencms.ui.dialogs.permissions.CmsPermissionView;
import org.opencms.ui.dialogs.permissions.CmsPermissionViewTable;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsPermissionDialog
extends CmsBasicDialog
implements CmsPermissionView.PermissionChangeHandler,
CmsPrincipalSelect.I_PrincipalSelectHandler {
    protected static final String[] PRINCIPAL_TYPES = new String[]{"GROUP", "USER", "ROLE", "ALL_OTHERS", "OVERWRITE_ALL"};
    protected static final int[] PRINCIPAL_TYPES_INT = new int[]{32, 16, 512, 128, 256};
    private static final Log LOG = CmsLog.getLog(CmsPermissionDialog.class);
    private static final long serialVersionUID = 2397141190651779325L;
    private Set<CmsPermissionBean> m_permissionToChange = new HashSet<CmsPermissionBean>();
    private Accordion m_accordion;
    private Button m_closeButton;
    private Button m_okButton;
    private CmsObject m_cms;
    private I_CmsDialogContext m_context;
    private boolean m_editable = true;
    private VerticalLayout m_inheritedPermissions;
    private CmsLockActionRecord m_lockActionRecord;
    private VerticalLayout m_main;
    private CmsPrincipalSelect m_principalSelect;
    private CmsResource m_resource;
    private Map<CmsUUID, String> m_parents;
    private VerticalLayout m_resourcePermissions;
    private VerticalLayout m_setPermissionTab;
    private VerticalLayout m_userPermissions;

    public CmsPermissionDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.m_cms = context.getCms();
        this.m_editable = CmsStandardVisibilityCheck.PERMISSIONS.getVisibility(context).isActive();
        this.m_resource = context.getResources().get(0);
        boolean editRoles = CmsWorkplace.canEditPermissionsForRoles(this.m_cms, this.m_resource.getRootPath());
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_main.setHeightUndefined();
        if (this.m_editable) {
            this.m_principalSelect.setMargin(true);
            this.m_principalSelect.setSelectHandler(this);
            this.m_principalSelect.setRoleSelectionAllowed(editRoles);
        } else {
            this.m_principalSelect.setVisible(false);
        }
        this.displayResourceInfo(Collections.singletonList(this.m_resource));
        this.displayUserPermissions(this.m_cms.getRequestContext().getCurrentUser());
        this.displayInheritedPermissions();
        this.displayResourcePermissions();
        this.m_closeButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionDialog.this.close();
            }
        });
        this.m_accordion.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){
            private static final long serialVersionUID = 1L;

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                CmsPermissionDialog.this.onViewChange();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -8061995491261573917L;

            public void buttonClick(Button.ClickEvent event) {
                CmsPermissionDialog.this.savePermissions();
                CmsPermissionDialog.this.close();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsPermissionDialog.this.close();
            }

            @Override
            protected void ok() {
            }
        });
        this.m_accordion.setSelectedTab((Component)this.m_setPermissionTab);
        this.m_principalSelect.setPrincipalType("GROUP");
    }

    @Override
    public void deletePermissionSet(String principalType, String principalName) {
        CmsPermissionBean bean = new CmsPermissionBean(principalType, principalName);
        this.m_permissionToChange.remove(bean);
        this.m_permissionToChange.add(bean);
        this.refreshOwnEntries();
    }

    @Override
    public void onPrincipalSelect(String principalType, String principalName) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(principalName)) {
            String permissionString = "";
            if (this.m_resource.isFolder()) {
                permissionString = "+i";
            }
            try {
                this.ensureLock();
                CmsPermissionBean bean = null;
                if (principalName.equals(CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]))) {
                    bean = new CmsPermissionBean("Unknown", "ALL_OTHERS", permissionString);
                    bean.setFlags(128);
                } else if (principalName.equals(CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]))) {
                    bean = new CmsPermissionBean("Unknown", "OVERWRITE_ALL", permissionString);
                    bean.setFlags(256);
                } else {
                    CmsRole role2;
                    if (principalType.equalsIgnoreCase("ROLE") && (role2 = CmsRole.valueOfRoleName(principalName)) == null) {
                        for (CmsRole role2 : CmsRole.getSystemRoles()) {
                            if (!role2.getName(this.getLocale()).equalsIgnoreCase(principalName)) continue;
                            principalName = role2.getRoleName();
                            break;
                        }
                    }
                    bean = new CmsPermissionBean(principalType, principalName, permissionString);
                }
                this.m_permissionToChange.remove(bean);
                this.m_permissionToChange.add(bean);
                this.refreshOwnEntries();
                this.onViewChange();
            }
            catch (CmsException e) {
                this.m_context.error(e);
            }
        }
    }

    @Override
    public void onViewChange() {
        CmsVaadinUtils.centerWindow((Component)this.m_main);
    }

    @Override
    public void setPermissions(CmsPermissionBean bean) {
        this.m_permissionToChange.remove(bean);
        this.m_permissionToChange.add(bean);
    }

    protected CmsPermissionView buildPermissionEntryForm(CmsAccessControlEntry entry, boolean editable, boolean extendedView, CmsUUID inheritRes) {
        return new CmsPermissionView(entry, editable, this.m_resource.isFolder(), inheritRes == null ? null : this.m_parents.get(inheritRes), this);
    }

    protected String getConnectedResource(CmsAccessControlEntry entry, Map<CmsUUID, String> parents) {
        CmsUUID resId = entry.getResource();
        String resName = parents.get(resId);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resName)) {
            return resName;
        }
        return resId.toString();
    }

    void close() {
        try {
            this.clearLock();
            this.m_context.finish(Collections.singletonList(this.m_resource.getStructureId()));
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    void displayInheritedPermissions() {
        ArrayList<CmsAccessControlEntry> arrayList;
        block7: {
            List<Object> parentResources;
            String path;
            block6: {
                this.m_parents = new HashMap<CmsUUID, String>();
                String sitePath = this.m_cms.getSitePath(this.m_resource);
                path = CmsResource.getParentFolder(sitePath);
                parentResources = new ArrayList();
                try {
                    parentResources = this.m_cms.readPath(path, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block6;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
            for (CmsResource cmsResource : parentResources) {
                this.m_parents.put(cmsResource.getResourceId(), cmsResource.getRootPath());
            }
            arrayList = new ArrayList<CmsAccessControlEntry>();
            try {
                for (CmsAccessControlEntry curEntry : this.m_cms.getAccessControlEntries(path, true)) {
                    arrayList.add(curEntry);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        this.addEntryTableToLayout(arrayList, this.m_inheritedPermissions, false, true);
    }

    void displayResourcePermissions() {
        this.refreshOwnEntries();
    }

    void displayUserPermissions(CmsUser user) {
        CmsPermissionView view = this.buildPermissionEntryForm(user.getId(), this.buildPermissionsForCurrentUser(), false, false);
        view.hideDeniedColumn();
        this.m_userPermissions.addComponent((Component)view);
    }

    void savePermissions() {
        try {
            this.ensureLock();
            for (CmsPermissionBean bean : this.m_permissionToChange) {
                if (bean.isDeleted()) {
                    this.m_cms.rmacc(this.m_cms.getSitePath(this.m_resource), bean.getPrincipalType(), bean.getPrincipalName());
                    continue;
                }
                if (bean.getPermissionString() == null) {
                    this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), bean.getPrincipalType(), bean.getPrincipalName(), bean.getAllowed(), bean.getDenied(), bean.getFlags());
                    continue;
                }
                this.m_cms.chacc(this.m_cms.getSitePath(this.m_resource), bean.getPrincipalType(), bean.getPrincipalName(), bean.getPermissionString());
            }
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    private void addEntryTableToLayout(List<CmsAccessControlEntry> entries, VerticalLayout layout, boolean editable, boolean inheritedRes) {
        final CmsPermissionViewTable table = new CmsPermissionViewTable(this.m_cms, entries, editable, inheritedRes, this.m_parents, this);
        HorizontalLayout hl = new HorizontalLayout();
        Label label = new Label(CmsVaadinUtils.getMessageText("GUI_PERMISSION_COUNT_1", new Integer(table.getContainerDataSource().size())));
        label.addStyleName("o-report");
        hl.addComponent((Component)label);
        TextField tableFilter = new TextField();
        tableFilter.setIcon((Resource)FontOpenCms.FILTER);
        tableFilter.setInputPrompt(CmsVaadinUtils.getMessageText("GUI_EXPLORER_FILTER_0", new Object[0]));
        tableFilter.addStyleName("inline-icon");
        tableFilter.setWidth("200px");
        tableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                table.filterTable(event.getText());
            }
        });
        hl.addComponent((Component)tableFilter);
        hl.setWidth("100%");
        hl.setExpandRatio((Component)label, 1.0f);
        hl.setMargin(true);
        hl.setComponentAlignment((Component)tableFilter, Alignment.MIDDLE_RIGHT);
        if (table.getContainerDataSource().size() == 0) {
            layout.addComponent((Component)CmsVaadinUtils.getInfoLayout("GUI_PERMISSION_EMPTY_0"));
        } else {
            layout.addComponent((Component)hl);
            layout.addComponent((Component)table);
            CmsVaadinUtils.centerWindow((Component)this);
        }
    }

    private CmsPermissionView buildPermissionEntryForm(CmsUUID id, CmsPermissionSet curSet, boolean editable, boolean extendedView) {
        String fileName = this.m_cms.getSitePath(this.m_resource);
        int flags = 0;
        try {
            I_CmsPrincipal p;
            try {
                p = CmsPrincipal.readPrincipalIncludingHistory(this.m_cms, id);
            }
            catch (CmsException e) {
                p = null;
            }
            if (p != null && p.isGroup()) {
                flags = 32;
            } else if (p != null && p.isUser()) {
                flags = 16;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                flags = 128;
            } else if (p == null && id.equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
                flags = 256;
            } else {
                CmsRole role = CmsRole.valueOfId(id);
                if (role != null) {
                    flags = 512;
                }
            }
            CmsResource res = this.m_cms.readResource(fileName, CmsResourceFilter.ALL);
            CmsAccessControlEntry entry = new CmsAccessControlEntry(res.getResourceId(), id, curSet, flags);
            return this.buildPermissionEntryForm(entry, editable, extendedView, null);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage());
            }
            return null;
        }
    }

    private CmsPermissionSet buildPermissionsForCurrentUser() {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, this.m_resource);
        return resUtil.getPermissionSet();
    }

    private void clearLock() throws CmsException {
        if (this.m_lockActionRecord != null && this.m_lockActionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
            CmsResource updatedRes = this.m_cms.readResource(this.m_resource.getStructureId(), CmsResourceFilter.ALL);
            try {
                this.m_cms.unlockResource(updatedRes);
            }
            catch (CmsLockException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_lockActionRecord = null;
        }
    }

    private void ensureLock() throws CmsException {
        if (this.m_lockActionRecord == null) {
            this.m_lockActionRecord = CmsLockUtil.ensureLock(this.m_cms, this.m_resource);
        }
    }

    private void refreshOwnEntries() {
        this.m_resourcePermissions.removeAllComponents();
        String sitePath = this.m_cms.getSitePath(this.m_resource);
        ArrayList<CmsAccessControlEntry> ownEntries = new ArrayList<CmsAccessControlEntry>();
        try {
            Iterator<CmsAccessControlEntry> itAces = this.m_cms.getAccessControlEntries(sitePath, false).iterator();
            HashSet newBeans = (HashSet)((HashSet)this.m_permissionToChange).clone();
            while (itAces.hasNext()) {
                CmsAccessControlEntry curEntry = itAces.next();
                if (curEntry.isInherited()) continue;
                CmsPermissionBean bean = CmsPermissionBean.getBeanForPrincipal(this.m_permissionToChange, CmsPermissionBean.getPrincipalNameFromACE(this.m_cms, curEntry));
                if (bean == null) {
                    ownEntries.add(curEntry);
                    continue;
                }
                if (!bean.isDeleted()) {
                    ownEntries.add(bean.toAccessControlEntry(this.m_cms, this.m_resource.getStructureId()));
                }
                newBeans.remove(bean);
            }
            for (CmsPermissionBean newBean : newBeans) {
                if (newBean.isDeleted()) continue;
                ownEntries.add(newBean.toAccessControlEntry(this.m_cms, this.m_resource.getStructureId()));
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.addEntryTableToLayout(ownEntries, this.m_resourcePermissions, true, false);
    }
}

