/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.ui.dialogs.permissions.CmsPrincipalTable;
import org.opencms.ui.dialogs.permissions.I_CmsPrincipalSelect;

public class CmsPrincipalSelectDialog
extends CmsBasicDialog {
    public static String PARAM_OU = "ou";
    public static String PARAM_TYPE = "type";
    public static String PARAM_START_TYPE = "starttype";
    public static String PARAM_REAL_ONLY = "realonly";
    public static final String DIALOG_ID = "principalselect";
    private static final long serialVersionUID = 4650407086145654695L;
    private static final Log LOG = CmsLog.getLog(CmsPrincipalSelectDialog.class);
    private static String ID_ICON = "icon";
    private static String ID_CAPTION = "caption";
    private static String ID_DESC = "desc";
    private static String ID_OU = "ou";
    CmsObject m_cms;
    I_CmsPrincipalSelect m_selectField;
    private Button m_closeButton;
    ComboBox m_typeCombo;
    private TextField m_tableFilter;
    CmsPrincipalTable m_table;
    private String m_ou;
    CmsPrincipalSelect.WidgetType m_type;
    private boolean m_realOnly;
    private ComboBox m_ouCombo;
    private CmsPrincipalSelect.I_PrincipalSelectHandler m_selectHandler;

    public CmsPrincipalSelectDialog(I_CmsPrincipalSelect cmsPrincipalSelect, String ou, Window window, CmsPrincipalSelect.WidgetType widgetType, boolean realOnly, CmsPrincipalSelect.WidgetType defaultView) {
        this(cmsPrincipalSelect, ou, window, widgetType, realOnly, defaultView, true);
    }

    public CmsPrincipalSelectDialog(I_CmsPrincipalSelect cmsPrincipalSelect, String ou, final Window window, CmsPrincipalSelect.WidgetType widgetType, boolean realOnly, CmsPrincipalSelect.WidgetType defaultView, boolean includeWebOus) {
        this.m_ou = ou;
        this.m_type = widgetType;
        this.m_realOnly = realOnly;
        try {
            this.m_cms = A_CmsUI.getCmsObject();
            this.m_selectField = cmsPrincipalSelect;
            this.m_ouCombo = CmsVaadinUtils.getOUComboBox(this.m_cms, this.m_cms.getRequestContext().getOuFqn(), null, includeWebOus);
            this.m_ouCombo.select((Object)this.m_ou);
            IndexedContainer data = this.getContainerForType(defaultView, this.m_realOnly, (String)this.m_ouCombo.getValue());
            this.m_table = new CmsPrincipalTable(this, data, ID_ICON, ID_CAPTION, ID_DESC, ID_OU);
            this.m_table.setColumnHeader(ID_CAPTION, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_NAME_0", new Object[0]));
            this.m_table.setColumnHeader(ID_DESC, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_DESCRIPTION_0", new Object[0]));
            this.m_table.setColumnHeader(ID_OU, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_OU_0", new Object[0]));
            this.m_tableFilter = new TextField();
            this.m_tableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_tableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_tableFilter.addStyleName("inline-icon");
            this.m_tableFilter.setWidth("200px");
            this.m_tableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 1L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    CmsPrincipalSelectDialog.this.m_table.filterTable(event.getText());
                }
            });
            VerticalLayout vl = new VerticalLayout();
            vl.setSpacing(true);
            HorizontalLayout hl = new HorizontalLayout();
            hl.setSpacing(true);
            hl.setWidth("100%");
            this.m_typeCombo = new ComboBox();
            Label space = new Label();
            hl.addComponent((Component)this.m_typeCombo);
            hl.addComponent((Component)this.m_ouCombo);
            hl.addComponent((Component)space);
            hl.addComponent((Component)this.m_tableFilter);
            hl.setExpandRatio((Component)space, 1.0f);
            hl.setComponentAlignment((Component)this.m_ouCombo, Alignment.MIDDLE_CENTER);
            vl.addComponent((Component)hl);
            vl.addComponent((Component)this.m_table);
            if (!OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER)) {
                this.m_ouCombo.setValue((Object)this.m_cms.getRequestContext().getOuFqn());
                this.m_ouCombo.setEnabled(false);
                this.m_typeCombo.setValue((Object)CmsPrincipalSelect.WidgetType.groupwidget);
                this.m_typeCombo.setEnabled(false);
            }
            this.setContent((Component)vl);
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read principals", (Throwable)e);
        }
        this.m_closeButton = new Button(CmsVaadinUtils.messageClose());
        this.addButton((Component)this.m_closeButton);
        this.m_closeButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -3702402223196220788L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        this.m_ouCombo.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -5035831853626955191L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsPrincipalSelectDialog.this.initTable((CmsPrincipalSelect.WidgetType)((Object)CmsPrincipalSelectDialog.this.m_typeCombo.getValue()));
            }
        });
        this.m_typeCombo.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 645817336220889132L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsPrincipalSelectDialog.this.initTable((CmsPrincipalSelect.WidgetType)((Object)CmsPrincipalSelectDialog.this.m_typeCombo.getValue()));
                if (CmsPrincipalSelectDialog.this.m_selectField != null) {
                    if (CmsPrincipalSelect.WidgetType.groupwidget.equals(CmsPrincipalSelectDialog.this.m_typeCombo.getValue())) {
                        CmsPrincipalSelectDialog.this.m_selectField.setType("GROUP");
                    } else if (CmsPrincipalSelect.WidgetType.userwidget.equals(CmsPrincipalSelectDialog.this.m_typeCombo.getValue())) {
                        CmsPrincipalSelectDialog.this.m_selectField.setType("USER");
                    }
                }
            }
        });
        this.initTypeCombo(defaultView);
    }

    public static void openEmbeddedDialog(CmsEmbeddedDialogContext dialogContext, Map<String, String[]> params) {
        CmsPrincipalSelectDialog.openEmbeddedDialog(dialogContext, params, true);
    }

    public static void openEmbeddedDialog(final CmsEmbeddedDialogContext dialogContext, Map<String, String[]> params, boolean includeWebOus) {
        String[] param = params.get(PARAM_OU);
        String ou = param != null && param.length >= 1 ? param[0] : dialogContext.getCms().getRequestContext().getCurrentUser().getOuFqn();
        param = params.get(PARAM_REAL_ONLY);
        boolean realOnly = param != null && param.length >= 1 ? Boolean.parseBoolean(param[0]) : true;
        CmsPrincipalSelect.WidgetType type = CmsPrincipalSelect.WidgetType.groupwidget;
        param = params.get(PARAM_TYPE);
        if (param != null && param.length >= 1) {
            try {
                type = CmsPrincipalSelect.WidgetType.valueOf(param[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CmsPrincipalSelect.WidgetType startType = null;
        param = params.get(PARAM_START_TYPE);
        if (param != null && param.length >= 1) {
            try {
                startType = CmsPrincipalSelect.WidgetType.valueOf(param[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startType == null) {
            startType = type != CmsPrincipalSelect.WidgetType.principalwidget ? type : CmsPrincipalSelect.WidgetType.groupwidget;
        }
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        dialogContext.setWindow(window);
        CmsPrincipalSelectDialog dialog = new CmsPrincipalSelectDialog(null, ou, window, type, realOnly, startType, includeWebOus);
        dialog.setSelectHandler(new CmsPrincipalSelect.I_PrincipalSelectHandler(){

            @Override
            public void onPrincipalSelect(String principalType, String principalName) {
                dialogContext.setPrincipal(principalName);
            }
        });
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_PRINCIPALSELECTION_LIST_ACTION_SELECT_NAME_0", new Object[0]));
        window.setContent((Component)dialog);
        A_CmsUI.get().addWindow(window);
    }

    public void select(I_CmsPrincipal value) {
        if (this.m_selectField != null) {
            this.m_selectField.handlePrincipal(value);
        }
        if (this.m_selectHandler != null) {
            this.m_selectHandler.onPrincipalSelect(value.isGroup() ? "GROUP" : "USER", value.getName());
        }
        this.m_closeButton.click();
    }

    public void setOuComboBoxEnabled(boolean enabled) {
        this.m_ouCombo.setEnabled(enabled);
    }

    public void setSelectHandler(CmsPrincipalSelect.I_PrincipalSelectHandler selectHandler) {
        this.m_selectHandler = selectHandler;
    }

    void initTable(CmsPrincipalSelect.WidgetType type) {
        try {
            IndexedContainer data = this.getContainerForType(type, this.m_realOnly, (String)this.m_ouCombo.getValue());
            this.m_table.updateContainer(data);
            this.m_tableFilter.setValue("");
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read principals", (Throwable)e);
        }
    }

    private IndexedContainer getContainerForType(CmsPrincipalSelect.WidgetType type, boolean realOnly, String ou) throws CmsException {
        IndexedContainer res = null;
        ArrayList<FontIcon> icon = new ArrayList<FontIcon>();
        if (!OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER)) {
            List<CmsGroup> groups = OpenCms.getOrgUnitManager().getGroups(this.m_cms, this.m_cms.getRequestContext().getOuFqn(), false);
            return CmsVaadinUtils.getPrincipalContainer(A_CmsUI.getCmsObject(), groups, ID_CAPTION, ID_DESC, ID_ICON, ID_OU, "oc-icon-24-group", icon);
        }
        if (type.equals((Object)CmsPrincipalSelect.WidgetType.groupwidget) | type.equals((Object)CmsPrincipalSelect.WidgetType.principalwidget)) {
            List<CmsGroup> groups = OpenCms.getRoleManager().getManageableGroups(this.m_cms, ou, false);
            if (!realOnly) {
                groups.add(0, new CmsGroup(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, null, CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_ALLOTHERS_0", new Object[0]), 0));
                icon.add(new CmsCssIcon("oc-icon-24-principal-all"));
                if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.VFS_MANAGER)) {
                    groups.add(0, new CmsGroup(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, null, CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_OVERWRITEALL_0", new Object[0]), 0));
                    icon.add(0, new CmsCssIcon("oc-icon-24-principal-overwrite"));
                }
            }
            res = CmsVaadinUtils.getPrincipalContainer(A_CmsUI.getCmsObject(), groups, ID_CAPTION, ID_DESC, ID_ICON, ID_OU, "oc-icon-24-group", icon);
        }
        if (type.equals((Object)CmsPrincipalSelect.WidgetType.userwidget)) {
            List<CmsUser> users = OpenCms.getRoleManager().getManageableUsers(this.m_cms, ou, false, true);
            if (!realOnly) {
                CmsUser user = new CmsUser(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]), "", "", "", "", 0L, 0, 0L, null);
                user.setDescription(CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_ALLOTHERS_0", new Object[0]));
                users.add(0, user);
                icon.add(new CmsCssIcon("oc-icon-24-principal-all"));
                if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.VFS_MANAGER)) {
                    user = new CmsUser(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]), "", "", "", "", 0L, 0, 0L, null);
                    user.setDescription(CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_OVERWRITEALL_0", new Object[0]));
                    users.add(0, user);
                    icon.add(0, new CmsCssIcon("oc-icon-24-principal-overwrite"));
                }
            }
            res = CmsVaadinUtils.getPrincipalContainer(A_CmsUI.getCmsObject(), users, ID_CAPTION, ID_DESC, ID_ICON, ID_OU, "oc-icon-24-user", icon);
        }
        return res;
    }

    private void initTypeCombo(CmsPrincipalSelect.WidgetType defaultType) {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)"caption", String.class, (Object)"");
        Item item = container.addItem((Object)CmsPrincipalSelect.WidgetType.groupwidget);
        item.getItemProperty((Object)"caption").setValue((Object)CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_0", new Object[0]));
        item = container.addItem((Object)CmsPrincipalSelect.WidgetType.userwidget);
        item.getItemProperty((Object)"caption").setValue((Object)CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_0", new Object[0]));
        this.m_typeCombo.setContainerDataSource((Container)container);
        this.m_typeCombo.select((Object)defaultType);
        this.m_typeCombo.setEnabled(this.m_type.equals((Object)CmsPrincipalSelect.WidgetType.principalwidget) | this.m_type == null);
        this.m_typeCombo.setItemCaptionPropertyId((Object)"caption");
        this.m_typeCombo.setNullSelectionAllowed(false);
        this.m_typeCombo.setNewItemsAllowed(false);
    }
}

