/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.ui.Component;
import java.util.Optional;
import org.opencms.file.CmsObject;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.ui.favorites.I_CmsFavoriteContext;
import org.opencms.util.CmsUUID;

public class CmsExplorerFavoriteContext
implements I_CmsFavoriteContext {
    private Component m_dialog;
    private CmsFavoriteEntry m_entry;

    public CmsExplorerFavoriteContext(CmsObject cms, CmsFileExplorer explorer) {
        if (explorer != null) {
            CmsUUID currentFolder = explorer.getCurrentFolder();
            String siteRoot = cms.getRequestContext().getSiteRoot();
            CmsUUID project = cms.getRequestContext().getCurrentProject().getId();
            CmsFavoriteEntry entry = new CmsFavoriteEntry();
            entry.setType(CmsFavoriteEntry.Type.explorerFolder);
            entry.setSiteRoot(siteRoot);
            entry.setStructureId(currentFolder);
            entry.setProjectId(project);
            this.m_entry = entry;
        }
    }

    @Override
    public void close() {
        CmsVaadinUtils.getWindow(this.m_dialog).close();
    }

    @Override
    public Optional<CmsFavoriteEntry> getFavoriteForCurrentLocation() {
        return Optional.ofNullable(this.m_entry);
    }

    @Override
    public void openFavorite(CmsFavoriteEntry entry) {
        try {
            String url = entry.updateContextAndGetFavoriteUrl(A_CmsUI.getCmsObject());
            this.close();
            A_CmsUI.get().getPage().open(url, null);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void setDialog(Component component) {
        this.m_dialog = component;
    }
}

