/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.Label;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.editablegroup.CmsEditableGroupButtons;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.favorites.CmsFavoriteEntry;

public class CmsFavInfo
extends CustomLayout
implements I_CmsEditableGroupRow {
    private static final String BUTTON_CONTAINER = "buttonContainer";
    private static final Log LOG = CmsLog.getLog(CmsFavInfo.class);
    private static final long serialVersionUID = -1715926038770100307L;
    private Label m_bottomText = new Label();
    private Label m_buttonLabel = new Label();
    private CmsEditableGroupButtons m_buttons;
    private CmsFavoriteEntry m_entry;
    private CmsResourceIcon m_icon = new CmsResourceIcon();
    private Label m_projectLabel = new Label();
    private Label m_siteLabel = new Label();
    private Label m_topText = new Label();

    public CmsFavInfo(CmsFavoriteEntry entry) {
        try {
            this.initTemplateContentsFromInputStream(CmsVaadinUtils.readCustomLayout(CmsFavInfo.class, "favinfo.html"));
            this.addComponent((Component)this.m_topText, "topLabel");
            this.addComponent((Component)this.m_bottomText, "bottomLabel");
            this.addComponent((Component)this.m_icon, "icon");
            this.addComponent((Component)this.m_buttonLabel, BUTTON_CONTAINER);
            this.addComponent((Component)this.m_projectLabel, "projectLabel");
            this.addComponent((Component)this.m_siteLabel, "siteLabel");
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_entry = entry;
        this.addStyleName("o-pointer");
    }

    public Label getBottomLine() {
        return this.m_bottomText;
    }

    @Override
    public CmsEditableGroupButtons getButtonBar() {
        return this.m_buttons;
    }

    public Component getButtonWidget() {
        return this.getComponent(BUTTON_CONTAINER);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public CmsFavoriteEntry getEntry() {
        return this.m_entry;
    }

    public Label getProjectLabel() {
        return this.m_projectLabel;
    }

    public CmsResourceIcon getResourceIcon() {
        return this.m_icon;
    }

    public Label getSiteLabel() {
        return this.m_siteLabel;
    }

    public Label getTopLine() {
        return this.m_topText;
    }

    public void setButtons(CmsEditableGroupButtons buttons) {
        this.m_buttons = buttons;
        this.setButtonWidget((Component)this.m_buttons);
    }

    public void setButtonWidget(Component button) {
        this.addComponent(button, BUTTON_CONTAINER);
    }
}

