/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import com.vaadin.event.LayoutEvents;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.editablegroup.CmsDefaultActionHandler;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.CmsEditableGroupButtons;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.favorites.CmsFavInfo;
import org.opencms.ui.favorites.CmsFavoriteDAO;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.ui.favorites.I_CmsFavoriteContext;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsFavoriteDialog
extends CmsBasicDialog
implements CmsEditableGroup.I_RowBuilder {
    private static final Log LOG = CmsLog.getLog(CmsFavoriteDialog.class);
    private static final long serialVersionUID = 1L;
    private Button m_addButton;
    private Button m_cancelButton;
    private I_CmsFavoriteContext m_context;
    private Optional<CmsFavoriteEntry> m_currentLocation;
    private VerticalLayout m_favContainer;
    private CmsFavoriteDAO m_favDao;
    private CmsEditableGroup m_group;
    private Map<CmsUUID, String> m_projectLabels = new HashMap<CmsUUID, String>();
    private IndexedContainer m_sitesContainer;

    public CmsFavoriteDialog(I_CmsFavoriteContext context, CmsFavoriteDAO favDao) throws CmsException {
        this.m_favDao = favDao;
        this.m_context = context;
        context.setDialog((Component)this);
        this.m_sitesContainer = CmsVaadinUtils.getAvailableSitesContainer(A_CmsUI.getCmsObject(), "caption");
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        List<CmsFavoriteEntry> entries = this.m_favDao.loadFavorites();
        this.m_cancelButton.addClickListener((Button.ClickListener & Serializable)evt -> this.m_context.close());
        this.m_favContainer.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)evt -> {
            CmsFavoriteEntry entry = this.getEntry(evt.getChildComponent());
            if (entry != null) {
                this.m_context.openFavorite(entry);
            }
        });
        this.m_currentLocation = context.getFavoriteForCurrentLocation();
        this.m_addButton.setEnabled(this.m_currentLocation.isPresent());
        this.m_addButton.setCaption(CmsVaadinUtils.getMessageText("GUI_FAVORITES_ADD_BUTTON_0", new Object[0]));
        this.m_addButton.addClickListener((Button.ClickListener & Serializable)evt -> this.onClickAdd());
        this.m_favContainer.removeAllComponents();
        this.m_group = new CmsEditableGroup((AbstractOrderedLayout)this.m_favContainer, null, new EmptyHandler());
        this.m_group.setAddButtonVisible(false);
        this.m_group.setRowBuilder(this);
        this.m_group.init();
        for (CmsFavoriteEntry favEntry : entries) {
            try {
                CmsFavInfo favInfo = this.createFavInfo(favEntry);
                this.m_group.addRow(favInfo);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public CmsFavInfo buildRow(CmsEditableGroup group, Component component) {
        CmsFavInfo info = (CmsFavInfo)component;
        CmsEditableGroupButtons buttons = new CmsEditableGroupButtons(new SaveAfterChangeActionHandler((I_CmsEditableGroupRow)info));
        info.setButtons(buttons);
        return info;
    }

    protected void doSave() {
        List<CmsFavoriteEntry> entries = this.getEntries();
        try {
            this.m_favDao.saveFavorites(entries);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    protected void enableMaxHeight() {
    }

    List<CmsFavoriteEntry> getEntries() {
        ArrayList<CmsFavoriteEntry> result = new ArrayList<CmsFavoriteEntry>();
        for (I_CmsEditableGroupRow row : this.m_group.getRows()) {
            CmsFavoriteEntry entry = ((CmsFavInfo)row).getEntry();
            result.add(entry);
        }
        return result;
    }

    private CmsFavInfo createFavInfo(CmsFavoriteEntry entry) throws CmsException {
        String title = "";
        String subtitle = "";
        CmsFavInfo result = new CmsFavInfo(entry);
        CmsObject cms = A_CmsUI.getCmsObject();
        String project = this.getProject(cms, entry);
        String site = this.getSite(cms, entry);
        try {
            CmsUUID idToLoad = entry.getDetailId() != null ? entry.getDetailId() : entry.getStructureId();
            CmsResource resource = cms.readResource(idToLoad, CmsResourceFilter.IGNORE_EXPIRATION.addRequireVisible());
            CmsResourceUtil resutil = new CmsResourceUtil(cms, resource);
            switch (entry.getType()) {
                case explorerFolder: {
                    title = CmsStringUtil.isEmpty(resutil.getTitle()) ? CmsResource.getName(resource.getRootPath()) : resutil.getTitle();
                    break;
                }
                case page: {
                    title = resutil.getTitle();
                }
            }
            subtitle = resource.getRootPath();
            CmsResourceIcon icon = result.getResourceIcon();
            icon.initContent(resutil, CmsResource.STATE_UNCHANGED, false, false);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        result.getTopLine().setValue(title);
        result.getBottomLine().setValue(subtitle);
        result.getProjectLabel().setValue(project);
        result.getSiteLabel().setValue(site);
        return result;
    }

    private CmsFavoriteEntry getEntry(Component row) {
        if (row instanceof CmsFavInfo) {
            return ((CmsFavInfo)row).getEntry();
        }
        return null;
    }

    private String getProject(CmsObject cms, CmsFavoriteEntry entry) throws CmsException {
        String result = this.m_projectLabels.get(entry.getProjectId());
        if (result == null) {
            result = cms.readProject(entry.getProjectId()).getName();
            this.m_projectLabels.put(entry.getProjectId(), result);
        }
        return result;
    }

    private String getSite(CmsObject cms, CmsFavoriteEntry entry) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(entry.getSiteRoot());
        Item item = this.m_sitesContainer.getItem((Object)entry.getSiteRoot());
        if (item != null) {
            return (String)item.getItemProperty((Object)"caption").getValue();
        }
        String result = entry.getSiteRoot();
        if (site != null && !CmsStringUtil.isEmpty(site.getTitle())) {
            result = site.getTitle();
        }
        return result;
    }

    private void onClickAdd() {
        if (this.m_currentLocation.isPresent()) {
            CmsFavoriteEntry entry = this.m_currentLocation.get();
            List<CmsFavoriteEntry> entries = this.getEntries();
            entries.add(entry);
            try {
                this.m_favDao.saveFavorites(entries);
            }
            catch (Exception e) {
                CmsErrorDialog.showErrorDialog(e);
            }
            this.m_context.close();
        }
    }

    class EmptyHandler
    implements CmsEditableGroup.I_EmptyHandler {
        private CmsEditableGroup m_groupForHandler;
        private Label m_placeholder;

        EmptyHandler() {
        }

        @Override
        public void init(CmsEditableGroup group) {
            String message = CmsVaadinUtils.getMessageText("GUI_FAVORITES_EMPTY_LIST_PLACEHOLDER_0", new Object[0]);
            this.m_groupForHandler = group;
            this.m_placeholder = new Label();
            this.m_placeholder.setContentMode(ContentMode.HTML);
            String spacer = "<div></div>";
            String content = "<div>" + CmsEncoder.escapeXml(message) + "</div>";
            this.m_placeholder.setValue(spacer + content + spacer);
            this.m_placeholder.addStyleName("o-bookmarks-placeholder");
            this.m_placeholder.setHeight("100%");
        }

        @Override
        public void setEmpty(boolean empty) {
            if (!this.m_placeholder.isAttached()) {
                this.m_groupForHandler.getContainer().addComponent((Component)this.m_placeholder);
                this.m_groupForHandler.getContainer().setExpandRatio((Component)this.m_placeholder, 1.0f);
            }
            this.m_groupForHandler.getContainer().setHeight(empty ? "100%" : null);
            this.m_placeholder.setVisible(empty);
        }
    }

    public class SaveAfterChangeActionHandler
    extends CmsDefaultActionHandler {
        public SaveAfterChangeActionHandler(I_CmsEditableGroupRow row) {
            super(CmsFavoriteDialog.this.m_group, row);
        }

        @Override
        public void onAdd() {
            super.onAdd();
            CmsFavoriteDialog.this.doSave();
        }

        @Override
        public void onDelete() {
            super.onDelete();
            CmsFavoriteDialog.this.doSave();
        }

        @Override
        public void onDown() {
            super.onDown();
            CmsFavoriteDialog.this.doSave();
        }

        @Override
        public void onUp() {
            super.onUp();
            CmsFavoriteDialog.this.doSave();
        }
    }
}

