/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.favorites;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsUUID;

public class CmsFavoriteEntry {
    public static final String JSON_DETAIL = "d";
    public static final String JSON_PROJECT = "p";
    public static final String JSON_SITEROOT = "s";
    public static final String JSON_STRUCTUREID = "i";
    public static final String JSON_TYPE = "t";
    private CmsUUID m_detailId;
    private CmsUUID m_projectId;
    private String m_siteRoot;
    private CmsUUID m_structureId;
    private Type m_type;

    public CmsFavoriteEntry() {
    }

    public CmsFavoriteEntry(JSONObject obj) {
        this.m_detailId = CmsFavoriteEntry.readId(obj, JSON_DETAIL);
        this.m_projectId = CmsFavoriteEntry.readId(obj, JSON_PROJECT);
        this.setSiteRoot(obj.optString(JSON_SITEROOT));
        this.m_structureId = CmsFavoriteEntry.readId(obj, JSON_STRUCTUREID);
        this.m_type = Type.fromJsonId(obj.optString(JSON_TYPE));
    }

    public static CmsUUID readId(JSONObject obj, String key) {
        String strValue = obj.optString(key);
        if (!CmsUUID.isValidUUID(strValue)) {
            return null;
        }
        return new CmsUUID(strValue);
    }

    public CmsUUID getDetailId() {
        return this.m_detailId;
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public Type getType() {
        return this.m_type;
    }

    public void setDetailId(CmsUUID detailId) {
        this.m_detailId = detailId;
    }

    public void setProjectId(CmsUUID projectId) {
        this.m_projectId = projectId;
    }

    public void setSiteRoot(String siteRoot) {
        if (siteRoot != null) {
            siteRoot = siteRoot.replaceFirst("/$", "");
        }
        this.m_siteRoot = siteRoot;
    }

    public void setStructureId(CmsUUID structureId) {
        this.m_structureId = structureId;
    }

    public void setType(Type type) {
        this.m_type = type;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject result = new JSONObject();
        if (this.m_detailId != null) {
            result.put(JSON_DETAIL, "" + this.m_detailId);
        }
        if (this.m_siteRoot != null) {
            result.put(JSON_SITEROOT, this.m_siteRoot);
        }
        if (this.m_structureId != null) {
            result.put(JSON_STRUCTUREID, "" + this.m_structureId);
        }
        if (this.m_projectId != null) {
            result.put(JSON_PROJECT, "" + this.m_projectId);
        }
        if (this.m_type != null) {
            result.put(JSON_TYPE, "" + this.m_type.getJsonId());
        }
        return result;
    }

    public String updateContextAndGetFavoriteUrl(CmsObject cms) throws CmsException {
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
        CmsProject project = null;
        switch (this.getType()) {
            case explorerFolder: {
                CmsResource folder = cms.readResource(this.getStructureId(), filter);
                project = cms.readProject(this.getProjectId());
                cms.getRequestContext().setSiteRoot(this.getSiteRoot());
                cms.getRequestContext().setCurrentProject(project);
                String explorerLink = CmsVaadinUtils.getWorkplaceLink() + "#!" + "explorer" + "/" + this.getProjectId() + "!!" + this.getSiteRoot() + "!!" + cms.getSitePath(folder);
                return explorerLink;
            }
            case page: {
                project = cms.readProject(this.getProjectId());
                CmsResource target = cms.readResource(this.getStructureId(), filter);
                CmsResource detailContent = null;
                String link = null;
                cms.getRequestContext().setCurrentProject(project);
                cms.getRequestContext().setSiteRoot(this.getSiteRoot());
                if (this.getDetailId() != null) {
                    detailContent = cms.readResource(this.getDetailId());
                    link = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, cms.getSitePath(detailContent), cms.getSitePath(target), false);
                } else {
                    link = OpenCms.getLinkManager().substituteLink(cms, target);
                }
                return link;
            }
        }
        return null;
    }

    public static enum Type {
        explorerFolder("f"),
        page("p");

        private String m_jsonId;

        private Type(String jsonId) {
            this.m_jsonId = jsonId;
        }

        public static Type fromJsonId(String id) {
            for (Type type : Type.values()) {
                if (!type.getJsonId().equals(id)) continue;
                return type;
            }
            return null;
        }

        public String getJsonId() {
            return this.m_jsonId;
        }
    }
}

