/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.ui.login.CmsInactiveUserMessages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsLockInactiveAccountsJob
implements I_CmsScheduledJob {
    private static final Log LOG = CmsLog.getLog(CmsLockInactiveAccountsJob.class);

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        List<CmsUser> users = OpenCms.getOrgUnitManager().getUsersWithoutAdditionalInfo(cms, "", true);
        ArrayList<String> lockedUsers = new ArrayList<String>();
        Locale locale = CmsLocaleManager.getDefaultLocale();
        boolean testOnly = Boolean.parseBoolean(parameters.get("test"));
        for (CmsUser user : users) {
            try {
                if (!OpenCms.getLoginManager().canLockBecauseOfInactivity(cms, user) || !OpenCms.getLoginManager().checkInactive(user) || (user = cms.readUser(user.getId())).getAdditionalInfo().get("accountLocked") != null) continue;
                LOG.info((Object)("User is inactive: " + user.getName()));
                if (!testOnly) {
                    user.getAdditionalInfo().put("accountLocked", "true");
                    cms.writeUser(user);
                }
                lockedUsers.add(user.getDisplayName(cms, locale));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String mailto = parameters.get("mailto");
        if (mailto != null && !lockedUsers.isEmpty()) {
            List<String> mailAddresses = CmsStringUtil.splitAsList(mailto, ",");
            OpenCms.getLocaleManager();
            String header = CmsInactiveUserMessages.getReportHeader(locale);
            String subject = CmsInactiveUserMessages.getReportSubject(locale);
            CmsHtmlMail mail = new CmsHtmlMail();
            mail.setSubject(subject);
            for (String address : mailAddresses) {
                mail.addTo(address.trim());
            }
            String templateText = new String(CmsFileUtil.readFully(this.getClass().getResourceAsStream("locked-users-report.html")), "UTF-8");
            StringTemplate template = new StringTemplate(templateText);
            template.setAttribute("header", (Object)header);
            template.setAttribute("users", lockedUsers);
            template.toString();
            mail.setHtmlMsg(template.toString());
            try {
                mail.send();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return "";
    }
}

