/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.google.common.collect.Lists;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Notification;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.sitemap.CmsSitemapTreeController;
import org.opencms.ui.sitemap.CmsSitemapTreeNode;
import org.opencms.ui.sitemap.CmsSitemapUI;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsLocaleComparePanel
extends VerticalLayout
implements I_CmsLocaleCompareContext {
    public static final Resource MAIN_LOCALE_ICON = FontOpenCms.CIRCLE_INFO;
    private static final Log LOG = CmsLog.getLog(CmsLocaleComparePanel.class);
    private static final long serialVersionUID = 1L;
    protected CssLayout m_treeContainer = new CssLayout();
    private Locale m_comparisonLocale;
    private ComboBox m_comparisonLocaleSelector;
    private CmsResource m_currentRoot;
    private boolean m_handlingLocaleChange;
    private Locale m_rootLocale;
    private ComboBox m_rootLocaleSelector;

    public CmsLocaleComparePanel(String id) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(A_CmsUI.getCmsObject());
        A_CmsUI.get().setLocale(locale);
        try {
            this.initialize(new CmsUUID(id), null);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public Locale getComparisonLocale() {
        return this.m_comparisonLocale;
    }

    public List<Locale> getComparisonLocales() {
        CmsObject cms = A_CmsUI.getCmsObject();
        cms.getLocaleGroupService();
        List<Locale> result = CmsLocaleGroupService.getPossibleLocales(cms, this.m_currentRoot);
        return result;
    }

    @Override
    public CmsLocaleGroup getLocaleGroup() {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsLocaleGroupService service = cms.getLocaleGroupService();
            return service.readLocaleGroup(this.m_currentRoot);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public CmsResource getRoot() {
        return this.m_currentRoot;
    }

    @Override
    public Locale getRootLocale() {
        return this.m_rootLocale;
    }

    public void initialize(CmsUUID id, Locale initialComparisonLocale) throws CmsException {
        Locale rootLocale;
        CmsResource res;
        this.removeAllComponents();
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_currentRoot = res = cms.readResource(id);
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(res.getRootPath());
        this.m_rootLocale = rootLocale = OpenCms.getLocaleManager().getDefaultLocale(cms, res);
        Locale mainLocale = site.getMainTranslationLocale(null);
        List<Locale> secondaryLocales = site.getSecondaryTranslationLocales();
        List<Locale> possibleLocaleSelections = this.getMainLocaleSelectOptions(cms, res, mainLocale, secondaryLocales);
        this.m_rootLocaleSelector = new ComboBox();
        this.m_rootLocaleSelector.addStyleName("o-sitemap-localeselect");
        this.m_rootLocaleSelector.setNullSelectionAllowed(false);
        for (Locale selectableLocale : possibleLocaleSelections) {
            this.m_rootLocaleSelector.addItem((Object)selectableLocale);
            this.m_rootLocaleSelector.setItemIcon((Object)selectableLocale, (Resource)FontOpenCms.SPACE);
            this.m_rootLocaleSelector.setItemCaption((Object)selectableLocale, selectableLocale.getDisplayName(A_CmsUI.get().getLocale()));
        }
        this.m_rootLocaleSelector.setItemIcon((Object)mainLocale, MAIN_LOCALE_ICON);
        this.m_rootLocaleSelector.setValue((Object)this.m_rootLocale);
        this.m_rootLocaleSelector.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (!CmsLocaleComparePanel.this.m_handlingLocaleChange) {
                    CmsLocaleComparePanel.this.m_handlingLocaleChange = true;
                    try {
                        Locale newLocale = (Locale)event.getProperty().getValue();
                        CmsLocaleComparePanel.this.switchToLocale(newLocale);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        CmsErrorDialog.showErrorDialog(e);
                    }
                    finally {
                        CmsLocaleComparePanel.this.m_handlingLocaleChange = false;
                    }
                }
            }
        });
        this.m_comparisonLocaleSelector = new ComboBox();
        this.m_comparisonLocaleSelector.addStyleName("o-sitemap-localeselect");
        this.m_comparisonLocaleSelector.setNullSelectionAllowed(false);
        List<Locale> comparisonLocales = this.getComparisonLocales();
        Locale selectedComparisonLocale = null;
        for (Locale comparisonLocale : comparisonLocales) {
            this.m_comparisonLocaleSelector.addItem((Object)comparisonLocale);
            this.m_comparisonLocaleSelector.setItemIcon((Object)comparisonLocale, (Resource)FontOpenCms.SPACE);
            this.m_comparisonLocaleSelector.setItemCaption((Object)comparisonLocale, comparisonLocale.getDisplayName(A_CmsUI.get().getLocale()));
            if (selectedComparisonLocale == null && !comparisonLocale.equals(this.m_rootLocale)) {
                selectedComparisonLocale = comparisonLocale;
            }
            if (initialComparisonLocale == null || !comparisonLocale.equals(initialComparisonLocale) || comparisonLocale.equals(this.m_rootLocale)) continue;
            selectedComparisonLocale = comparisonLocale;
        }
        this.m_comparisonLocale = selectedComparisonLocale;
        this.m_comparisonLocaleSelector.setValue(selectedComparisonLocale);
        this.m_comparisonLocaleSelector.setItemIcon((Object)mainLocale, MAIN_LOCALE_ICON);
        this.m_comparisonLocaleSelector.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChange(Property.ValueChangeEvent event) {
                if (!CmsLocaleComparePanel.this.m_handlingLocaleChange) {
                    CmsLocaleComparePanel.this.m_handlingLocaleChange = true;
                    try {
                        Locale locale = (Locale)event.getProperty().getValue();
                        if (CmsLocaleComparePanel.this.m_rootLocale.equals(locale)) {
                            Locale oldComparisonLocale = CmsLocaleComparePanel.this.m_comparisonLocale;
                            if (CmsLocaleComparePanel.this.getLocaleGroup().getResourcesByLocale().keySet().contains(oldComparisonLocale)) {
                                CmsLocaleComparePanel.this.m_comparisonLocale = locale;
                                CmsLocaleComparePanel.this.switchToLocale(oldComparisonLocale);
                                CmsLocaleComparePanel.this.updateLocaleWidgets();
                            } else {
                                Notification.show((String)CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_CANNOT_SWITCH_COMPARISON_LOCALE_0", new Object[0]));
                                CmsLocaleComparePanel.this.m_comparisonLocaleSelector.setValue((Object)oldComparisonLocale);
                            }
                        } else {
                            CmsLocaleComparePanel.this.m_comparisonLocale = locale;
                            CmsLocaleComparePanel.this.updateLocaleWidgets();
                            CmsLocaleComparePanel.this.initTree(CmsLocaleComparePanel.this.m_currentRoot);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        CmsErrorDialog.showErrorDialog(e);
                    }
                    finally {
                        CmsLocaleComparePanel.this.m_handlingLocaleChange = false;
                    }
                }
            }
        });
        CssLayout localeSelectors = new CssLayout();
        localeSelectors.addStyleName("o-sitemap-locale-bar");
        this.m_rootLocaleSelector.setCaption(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_MAIN_LOCALE_0", new Object[0]));
        this.m_comparisonLocaleSelector.setCaption(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_COMPARISON_LOCALE_0", new Object[0]));
        localeSelectors.setWidth("100%");
        localeSelectors.addComponent((Component)this.m_rootLocaleSelector);
        localeSelectors.addComponent((Component)this.m_comparisonLocaleSelector);
        this.setSpacing(true);
        this.addComponent((Component)localeSelectors);
        this.addComponent((Component)this.m_treeContainer);
        this.m_treeContainer.setWidth("100%");
        this.initTree(res);
    }

    @Override
    public void refreshAll() {
        try {
            this.initialize(this.m_currentRoot.getStructureId(), this.m_comparisonLocale);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    public void switchToLocale(Locale locale) throws CmsException {
        CmsResource localeVariant;
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsLocaleGroupService groupService = cms.getLocaleGroupService();
        CmsLocaleGroup localeGroup = groupService.readDefaultFileLocaleGroup(this.m_currentRoot);
        Collection<CmsResource> resources = localeGroup.getResourcesForLocale(locale);
        if (resources.isEmpty()) {
            LOG.error((Object)("Can not switch to locale " + locale + ": no page found in locale group of " + this.m_currentRoot.getRootPath()));
        }
        if (!(localeVariant = resources.iterator().next()).isFolder()) {
            CmsResource parentFolder = cms.readParentFolder(localeVariant.getStructureId());
            if (this.m_comparisonLocale.equals(locale)) {
                this.m_comparisonLocale = this.m_rootLocale;
                this.m_rootLocale = locale;
            } else {
                this.m_rootLocale = locale;
            }
            this.updateLocaleWidgets();
            this.initTree(parentFolder);
        } else {
            LOG.error((Object)("locale variant should not be a folder: " + localeVariant.getRootPath()));
        }
    }

    protected void initTree(CmsResource rootRes) throws CmsException {
        this.m_currentRoot = rootRes;
        this.m_treeContainer.removeAllComponents();
        this.showHeader();
        CmsSitemapTreeController controller = new CmsSitemapTreeController(A_CmsUI.getCmsObject(), rootRes, this, (Component)this.m_treeContainer);
        JavaScript.eval((String)("cmsLocaleCompareRoot='" + rootRes.getStructureId() + "'"));
        CmsSitemapUI ui = (CmsSitemapUI)A_CmsUI.get();
        ui.getSitemapExtension().setSitemapTreeController(controller);
        CmsSitemapTreeNode root1 = controller.createRootNode();
        controller.initEventHandlers(root1);
        this.m_treeContainer.addComponent((Component)root1);
        controller.onClickOpen(root1);
    }

    protected void updateLocaleWidgets() {
        this.m_rootLocaleSelector.setValue((Object)this.m_rootLocale);
        this.m_comparisonLocaleSelector.setValue((Object)this.m_comparisonLocale);
    }

    private List<Locale> getMainLocaleSelectOptions(CmsObject cms, CmsResource res, Locale mainLocale, List<Locale> secondaryLocales) {
        try {
            CmsLocaleGroup localeGroup = cms.getLocaleGroupService().readDefaultFileLocaleGroup(res);
            ArrayList result = Lists.newArrayList();
            if (localeGroup.hasLocale(mainLocale)) {
                result.add(mainLocale);
            }
            for (Locale locale : secondaryLocales) {
                if (!localeGroup.hasLocale(locale)) continue;
                result.add(locale);
            }
            return result;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private void showHeader() throws CmsException {
        CmsSitemapUI ui = (CmsSitemapUI)A_CmsUI.get();
        String title = null;
        String description = null;
        String path = null;
        String locale = this.m_rootLocale.toString();
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsResource targetRes = this.getRoot();
        if (targetRes.isFolder() && (targetRes = cms.readDefaultFile(targetRes, CmsResourceFilter.IGNORE_EXPIRATION)) == null) {
            targetRes = this.getRoot();
        }
        CmsResourceUtil resUtil = new CmsResourceUtil(cms, this.getRoot());
        title = resUtil.getTitle();
        description = resUtil.getGalleryDescription(A_CmsUI.get().getLocale());
        path = OpenCms.getLinkManager().getServerLink(cms, cms.getRequestContext().removeSiteRoot(targetRes.getRootPath()));
        String iconClasses = CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(cms, this.getRoot()), this.getRoot().getName(), false);
        ui.getSitemapExtension().showInfoHeader(title, description, path, locale, iconClasses);
    }
}

