/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.util.table;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.vaadin.data.util.BeanUtil;
import com.vaadin.ui.Button;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.ui.Table;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.util.table.Column;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

public class CmsBeanTableBuilder<T> {
    private static final Log LOG = CmsLog.getLog(CmsBeanTableBuilder.class);
    private Class<T> m_class;
    private List<ColumnBean> m_columns = Lists.newArrayList();
    private CmsMacroResolver m_macroResolver = new CmsMacroResolver();
    private String m_view;

    public CmsBeanTableBuilder(Class<T> cls, String view) {
        this.m_class = cls;
        this.m_view = view;
        try {
            List descriptors = BeanUtil.getBeanPropertyDescriptors(this.m_class);
            for (PropertyDescriptor desc : descriptors) {
                Column columnInfo;
                Method getter = desc.getReadMethod();
                if (getter == null || (columnInfo = getter.getAnnotation(Column.class)) == null || columnInfo.view() != null && !this.matchView(this.m_view, columnInfo.view())) continue;
                this.m_columns.add(new ColumnBean(desc, columnInfo));
            }
            Collections.sort(this.m_columns, new Comparator<ColumnBean>(){

                @Override
                public int compare(ColumnBean col1, ColumnBean col2) {
                    return ComparisonChain.start().compare(col1.getInfo().order(), col2.getInfo().order()).result();
                }
            });
        }
        catch (IntrospectionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isProbablyMessageKey(String str) {
        return str.matches("^[A-Z]+_[A-Z0-9_]*$");
    }

    public static <V> CmsBeanTableBuilder<V> newInstance(Class<V> cls) {
        return new CmsBeanTableBuilder<V>(cls, null);
    }

    public static <V> CmsBeanTableBuilder<V> newInstance(Class<V> cls, String view) {
        return new CmsBeanTableBuilder<V>(cls, view);
    }

    public Table buildTable(List<T> beans) {
        Table table = new Table();
        this.buildTable(table, beans);
        return table;
    }

    public void buildTable(Table table, List<T> beans) {
        BeanItemContainer container = new BeanItemContainer(this.m_class);
        ArrayList visibleCols = Lists.newArrayList();
        for (ColumnBean column : this.m_columns) {
            String propName = column.getProperty().getName();
            String columnHeader = column.getInfo().header();
            String localizedHeader = CmsVaadinUtils.getMessageText(columnHeader, new Object[0]);
            if (CmsMessages.isUnknownKey(localizedHeader)) {
                localizedHeader = columnHeader;
            }
            localizedHeader = this.m_macroResolver.resolveMacros(localizedHeader);
            table.setColumnHeader((Object)propName, localizedHeader);
            if (Button.class.isAssignableFrom(column.getProperty().getPropertyType())) {
                table.setColumnAlignment((Object)propName, Table.Align.CENTER);
            }
            visibleCols.add(propName);
        }
        table.setContainerDataSource((Container)container);
        table.setVisibleColumns(visibleCols.toArray());
        for (ColumnBean column : this.m_columns) {
            Column info = column.getInfo();
            String name = column.getProperty().getName();
            if (info.width() >= 0) {
                table.setColumnWidth((Object)name, info.width());
            }
            if (!(info.expandRatio() >= 0.0f)) continue;
            table.setColumnExpandRatio((Object)name, info.expandRatio());
        }
        for (ColumnBean bean : beans) {
            container.addBean((Object)bean);
        }
    }

    public Table.CellStyleGenerator getDefaultCellStyleGenerator() {
        return new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                for (ColumnBean colBean : CmsBeanTableBuilder.this.m_columns) {
                    if (!colBean.getProperty().getName().equals(propertyId)) continue;
                    return colBean.getInfo().styleName();
                }
                return "";
            }
        };
    }

    public Container.Filter getDefaultFilter(final String filterString) {
        return new Container.Filter(){
            private static final long serialVersionUID = 1L;

            public boolean appliesToProperty(Object propertyId) {
                for (ColumnBean col : CmsBeanTableBuilder.this.m_columns) {
                    if (!col.getProperty().getName().equals(propertyId) || !col.getInfo().filterable()) continue;
                    return true;
                }
                return false;
            }

            public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
                if (CmsStringUtil.isEmpty(filterString)) {
                    return true;
                }
                Object bean = itemId;
                for (ColumnBean col : CmsBeanTableBuilder.this.m_columns) {
                    if (!col.getInfo().filterable() || !("" + item.getItemProperty((Object)col.getProperty().getName()).getValue()).toLowerCase().contains(filterString)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public CmsMacroResolver getMacroResolver() {
        return this.m_macroResolver;
    }

    public void setMacroResolver(CmsMacroResolver resolver) {
        this.m_macroResolver = resolver;
    }

    private boolean matchView(String actualView, String declaredView) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(declaredView) || CmsStringUtil.isEmptyOrWhitespaceOnly(actualView)) {
            return true;
        }
        return CmsStringUtil.splitAsList(declaredView, "|").contains(actualView);
    }

    private class ColumnBean {
        private Column m_info;
        private PropertyDescriptor m_property;

        public ColumnBean(PropertyDescriptor property, Column info) {
            this.m_property = property;
            this.m_info = info;
        }

        public Column getInfo() {
            return this.m_info;
        }

        public PropertyDescriptor getProperty() {
            return this.m_property;
        }
    }
}

