/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.LazyMap;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;

public final class CmsCollectionsGenericWrapper {
    private CmsCollectionsGenericWrapper() {
    }

    public static <K, V> Map<K, V> createLazyMap(Transformer T) {
        return new MapWrapper(LazyMap.decorate(new HashMap(), (Transformer)T));
    }

    public static <K, V> Map<K, V> createLRUMap() {
        return new LRUMap();
    }

    public static <K, V> Map<K, V> createLRUMap(int size) {
        return new LRUMap(size);
    }

    public static <K> Enumeration<K> enumeration(Enumeration<?> enumeration) {
        return enumeration;
    }

    public static <K> List<K> list(Object o) {
        return (List)o;
    }

    public static <K, V> Map<K, V> map(Object o) {
        return (Map)o;
    }

    public static class MapWrapper<K, V>
    implements Map<K, V> {
        private Map<K, V> m_map;

        MapWrapper(Map<K, V> map) {
            this.m_map = map;
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            V value = this.m_map.get(key);
            if (value instanceof CmsJspContentAccessValueWrapper) {
                return ((CmsJspContentAccessValueWrapper)value).getExists();
            }
            return value != null;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m_map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.m_map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.m_map.equals(o);
        }

        @Override
        public V get(Object key) {
            return this.m_map.get(key);
        }

        @Override
        public int hashCode() {
            return this.m_map.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.m_map.keySet();
        }

        @Override
        public V put(K key, V value) {
            return this.m_map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.m_map.putAll(m);
        }

        @Override
        public V remove(Object key) {
            return this.m_map.remove(key);
        }

        @Override
        public int size() {
            return this.m_map.size();
        }

        @Override
        public Collection<V> values() {
            return this.m_map.values();
        }
    }
}

