/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.util.CmsNoAutoCloseTag;
import org.opencms.util.Messages;

public class CmsHtmlValidator
extends NodeVisitor {
    private static final Set<String> AUTOCLOSE_TAGS = new HashSet<String>();
    private static final String[] NO_AUTOCLOSE_TAGS = new String[]{"APPLET", "BLOCKQUOTE", "BODY", "LI", "UL", "OL", "DL", "DD", "DT", "DIV", "FORM", "FRAMESET", "HTML", "H1", "H2", "H3", "H4", "H5", "H6", "HEAD", "LABEL", "A", "OBJECT", "OPTION", "P", "SCRIPT", "NOSCRIPT", "SELECT", "SPAN", "STYLE", "TD", "TR", "TBODY", "TFOOT", "THEAD", "TEXTAREA", "TITLE"};
    private List<CmsMessageContainer> m_messages = new ArrayList<CmsMessageContainer>();
    private int m_rootElementCount;
    private Stack<String> m_stack = new Stack();
    private int m_unbalancedClosedTags;
    private int m_unbalancedOpenedTags;

    public List<CmsMessageContainer> getMessages() {
        return this.m_messages;
    }

    public int getRootElementCount() {
        return this.m_rootElementCount;
    }

    public boolean isBalanced() {
        System.out.println("Unbalanced opened " + this.m_unbalancedOpenedTags + " tags, unbalanced closed " + this.m_unbalancedClosedTags + " tags.");
        return this.m_unbalancedOpenedTags == 0 && this.m_unbalancedClosedTags == 0;
    }

    public void validate(String html) throws ParserException {
        this.m_unbalancedClosedTags = 0;
        this.m_unbalancedOpenedTags = 0;
        this.m_rootElementCount = 0;
        this.m_stack.clear();
        this.m_messages.clear();
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(html, "UTF-8");
        lexer.setPage(page);
        parser.setLexer(lexer);
        PrototypicalNodeFactory factory = this.configureNoAutoCorrectionTags();
        lexer.setNodeFactory((NodeFactory)factory);
        parser.visitAllNodesWith((NodeVisitor)this);
    }

    public void visitEndTag(Tag tag) {
        String tagName = tag.getTagName();
        if (tagName.equals(this.m_stack.peek())) {
            this.m_stack.pop();
        } else if (this.m_stack.contains(tagName)) {
            while (!tagName.equals(this.m_stack.peek())) {
                String enclosedTag = this.m_stack.pop();
                if (AUTOCLOSE_TAGS.contains(enclosedTag)) {
                    System.out.println("Unbalanced void tag " + enclosedTag + ", will be ignored.");
                    continue;
                }
                System.out.println("Unbalanced opening tag: " + enclosedTag);
                this.m_messages.add(Messages.get().container("ERR_UNBALANCED_OPENING_TAG_1", enclosedTag));
                ++this.m_unbalancedOpenedTags;
            }
            this.m_stack.pop();
        } else {
            System.out.println("Unbalanced closing tag: " + tagName);
            this.m_messages.add(Messages.get().container("ERR_UNBALANCED_CLOSING_TAG_1", tagName));
            ++this.m_unbalancedClosedTags;
        }
    }

    public void visitTag(Tag tag) {
        if (this.m_stack.isEmpty()) {
            ++this.m_rootElementCount;
        }
        if (!tag.isEmptyXmlTag()) {
            this.m_stack.push(tag.getTagName());
        }
    }

    protected PrototypicalNodeFactory configureNoAutoCorrectionTags() {
        PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
        CmsNoAutoCloseTag noAutoCloseTag = new CmsNoAutoCloseTag(NO_AUTOCLOSE_TAGS);
        factory.unregisterTag((Tag)noAutoCloseTag);
        factory.registerTag((Tag)noAutoCloseTag);
        return factory;
    }

    static {
        Collections.addAll(AUTOCLOSE_TAGS, "AREA", "BASE", "BR", "COL", "EMBED", "HR", "IMG", "INPUT", "KEYGEN", "LINK", "MENUITEM", "META", "PARAM", "SOURCE", "TRACK", "WBR");
    }
}

