/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public final class CmsLog4jUtil {
    private CmsLog4jUtil() {
    }

    public static List<Logger> getAllLoggers() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        TreeMap<String, Logger> loggersByName = new TreeMap<String, Logger>();
        for (Logger logger : context.getLoggers()) {
            String loggerName = logger.getName();
            while (loggerName != null) {
                if (!loggersByName.containsKey(loggerName)) {
                    Logger currentLogger = (Logger)LogManager.getLogger((String)loggerName);
                    loggersByName.put(loggerName, currentLogger);
                }
                loggerName = CmsLog4jUtil.getParentLoggerName(loggerName);
            }
        }
        return new ArrayList<Logger>(loggersByName.values());
    }

    public static String getParentLoggerName(String loggerName) {
        int dotIndex = loggerName.lastIndexOf(".");
        if (dotIndex < 0) {
            return null;
        }
        return loggerName.substring(0, dotIndex);
    }
}

