/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRfsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.Messages;

public class CmsRfsFileViewer
implements Cloneable {
    protected static final Log LOG = CmsLog.getLog(CmsRfsFileViewer.class);
    protected String m_filePath;
    protected String m_rootPath = this.getLogFolderPath();
    protected int m_windowPos;
    protected int m_windowSize = 1000;
    private List<String> m_additionalRoots;
    private boolean m_enabled = true;
    private Charset m_fileEncoding = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
    private boolean m_frozen;
    private boolean m_isLogfile = true;

    public Object clone() {
        if (this.m_filePath == null && OpenCms.getRunLevel() >= 3) {
            this.m_filePath = OpenCms.getSystemInfo().getLogFileRfsPath();
        }
        if (this.m_rootPath == null) {
            this.m_rootPath = this.getLogFolderPath();
        }
        CmsRfsFileViewer clone = new CmsRfsFileViewer();
        clone.m_rootPath = this.m_rootPath;
        try {
            clone.setFilePath(this.m_filePath);
        }
        catch (CmsRfsException cmsRfsException) {
        }
        catch (CmsRuntimeException cmsRuntimeException) {
            // empty catch block
        }
        clone.m_fileEncoding = this.m_fileEncoding;
        clone.m_isLogfile = this.m_isLogfile;
        clone.m_enabled = this.m_enabled;
        clone.setWindowSize(this.m_windowSize);
        clone.m_frozen = false;
        return clone;
    }

    public String getFileEncoding() {
        return this.m_fileEncoding.name();
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public boolean getIsLogfile() {
        return this.m_isLogfile;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public int getWindowPos() {
        return this.m_windowPos;
    }

    public int getWindowSize() {
        return this.m_windowSize;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String readFilePortion() throws CmsRfsException {
        if (this.m_enabled) {
            int startLine;
            int lines = -1;
            if (this.m_isLogfile) {
                lines = this.scrollToFileEnd();
                startLine = lines - this.m_windowSize;
            } else {
                this.m_windowPos = 0;
                startLine = this.m_windowPos * this.m_windowSize;
            }
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_filePath), this.m_fileEncoding)), this.m_windowSize * 200);
                for (int currentLine = 0; startLine > currentLine; ++currentLine) {
                    ((LineNumberReader)reader).readLine();
                }
                StringBuffer result = new StringBuffer();
                String read = ((LineNumberReader)reader).readLine();
                for (int i = this.m_windowSize; i > 0 && read != null; --i) {
                    result.append(read);
                    result.append('\n');
                    read = ((LineNumberReader)reader).readLine();
                }
                String string = CmsEncoder.escapeXml(result.toString());
                return string;
            }
            catch (IOException ioex) {
                CmsRfsException ex = new CmsRfsException(Messages.get().container("ERR_FILE_ARG_ACCESS_1", this.m_filePath), (Throwable)ioex);
                throw ex;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        return Messages.get().getBundle().key("GUI_FILE_VIEW_NO_PREVIEW_0");
    }

    public void setAdditionalRoots(List<String> roots) {
        ArrayList<String> additionalRoots = new ArrayList<String>();
        for (String path : roots) {
            if (path != null && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            additionalRoots.add(path);
        }
        this.m_additionalRoots = additionalRoots;
    }

    public void setEnabled(boolean preview) {
        this.m_enabled = preview;
    }

    public void setFileEncoding(String fileEncoding) {
        this.checkFrozen();
        try {
            this.m_fileEncoding = Charset.forName(fileEncoding);
        }
        catch (IllegalCharsetNameException icne) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_CHARSET_ILLEGAL_NAME_1", fileEncoding));
        }
        catch (UnsupportedCharsetException ucse) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_CHARSET_UNSUPPORTED_1", fileEncoding));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFilePath(String path) throws CmsRfsException, CmsRuntimeException {
        this.checkFrozen();
        if (path != null) {
            path = path.trim();
        }
        if (CmsStringUtil.isEmpty(path)) {
            throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_EMPTY_1", new Object[]{String.valueOf(path)}));
        }
        try {
            File file = new File(path);
            if (file.isDirectory()) {
                if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_IS_FOLDER_1", new Object[]{String.valueOf(path)}));
                this.m_filePath = null;
                this.m_isLogfile = true;
                return;
            } else if (!file.isFile()) {
                if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_NOT_FOUND_1", new Object[]{String.valueOf(path)}));
                this.m_filePath = null;
                this.m_isLogfile = true;
                return;
            } else if (!file.canRead()) {
                if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_NOT_READ_1", new Object[]{String.valueOf(path)}));
                this.m_filePath = null;
                this.m_isLogfile = true;
                return;
            } else if (this.m_rootPath != null && !this.isInRoots(file.getCanonicalPath())) {
                if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_NOT_READ_1", new Object[]{String.valueOf(path)}));
                this.m_filePath = null;
                this.m_isLogfile = true;
                return;
            } else {
                this.m_filePath = file.getCanonicalPath();
            }
            return;
        }
        catch (FileNotFoundException fnfe) {
            if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_NOT_FOUND_1", new Object[]{String.valueOf(path)}), (Throwable)fnfe);
            this.m_filePath = null;
            this.m_isLogfile = true;
            return;
        }
        catch (IOException ioex) {
            if (OpenCms.getRunLevel() != 2) throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_ACCESS_1", new Object[]{String.valueOf(path)}), (Throwable)ioex);
            this.m_filePath = null;
            this.m_isLogfile = true;
            return;
        }
    }

    public void setFrozen(boolean frozen) throws CmsRuntimeException {
        this.m_frozen = frozen;
    }

    public void setIsLogfile(boolean isLogfile) throws CmsRuntimeException {
        this.checkFrozen();
        this.m_isLogfile = isLogfile;
    }

    public void setRootPath(String path) throws CmsRfsException, CmsRuntimeException {
        block7: {
            this.checkFrozen();
            if (path != null) {
                path = path.trim();
            }
            if (CmsStringUtil.isEmpty(path)) {
                throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_EMPTY_1", new Object[]{String.valueOf(path)}));
            }
            try {
                File file = new File(path);
                if (file.exists()) {
                    this.m_rootPath = file.getCanonicalPath();
                    break block7;
                }
                if (OpenCms.getRunLevel() == 2) {
                    this.m_rootPath = new File(OpenCms.getSystemInfo().getLogFileRfsPath()).getParent();
                    break block7;
                }
                throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_NOT_FOUND_1", new Object[]{String.valueOf(path)}));
            }
            catch (IOException ioex) {
                if (OpenCms.getRunLevel() == 2) {
                    this.m_rootPath = new File(OpenCms.getSystemInfo().getLogFileRfsPath()).getParent();
                }
                throw new CmsRfsException(Messages.get().container("ERR_FILE_ARG_ACCESS_1", new Object[]{String.valueOf(path)}), (Throwable)ioex);
            }
        }
    }

    public void setWindowPos(int windowPos) throws CmsRuntimeException {
        this.checkFrozen();
        this.m_windowPos = windowPos;
    }

    public void setWindowSize(int windowSize) throws CmsRuntimeException {
        this.checkFrozen();
        this.m_windowSize = windowSize;
    }

    private void checkFrozen() throws CmsRuntimeException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_FILE_VIEW_SETTINGS_FROZEN_0"));
        }
    }

    private String getLogFolderPath() {
        String path = null;
        if (OpenCms.getRunLevel() >= 3 && (path = new File(OpenCms.getSystemInfo().getLogFileRfsPath()).getParent()) != null && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    private boolean isInRoots(String canonicalPath) {
        if (canonicalPath.startsWith(this.m_rootPath)) {
            return true;
        }
        if (this.m_additionalRoots != null) {
            for (String root : this.m_additionalRoots) {
                if (!canonicalPath.startsWith(root)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scrollToFileEnd() {
        int lines = 0;
        if (OpenCms.getRunLevel() >= 3) {
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(this.m_filePath))));
                while (((LineNumberReader)reader).readLine() != null) {
                    ++lines;
                }
                reader.close();
                int availWindows = (int)Math.ceil((double)lines / (double)this.m_windowSize);
                this.m_windowPos = availWindows - 1;
            }
            catch (IOException ioex) {
                LOG.error((Object)("Unable to scroll file " + this.m_filePath + " to end. Ensure that it exists. "));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable f) {
                        LOG.info((Object)("Unable to close reader of file " + this.m_filePath), f);
                    }
                }
            }
        }
        return lines;
    }
}

