/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public final class CmsVfsUtil {
    private static final Log LOG = CmsLog.getLog(CmsVfsUtil.class);

    private CmsVfsUtil() {
    }

    public static void createFolder(CmsObject cms, String rootPath) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        List<String> parents = new ArrayList();
        String currentPath = rootPath;
        while (currentPath != null && !rootCms.existsResource(currentPath)) {
            parents.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        parents = Lists.reverse(parents);
        for (String parent : parents) {
            try {
                rootCms.createResource(parent, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
                try {
                    rootCms.unlockResource(parent);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)e);
                }
            }
            catch (CmsVfsResourceAlreadyExistsException cmsVfsResourceAlreadyExistsException) {}
        }
    }
}

