/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.util.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CmsXmlSaxWriter
extends DefaultHandler
implements LexicalHandler {
    private static final String INDENT_STR = "\t";
    private String m_encoding;
    private boolean m_escapeUnknownChars;
    private boolean m_escapeXml;
    private int m_indentLevel;
    private boolean m_isCdata;
    private String m_lastElementName;
    private boolean m_openCdata;
    private boolean m_openElement;
    private Writer m_writer;

    public CmsXmlSaxWriter() {
        this(new StringWriter(), OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public CmsXmlSaxWriter(String encoding) {
        this(new StringWriter(), encoding);
    }

    public CmsXmlSaxWriter(Writer writer) {
        this(writer, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public CmsXmlSaxWriter(Writer writer, String encoding) {
        this.m_writer = writer;
        this.m_encoding = encoding;
        this.m_indentLevel = 0;
        this.m_escapeXml = true;
        this.m_escapeUnknownChars = false;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (len == 0) {
            return;
        }
        if (this.m_openElement) {
            this.write(">");
            this.m_openElement = false;
        }
        if (this.m_openCdata) {
            this.write("<![CDATA[");
            this.m_openCdata = false;
        }
        if (this.m_escapeXml && !this.m_isCdata) {
            String escaped = new String(buf, offset, len);
            escaped = CmsEncoder.escapeXml(escaped, true);
            if (this.m_escapeUnknownChars) {
                escaped = CmsEncoder.adjustHtmlEncoding(escaped, this.getEncoding());
            }
            this.write(escaped);
        } else {
            this.write(new String(buf, offset, len));
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.m_openCdata) {
            this.write("]]>");
        }
        this.m_openCdata = false;
        this.m_isCdata = false;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.m_openElement) {
                this.write("/>");
                this.m_openElement = false;
            }
            this.writeNewLine();
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(Messages.get().getBundle().key("ERR_IOERROR_0"), e);
        }
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        String elementName = this.resolveName(localName, qualifiedName);
        if (this.m_openElement) {
            this.write("/>");
        } else {
            if (!elementName.equals(this.m_lastElementName)) {
                this.writeNewLine();
            }
            this.write("</");
            this.write(elementName);
            this.write(">");
        }
        this.m_openElement = false;
        --this.m_indentLevel;
    }

    @Override
    public void endEntity(String name) {
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public boolean isEscapeUnknownChars() {
        return this.m_escapeUnknownChars;
    }

    public boolean isEscapeXml() {
        return this.m_escapeXml;
    }

    public void setEncoding(String value) {
        this.m_encoding = value;
    }

    public void setEscapeUnknownChars(boolean value) {
        this.m_escapeUnknownChars = value;
    }

    public void setEscapeXml(boolean value) {
        this.m_escapeXml = value;
    }

    @Override
    public void startCDATA() {
        this.m_openCdata = true;
        this.m_isCdata = true;
    }

    @Override
    public void startDocument() throws SAXException {
        this.write("<?xml version=\"1.0\" encoding=\"");
        this.write(this.m_encoding);
        this.write("\"?>");
        this.writeNewLine();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.write("<!DOCTYPE ");
        this.write(name);
        if (publicId != null) {
            this.write(" PUBLIC \"");
            this.write(publicId);
            this.write("\"");
        }
        if (systemId != null) {
            this.write(" SYSTEM \"");
            this.write(systemId);
            this.write("\"");
        }
        this.write(">");
        this.writeNewLine();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.m_openElement) {
            this.write(">");
            this.m_openElement = false;
        }
        ++this.m_indentLevel;
        this.writeNewLine();
        this.m_lastElementName = this.resolveName(localName, qualifiedName);
        this.write("<");
        this.write(this.m_lastElementName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.write(" ");
                this.write(this.resolveName(attributes.getLocalName(i), attributes.getQName(i)));
                this.write("=\"");
                String value = attributes.getValue(i);
                if (this.m_escapeXml) {
                    value = CmsEncoder.escapeXml(value, true);
                    if (this.m_escapeUnknownChars) {
                        value = CmsEncoder.adjustHtmlEncoding(value, this.getEncoding());
                    }
                }
                this.write(value);
                this.write("\"");
            }
        }
        this.m_openElement = true;
    }

    @Override
    public void startEntity(String name) {
    }

    private String resolveName(String localName, String qualifiedName) {
        if (localName == null || localName.length() == 0) {
            return qualifiedName;
        }
        return localName;
    }

    private void write(String s) throws SAXException {
        try {
            this.m_writer.write(s);
        }
        catch (IOException e) {
            throw new SAXException(Messages.get().getBundle().key("ERR_IOERROR_0"), e);
        }
    }

    private void writeNewLine() throws SAXException {
        try {
            this.m_writer.write("\r\n");
            for (int i = 1; i < this.m_indentLevel; ++i) {
                this.m_writer.write(INDENT_STR);
            }
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(Messages.get().getBundle().key("ERR_IOERROR_0"), e);
        }
    }
}

