/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsLocalizationWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String OPTION_KEY = "key=";
    public static final String OPTION_LOCALE = "locale=";
    private static Pattern PATTERN_MACRO = Pattern.compile(".*(%\\()(\\d*)(\\)).*");
    private static Pattern PATTERN_MESSAGEARGUMENT = Pattern.compile(".*(\\{)(\\d*)(\\}).*");
    private String m_bundleKey;
    private Locale m_locale;
    private CmsMessages m_messages;

    public CmsLocalizationWidget() {
        this("");
    }

    public CmsLocalizationWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        this.initConfiguration(cms, schemaType);
        return this.m_messages.key(this.m_bundleKey);
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        this.initConfiguration(cms, param);
        StringBuffer result = new StringBuffer(256);
        result.append("<td class=\"xmlTd\">");
        result.append("<input class=\"xmlInput textInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\"");
        result.append(" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" value=\"");
        String value = this.getValue(cms, param);
        result.append(CmsEncoder.escapeXml(value));
        result.append("\">");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsLocalizationWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsLocalizationWidget(this.getConfiguration());
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            this.initConfiguration(cms, param);
            String value = this.m_messages.key(this.m_bundleKey);
            if (value.equals(values[0].trim())) {
                value = "";
            } else {
                value = values[0];
                Matcher matcher = PATTERN_MESSAGEARGUMENT.matcher(value);
                while (matcher.matches()) {
                    int startIndex = matcher.start(1);
                    int endIndex = matcher.end(3);
                    String number = CmsMacroResolver.formatMacro(matcher.group(2));
                    value = value.substring(0, startIndex) + number + value.substring(endIndex);
                    matcher = PATTERN_MESSAGEARGUMENT.matcher(value);
                }
            }
            param.setStringValue(cms, value);
        }
    }

    protected void initConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType) {
        this.m_bundleKey = schemaType.getName();
        this.m_locale = cms.getRequestContext().getLocale();
        try {
            A_CmsXmlContentValue value = schemaType;
            this.m_locale = value.getLocale();
        }
        catch (Exception value) {
            // empty catch block
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getConfiguration())) {
            String bundleName = "";
            List<String> configs = CmsStringUtil.splitAsList(this.getConfiguration(), '|');
            for (String config : configs) {
                if (config.startsWith(OPTION_KEY)) {
                    this.m_bundleKey = config.substring(OPTION_KEY.length());
                    continue;
                }
                if (config.startsWith(OPTION_LOCALE)) {
                    this.m_locale = CmsLocaleManager.getLocale(config.substring(OPTION_LOCALE.length()));
                    continue;
                }
                bundleName = config;
            }
            this.m_messages = new CmsMessages(bundleName, this.m_locale);
        } else {
            this.m_messages = new CmsMessages("", this.m_locale);
        }
    }

    protected void initConfiguration(CmsObject cms, I_CmsWidgetParameter param) {
        this.m_bundleKey = param.getName();
        this.m_locale = cms.getRequestContext().getLocale();
        try {
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)((Object)param);
            this.m_locale = value.getLocale();
        }
        catch (Exception value) {
            // empty catch block
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getConfiguration())) {
            String bundleName = "";
            List<String> configs = CmsStringUtil.splitAsList(this.getConfiguration(), '|');
            for (String config : configs) {
                if (config.startsWith(OPTION_KEY)) {
                    this.m_bundleKey = config.substring(OPTION_KEY.length());
                    continue;
                }
                if (config.startsWith(OPTION_LOCALE)) {
                    this.m_locale = CmsLocaleManager.getLocale(config.substring(OPTION_LOCALE.length()));
                    continue;
                }
                bundleName = config;
            }
            this.m_messages = new CmsMessages(bundleName, this.m_locale);
        } else {
            this.m_messages = new CmsMessages("", this.m_locale);
        }
    }

    private String getValue(CmsObject cms, I_CmsWidgetParameter param) {
        String value = this.m_messages.key(this.m_bundleKey);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(param.getStringValue(cms)) && !value.equals(param.getStringValue(cms)) || value.startsWith("???")) {
            value = param.getStringValue(cms);
            Matcher matcher = PATTERN_MACRO.matcher(value);
            while (matcher.matches()) {
                int startIndex = matcher.start(1);
                int endIndex = matcher.end(3);
                String number = matcher.group(2);
                value = value.substring(0, startIndex) + "{" + number + "}" + value.substring(endIndex);
                matcher = PATTERN_MACRO.matcher(value);
            }
        }
        return value;
    }
}

