/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.OpenCms;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsPrincipalWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String CONFIGURATION_FLAGS = "flags";
    private Integer m_flags;

    public CmsPrincipalWidget() {
        this("");
    }

    public CmsPrincipalWidget(Integer flags) {
        this.m_flags = flags;
    }

    public CmsPrincipalWidget(String configuration) {
        super(configuration);
    }

    public String getButtonJs(String id, String form) {
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openPrincipalWin('");
        buttonJs.append(OpenCms.getSystemInfo().getOpenCmsContext());
        buttonJs.append("/system/workplace/commons/principal_selection.jsp");
        buttonJs.append("','" + form + "',  '");
        buttonJs.append(id);
        buttonJs.append("', document, '");
        if (this.m_flags != null) {
            buttonJs.append(this.m_flags);
        } else {
            buttonJs.append("null");
        }
        buttonJs.append("'");
        buttonJs.append(");");
        return buttonJs.toString();
    }

    @Override
    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_flags != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_FLAGS);
            result.append("=");
            result.append(this.m_flags);
        }
        return result.toString();
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        return CmsPrincipalSelectDialog.PARAM_TYPE + "=" + CmsPrincipalSelect.WidgetType.principalwidget.name();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.singleline;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/principalselector.js"));
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getButtonJs(id, "EDITOR"), null, "principal", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public Integer getFlags() {
        return this.m_flags;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsPrincipalWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsPrincipalWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        int flagsIndex;
        this.m_flags = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration) && (flagsIndex = configuration.indexOf(CONFIGURATION_FLAGS)) != -1) {
            String flags = configuration.substring(CONFIGURATION_FLAGS.length() + 1);
            if (flags.indexOf(124) != -1) {
                flags = flags.substring(0, flags.indexOf(124));
            }
            try {
                this.m_flags = Integer.valueOf(flags);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.setConfiguration(configuration);
    }
}

