/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.main.CmsLog;
import org.opencms.widgets.serialdate.CmsSerialDateBeanDaily;
import org.opencms.widgets.serialdate.CmsSerialDateBeanIndividual;
import org.opencms.widgets.serialdate.CmsSerialDateBeanMonthly;
import org.opencms.widgets.serialdate.CmsSerialDateBeanMonthlyWeeks;
import org.opencms.widgets.serialdate.CmsSerialDateBeanSingle;
import org.opencms.widgets.serialdate.CmsSerialDateBeanWeekly;
import org.opencms.widgets.serialdate.CmsSerialDateBeanWorkingDays;
import org.opencms.widgets.serialdate.CmsSerialDateBeanYearly;
import org.opencms.widgets.serialdate.CmsSerialDateBeanYearlyWeekday;
import org.opencms.widgets.serialdate.CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;

public class CmsSerialDateBeanFactory {
    public static final Log LOG = CmsLog.getLog(CmsSerialDateBeanFactory.class);

    public static I_CmsSerialDateBean createSerialDateBean(I_CmsSerialDateValue value) {
        if (null == value || !value.isValid()) {
            return null;
        }
        switch (value.getPatternType()) {
            case DAILY: {
                if (value.isEveryWorkingDay()) {
                    return new CmsSerialDateBeanWorkingDays(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions());
                }
                return new CmsSerialDateBeanDaily(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getInterval());
            }
            case WEEKLY: {
                return new CmsSerialDateBeanWeekly(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getInterval(), value.getWeekDays());
            }
            case MONTHLY: {
                if (null == value.getWeekDay()) {
                    return new CmsSerialDateBeanMonthly(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getInterval(), value.getDayOfMonth());
                }
                return new CmsSerialDateBeanMonthlyWeeks(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getInterval(), value.getWeeksOfMonth(), value.getWeekDay());
            }
            case YEARLY: {
                if (null == value.getWeekDay()) {
                    return new CmsSerialDateBeanYearly(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getDayOfMonth(), value.getMonth());
                }
                return new CmsSerialDateBeanYearlyWeekday(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getWeekOfMonth(), value.getMonth(), value.getWeekDay());
            }
            case INDIVIDUAL: {
                return new CmsSerialDateBeanIndividual(value.getStart(), value.getEnd(), value.isWholeDay(), value.getEndType(), value.getSeriesEndDate(), value.getOccurrences(), value.getExceptions(), value.getIndividualDates());
            }
            case NONE: {
                return new CmsSerialDateBeanSingle(value.getStart(), value.getEnd(), value.isWholeDay());
            }
        }
        throw new IllegalArgumentException();
    }

    public static I_CmsSerialDateBean createSerialDateBean(String widgetValue) {
        CmsSerialDateValue value = new CmsSerialDateValue(widgetValue);
        return CmsSerialDateBeanFactory.createSerialDateBean(value);
    }
}

