/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanIndividual
extends A_CmsSerialDateBean {
    private TreeSet<Date> m_individualDates;

    public CmsSerialDateBeanIndividual(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, SortedSet<Date> individualDates) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_individualDates = null == individualDates ? new TreeSet() : new TreeSet<Date>(individualDates);
    }

    @Override
    protected Calendar getFirstDate() {
        if (this.m_individualDates.isEmpty()) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(this.m_individualDates.iterator().next());
        return result;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return !this.m_individualDates.isEmpty();
    }

    @Override
    protected boolean showMoreEntries(Calendar nextDate, int previousOccurrences) {
        return previousOccurrences < this.m_individualDates.size();
    }

    @Override
    protected void toNextDate(Calendar date) {
        Date d = date.getTime();
        boolean found = false;
        Iterator<Date> it = this.m_individualDates.iterator();
        while (it.hasNext()) {
            if (found) {
                date.setTime(it.next());
                return;
            }
            if (!d.equals(it.next())) continue;
            found = true;
        }
    }
}

