/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanWeekly
extends A_CmsSerialDateBean {
    private int m_interval;
    private SortedSet<I_CmsSerialDateValue.WeekDay> m_weekDays;

    public CmsSerialDateBeanWeekly(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, int interval, SortedSet<I_CmsSerialDateValue.WeekDay> weekDays) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_interval = interval;
        this.m_weekDays = weekDays;
    }

    @Override
    protected Calendar getFirstDate() {
        Calendar date = (Calendar)this.getStartDate().clone();
        I_CmsSerialDateValue.WeekDay currentWeekDay = I_CmsSerialDateValue.WeekDay.fromInt(date.get(7));
        if (!this.m_weekDays.contains((Object)currentWeekDay)) {
            this.toNextDate(date);
        }
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return !this.m_weekDays.isEmpty();
    }

    @Override
    protected void toNextDate(Calendar date) {
        I_CmsSerialDateValue.WeekDay currentWeekDay = I_CmsSerialDateValue.WeekDay.fromInt(date.get(7));
        int daysToNextMatch = this.getDaysToNextMatch(currentWeekDay);
        date.add(5, daysToNextMatch);
    }

    private int getDaysToNextMatch(I_CmsSerialDateValue.WeekDay weekDay) {
        for (I_CmsSerialDateValue.WeekDay wd : this.m_weekDays) {
            if (wd.compareTo(weekDay) <= 0) continue;
            return wd.toInt() - weekDay.toInt();
        }
        return ((I_CmsSerialDateValue.WeekDay)((Object)this.m_weekDays.iterator().next())).toInt() + this.m_interval * 7 - weekDay.toInt();
    }
}

