/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublishRelationFinder;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.I_CmsPublishResourceFormatter;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsDefaultPublishResourceFormatter
implements I_CmsPublishResourceFormatter {
    private static final Log LOG = CmsLog.getLog(CmsDefaultPublishResourceFormatter.class);
    protected CmsPublishOptions m_options;
    CmsObject m_cms;
    private Map<String, CmsResource> m_lockedResourceCache = new HashMap<String, CmsResource>();
    private List<CmsPublishResource> m_publishResources;
    private Map<CmsUUID, CmsResource> m_resources = new HashMap<CmsUUID, CmsResource>();

    public CmsDefaultPublishResourceFormatter(CmsObject cms) {
        this.m_cms = cms;
    }

    public static String getOuAwareName(CmsObject cms, String name) {
        String ou = CmsOrganizationalUnit.getParentFqn(name);
        if (ou.equals(cms.getRequestContext().getCurrentUser().getOuFqn())) {
            return CmsOrganizationalUnit.getSimpleName(name);
        }
        return "/" + name;
    }

    @Override
    public List<CmsPublishResource> getPublishResources() {
        this.sortResult(this.m_publishResources);
        return this.m_publishResources;
    }

    @Override
    public void initialize(CmsPublishOptions options, CmsPublishRelationFinder.ResourceMap resources) throws CmsException {
        this.m_options = options;
        Predicate<CmsResource> resourceMapFilter = this.getResourceMapFilter();
        if (resourceMapFilter != null) {
            resources = resources.filter(resourceMapFilter);
        }
        for (CmsResource parentRes : resources.keySet()) {
            this.m_resources.put(parentRes.getStructureId(), parentRes);
            Iterator iterator = resources.get(parentRes).iterator();
            while (iterator.hasNext()) {
                CmsResource childRes = (CmsResource)iterator.next();
                this.m_resources.put(childRes.getStructureId(), childRes);
            }
        }
        Map<CmsUUID, CmsPublishResourceInfo> warnings = this.computeWarnings();
        this.m_publishResources = Lists.newArrayList();
        for (CmsResource parentRes : resources.keySet()) {
            CmsPublishResource parentPubRes = this.createPublishResource(parentRes);
            parentPubRes.setInfo(warnings.get(parentRes.getStructureId()));
            Iterator iterator = resources.get(parentRes).iterator();
            while (iterator.hasNext()) {
                CmsResource childRes = (CmsResource)iterator.next();
                CmsPublishResource childPubRes = this.createPublishResource(childRes);
                childPubRes.setInfo(warnings.get(childRes.getStructureId()));
                parentPubRes.getRelated().add(childPubRes);
            }
            if (this.m_options.getProjectId() == null || this.m_options.getProjectId().isNullUUID()) {
                parentPubRes.setRemovable(true);
            }
            this.m_publishResources.add(parentPubRes);
        }
    }

    protected Map<CmsUUID, CmsPublishResourceInfo> computeWarnings() {
        HashMap warnings = Maps.newHashMap();
        HashSet<CmsResource> resourcesWithoutErrors = new HashSet<CmsResource>(this.m_resources.values());
        List<I_PublishResourceValidator> validators = this.getValidators();
        ArrayList excludedSetsForValidators = Lists.newArrayList();
        for (int i = 0; i < validators.size(); ++i) {
            I_PublishResourceValidator validator = validators.get(i);
            Set<CmsResource> excluded = validator.findInvalidResources(resourcesWithoutErrors);
            resourcesWithoutErrors.removeAll(excluded);
            excludedSetsForValidators.add(excluded);
        }
        for (CmsResource resource : this.m_resources.values()) {
            CmsPublishResourceInfo info = null;
            try {
                for (int i = 0; i < validators.size(); ++i) {
                    if (!((Set)excludedSetsForValidators.get(i)).contains(resource)) continue;
                    info = validators.get(i).getInfoForResource(resource);
                    break;
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            warnings.put(resource.getStructureId(), info);
        }
        return warnings;
    }

    protected CmsPublishResource createPublishResource(CmsResource resource) throws CmsException {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, resource);
        CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(this.m_cms, resource, null);
        String typeName = CmsIconUtil.getDisplayType(this.m_cms, resource);
        String detailTypeName = CmsResourceIcon.getDefaultFileOrDetailType(this.m_cms, resource);
        CmsPublishResource pubResource = new CmsPublishResource(resource.getStructureId(), resUtil.getFullPath(), resUtil.getTitle(), typeName, resource.getState(), permissionInfo, resource.getDateLastModified(), resUtil.getUserLastModified(), CmsVfsService.formatDateTime(this.m_cms, resource.getDateLastModified()), false, null, new ArrayList<CmsPublishResource>());
        pubResource.setBigIconClasses(CmsIconUtil.getIconClasses(typeName, resource.getName(), false));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(detailTypeName)) {
            pubResource.setSmallIconClasses(CmsIconUtil.getIconClasses(detailTypeName, null, true));
        }
        return pubResource;
    }

    protected Locale getLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
    }

    protected Predicate<CmsResource> getResourceMapFilter() {
        return new PublishPermissionFilter();
    }

    protected List<I_PublishResourceValidator> getValidators() {
        return Arrays.asList(new AlreadyPublishedValidator(), new NoPermissionsValidator(), new BlockingLockedValidator());
    }

    protected void sortResult(List<CmsPublishResource> publishResources) {
        Collections.sort(publishResources, new DefaultComparator());
        for (CmsPublishResource resource : publishResources) {
            Collections.sort(resource.getRelated(), new DefaultComparator());
        }
    }

    public class PublishPermissionFilter
    implements Predicate<CmsResource> {
        public boolean apply(CmsResource input) {
            try {
                return CmsDefaultPublishResourceFormatter.this.m_cms.hasPermissions(input, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return true;
            }
        }
    }

    public class NoPermissionsValidator
    implements I_PublishResourceValidator {
        @Override
        public Set<CmsResource> findInvalidResources(Set<CmsResource> resources) {
            HashSet<CmsResource> result = new HashSet<CmsResource>();
            HashSet<CmsUUID> projectIds = new HashSet<CmsUUID>();
            try {
                for (CmsProject project : OpenCms.getOrgUnitManager().getAllManageableProjects(CmsDefaultPublishResourceFormatter.this.m_cms, "", true)) {
                    projectIds.add(project.getUuid());
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            for (CmsResource resource : resources) {
                try {
                    if (projectIds.contains(resource.getProjectLastModified()) || CmsDefaultPublishResourceFormatter.this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH)) continue;
                    result.add(resource);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }

        @Override
        public CmsPublishResourceInfo getInfoForResource(CmsResource resource) {
            String info = Messages.get().getBundle(CmsDefaultPublishResourceFormatter.this.getLocale()).key("GUI_RESOURCE_NOT_ENOUGH_PERMISSIONS_0");
            CmsPublishResourceInfo.Type infoType = CmsPublishResourceInfo.Type.PERMISSIONS;
            CmsPublishResourceInfo infoObj = new CmsPublishResourceInfo(info, infoType);
            return infoObj;
        }
    }

    public static interface I_PublishResourceValidator {
        public Set<CmsResource> findInvalidResources(Set<CmsResource> var1);

        public CmsPublishResourceInfo getInfoForResource(CmsResource var1) throws CmsException;
    }

    public static class DefaultComparator
    implements Comparator<CmsPublishResource> {
        @Override
        public int compare(CmsPublishResource first, CmsPublishResource second) {
            return ComparisonChain.start().compare(-first.getSortDate(), -second.getSortDate()).result();
        }
    }

    public class BlockingLockedValidator
    implements I_PublishResourceValidator {
        @Override
        public Set<CmsResource> findInvalidResources(Set<CmsResource> resources) {
            CmsUser user = CmsDefaultPublishResourceFormatter.this.m_cms.getRequestContext().getCurrentUser();
            CmsLockFilter blockingFilter = CmsLockFilter.FILTER_ALL;
            blockingFilter = blockingFilter.filterNotLockableByUser(user);
            HashSet<CmsResource> result = new HashSet<CmsResource>();
            for (CmsResource resource : resources) {
                try {
                    List<CmsResource> blockingLocked = CmsDefaultPublishResourceFormatter.this.m_cms.getLockedResourcesWithCache(resource, blockingFilter, CmsDefaultPublishResourceFormatter.this.m_lockedResourceCache);
                    for (CmsResource res : blockingLocked) {
                        result.add(res);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }

        @Override
        public CmsPublishResourceInfo getInfoForResource(CmsResource resource) throws CmsException {
            CmsLock lock = CmsDefaultPublishResourceFormatter.this.m_cms.getLock(resource);
            String info = Messages.get().getBundle(CmsDefaultPublishResourceFormatter.this.getLocale()).key("GUI_RESOURCE_LOCKED_BY_2", CmsDefaultPublishResourceFormatter.getOuAwareName(CmsDefaultPublishResourceFormatter.this.m_cms, CmsDefaultPublishResourceFormatter.this.m_cms.readUser(lock.getUserId()).getName()), CmsDefaultPublishResourceFormatter.getOuAwareName(CmsDefaultPublishResourceFormatter.this.m_cms, lock.getProject().getName()));
            CmsPublishResourceInfo.Type infoType = CmsPublishResourceInfo.Type.LOCKED;
            CmsPublishResourceInfo infoObj = new CmsPublishResourceInfo(info, infoType);
            return infoObj;
        }
    }

    public class AlreadyPublishedValidator
    implements I_PublishResourceValidator {
        @Override
        public Set<CmsResource> findInvalidResources(Set<CmsResource> resources) {
            HashSet<CmsResource> result = new HashSet<CmsResource>();
            for (CmsResource resource : resources) {
                if (!resource.getState().isUnchanged()) continue;
                result.add(resource);
            }
            return result;
        }

        @Override
        public CmsPublishResourceInfo getInfoForResource(CmsResource resource) throws CmsException {
            String publishUser = CmsDefaultPublishResourceFormatter.getOuAwareName(CmsDefaultPublishResourceFormatter.this.m_cms, CmsDefaultPublishResourceFormatter.this.m_cms.readUser(resource.getUserLastModified()).getName());
            Date publishDate = new Date(resource.getDateLastModified());
            String info = Messages.get().getBundle(CmsDefaultPublishResourceFormatter.this.getLocale()).key("GUI_RESOURCE_PUBLISHED_BY_2", publishUser, publishDate);
            CmsPublishResourceInfo.Type infoType = CmsPublishResourceInfo.Type.PUBLISHED;
            CmsPublishResourceInfo infoObj = new CmsPublishResourceInfo(info, infoType);
            return infoObj;
        }
    }
}

