/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsCurrentPageProject;
import org.opencms.ade.publish.CmsDirectPublishProject;
import org.opencms.ade.publish.CmsMyChangesProject;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.CmsRealProjectVirtualWrapper;
import org.opencms.ade.publish.CmsTooManyPublishResourcesException;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishListToken;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.ade.publish.shared.CmsWorkflowAction;
import org.opencms.ade.publish.shared.CmsWorkflowResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.A_CmsWorkflowManager;
import org.opencms.workflow.CmsDefaultPublishResourceFormatter;
import org.opencms.workflow.CmsInvalidActionException;
import org.opencms.workflow.CmsWorkflowResources;
import org.opencms.workflow.I_CmsPublishResourceFormatter;
import org.opencms.workflow.Messages;

public class CmsDefaultWorkflowManager
extends A_CmsWorkflowManager {
    public static final String ACTION_FORCE_PUBLISH = "forcepublish";
    public static final String ACTION_PUBLISH = "publish";
    public static int DEFAULT_RESOURCE_LIMIT = 1000;
    public static final String PARAM_RESOURCE_LIMIT = "resourceLimit";
    public static final String WORKFLOW_PUBLISH = "WORKFLOW_PUBLISH";
    private static final Log LOG = CmsLog.getLog(CmsDefaultWorkflowManager.class);
    public static final String ATTR_CHECK_PUBLISH_RESOURCE_LIMIT = "CHECK_PUBLISH_RESOURCE_LIMIT";
    protected Map<CmsUUID, I_CmsVirtualProject> m_virtualProjects = Maps.newHashMap();
    private int m_resourceLimit = DEFAULT_RESOURCE_LIMIT;

    public CmsDefaultWorkflowManager() {
        this.m_virtualProjects.put(CmsCurrentPageProject.ID, new CmsCurrentPageProject());
        this.m_virtualProjects.put(CmsMyChangesProject.ID, new CmsMyChangesProject());
        this.m_virtualProjects.put(CmsDirectPublishProject.ID, new CmsDirectPublishProject());
    }

    public static CmsProjectBean createProjectBeanFromProject(CmsObject cms, CmsProject project) {
        CmsProjectBean manProj = new CmsProjectBean(project.getUuid(), project.getType().getMode(), org.opencms.ade.publish.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_NORMAL_PROJECT_1", CmsDefaultWorkflowManager.getOuAwareName(cms, project.getName())), project.getDescription());
        return manProj;
    }

    protected static String getOuAwareName(CmsObject cms, String name) {
        String ou = CmsOrganizationalUnit.getParentFqn(name);
        if (ou.equals(cms.getRequestContext().getCurrentUser().getOuFqn())) {
            return CmsOrganizationalUnit.getSimpleName(name);
        }
        return "/" + name;
    }

    @Override
    public I_CmsPublishResourceFormatter createFormatter(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options) {
        CmsDefaultPublishResourceFormatter formatter = new CmsDefaultPublishResourceFormatter(cms);
        return formatter;
    }

    @Override
    public CmsWorkflowResponse executeAction(CmsObject cms, CmsWorkflowAction action, CmsPublishListToken token) throws CmsException {
        if (action.getAction().equals("cancel")) {
            return new CmsWorkflowResponse(true, action.getAction(), null, null, null);
        }
        List<CmsResource> resources = this.getWorkflowResources(cms, token.getWorkflow(), token.getOptions(), false, true).getWorkflowResources();
        return this.executeAction(cms, action, token.getOptions(), resources);
    }

    @Override
    public CmsWorkflowResponse executeAction(CmsObject userCms, CmsWorkflowAction action, CmsPublishOptions options, List<CmsResource> resources) throws CmsException {
        String actionKey = action.getAction();
        if ("cancel".equals(actionKey)) {
            return new CmsWorkflowResponse(true, actionKey, null, null, null);
        }
        if (ACTION_PUBLISH.equals(actionKey)) {
            return this.actionPublish(userCms, options, resources);
        }
        if (ACTION_FORCE_PUBLISH.equals(actionKey)) {
            return this.actionForcePublish(userCms, options, resources);
        }
        throw new CmsInvalidActionException(actionKey);
    }

    public String getLabel(CmsObject cms, String key) {
        CmsMessages messages = Messages.get().getBundle(this.getLocale(cms));
        return messages.key(key);
    }

    @Override
    public List<CmsProjectBean> getManageableProjects(CmsObject cms, Map<String, String> params) {
        List<CmsProject> projects;
        ArrayList<CmsProjectBean> manProjs = new ArrayList<CmsProjectBean>();
        try {
            projects = OpenCms.getOrgUnitManager().getAllManageableProjects(cms, "", true);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return manProjs;
        }
        for (CmsProject project : projects) {
            CmsProjectBean manProj = CmsDefaultWorkflowManager.createProjectBeanFromProject(cms, project);
            manProjs.add(manProj);
        }
        for (I_CmsVirtualProject handler : this.m_virtualProjects.values()) {
            CmsProjectBean projectBean = handler.getProjectBean(cms, params);
            if (projectBean == null) continue;
            manProjs.add(projectBean);
        }
        return manProjs;
    }

    @Override
    public CmsPublishListToken getPublishListToken(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options) {
        return new CmsPublishListToken(workflow, options);
    }

    @Override
    public I_CmsVirtualProject getRealOrVirtualProject(CmsUUID projectId) {
        I_CmsVirtualProject project = this.m_virtualProjects.get(projectId);
        if (project == null) {
            project = new CmsRealProjectVirtualWrapper(projectId);
        }
        return project;
    }

    @Override
    public int getResourceLimit() {
        return this.m_resourceLimit;
    }

    @Override
    public String getWorkflowForWorkflowProject(CmsUUID projectId) {
        return WORKFLOW_PUBLISH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsWorkflowResources getWorkflowResources(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options, boolean canOverride, boolean ignoreLimit) {
        CmsWorkflowResources cmsWorkflowResources;
        try {
            if (!ignoreLimit) {
                cms.getRequestContext().setAttribute(ATTR_CHECK_PUBLISH_RESOURCE_LIMIT, Boolean.TRUE);
            }
            List<CmsResource> rawResourceList = new ArrayList<CmsResource>();
            I_CmsVirtualProject projectHandler = null;
            projectHandler = this.getRealOrVirtualProject(options.getProjectId());
            if (projectHandler != null) {
                rawResourceList = projectHandler.getResources(cms, options.getParameters(), workflow.getId());
                CmsWorkflowResources cmsWorkflowResources2 = new CmsWorkflowResources(rawResourceList, null, null);
                return cmsWorkflowResources2;
            }
            CmsWorkflowResources cmsWorkflowResources3 = new CmsWorkflowResources(rawResourceList, null, null);
            return cmsWorkflowResources3;
        }
        catch (CmsTooManyPublishResourcesException e) {
            cmsWorkflowResources = new CmsWorkflowResources(Collections.emptyList(), null, e.getCount());
            return cmsWorkflowResources;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            cmsWorkflowResources = new CmsWorkflowResources(Collections.emptyList(), null, null);
            return cmsWorkflowResources;
        }
        finally {
            cms.getRequestContext().removeAttribute(ATTR_CHECK_PUBLISH_RESOURCE_LIMIT);
        }
    }

    @Override
    public Map<String, CmsWorkflow> getWorkflows(CmsObject cms) {
        LinkedHashMap<String, CmsWorkflow> result = new LinkedHashMap<String, CmsWorkflow>();
        ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
        String publishLabel = this.getLabel(cms, "GUI_WORKFLOW_ACTION_PUBLISH_0");
        CmsWorkflowAction publishAction = new CmsWorkflowAction(ACTION_PUBLISH, publishLabel, true, true);
        actions.add(publishAction);
        String workflowLabel = this.getLabel(cms, "GUI_WORKFLOW_PUBLISH_0");
        CmsWorkflow publishWorkflow = new CmsWorkflow(WORKFLOW_PUBLISH, workflowLabel, actions);
        result.put(WORKFLOW_PUBLISH, publishWorkflow);
        return result;
    }

    @Override
    public void initialize(CmsObject adminCms) {
        super.initialize(adminCms);
        String resourceLimitStr = this.getParameter(PARAM_RESOURCE_LIMIT, "invalid").trim();
        try {
            this.m_resourceLimit = Integer.parseInt(resourceLimitStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected CmsWorkflowResponse actionForcePublish(CmsObject userCms, CmsPublishOptions options, List<CmsResource> resources) throws CmsException {
        CmsPublish publish = new CmsPublish(userCms, options.getParameters());
        publish.publishResources(resources);
        CmsWorkflowResponse response = new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
        return response;
    }

    protected CmsWorkflowResponse actionPublish(CmsObject userCms, CmsPublishOptions options, final List<CmsResource> resources) throws CmsException {
        final CmsPublish publish = new CmsPublish(userCms, options);
        final FutureTask<List<CmsPublishResource>> brokenResourcesGetter = new FutureTask<List<CmsPublishResource>>(new Callable<List<CmsPublishResource>>(){

            @Override
            public List<CmsPublishResource> call() throws Exception {
                return publish.getBrokenResources(resources);
            }
        });
        Thread brokenResourcesThread = new Thread(brokenResourcesGetter);
        brokenResourcesThread.start();
        try {
            List<CmsPublishResource> brokenResources = brokenResourcesGetter.get(10L, TimeUnit.SECONDS);
            if (brokenResources.size() == 0) {
                publish.publishResources(resources);
                CmsWorkflowResponse response = new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
                return response;
            }
            String brokenResourcesLabel = this.getLabel(userCms, "GUI_BROKEN_LINKS_0");
            boolean canForcePublish = OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(userCms, CmsRole.VFS_MANAGER);
            ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
            if (canForcePublish) {
                String forceLabel = this.getLabel(userCms, "GUI_WORKFLOW_ACTION_FORCE_PUBLISH_0");
                actions.add(new CmsWorkflowAction(ACTION_FORCE_PUBLISH, forceLabel, true, true));
            }
            CmsWorkflowResponse response = new CmsWorkflowResponse(false, brokenResourcesLabel, brokenResources, actions, null);
            return response;
        }
        catch (TimeoutException e) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    LOG.info((Object)"Checking broken relations is taking too long, using a different thread for checking and publishing now.");
                    try {
                        brokenResourcesGetter.get();
                        ArrayList<CmsResource> resourcesToPublish = new ArrayList<CmsResource>(resources);
                        Iterator resIter = resourcesToPublish.iterator();
                        while (resIter.hasNext()) {
                            CmsResource currentRes = (CmsResource)resIter.next();
                            if (!publish.getRelationValidator().keySet().contains(currentRes.getRootPath())) continue;
                            resIter.remove();
                            LOG.info((Object)("Excluding resource from publish list because relations would be broken: " + currentRes.getRootPath()));
                        }
                        publish.publishResources(resourcesToPublish);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            };
            thread.start();
            CmsWorkflowResponse response = new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
            return response;
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
    }
}

