/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.ade.publish.shared.CmsWorkflowAction;
import org.opencms.ade.publish.shared.CmsWorkflowResponse;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEventAdapter;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.CmsDefaultWorkflowManager;
import org.opencms.workflow.CmsExtendedPublishResourceFormatter;
import org.opencms.workflow.CmsExtendedRealProjectWrapper;
import org.opencms.workflow.CmsNewParentNotInWorkflowException;
import org.opencms.workflow.CmsWorkflowNotification;
import org.opencms.workflow.CmsWorkflowResources;
import org.opencms.workflow.I_CmsPublishResourceFormatter;
import org.opencms.workflow.Messages;

public class CmsExtendedWorkflowManager
extends CmsDefaultWorkflowManager {
    public static final String ACTION_RELEASE = "release";
    public static final String PARAM_NOTIFICATION_CONTENT = "notificationContent";
    public static final String PARAM_WORKFLOW_PROJECT_MANAGER_GROUP = "workflowProjectManagerGroup";
    public static final String PARAM_WORKFLOW_PROJECT_USER_GROUP = "workflowProjectUserGroup";
    public static final String WORKFLOW_RELEASE = "WORKFLOW_RELEASE";
    private static final Log LOG = CmsLog.getLog(CmsExtendedWorkflowManager.class);

    @Override
    public I_CmsPublishResourceFormatter createFormatter(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options) {
        String workflowKey = workflow.getId();
        boolean release = WORKFLOW_RELEASE.equals(workflowKey);
        CmsExtendedPublishResourceFormatter formatter = new CmsExtendedPublishResourceFormatter(cms);
        formatter.setRelease(release);
        return formatter;
    }

    @Override
    public CmsWorkflowResponse executeAction(CmsObject userCms, CmsWorkflowAction action, CmsPublishOptions options, List<CmsResource> resources) throws CmsException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("workflow action: " + userCms.getRequestContext().getCurrentUser().getName() + " " + action.getAction()));
            ArrayList<String> resourceNames = new ArrayList<String>();
            for (CmsResource resource : resources) {
                resourceNames.add(resource.getRootPath());
            }
            LOG.info((Object)("Resources: " + CmsStringUtil.listAsString(resourceNames, ",")));
        }
        try {
            String actionKey = action.getAction();
            if (ACTION_RELEASE.equals(actionKey)) {
                return this.actionRelease(userCms, resources);
            }
            return super.executeAction(userCms, action, options, resources);
        }
        catch (CmsException e) {
            LOG.error((Object)"workflow action failed");
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public I_CmsVirtualProject getRealOrVirtualProject(CmsUUID projectId) {
        I_CmsVirtualProject result = (I_CmsVirtualProject)this.m_virtualProjects.get(projectId);
        if (result == null) {
            result = new CmsExtendedRealProjectWrapper(projectId);
        }
        return result;
    }

    public String getWorkflowProjectManagerGroup() {
        return this.getParameter(PARAM_WORKFLOW_PROJECT_MANAGER_GROUP, OpenCms.getDefaultUsers().getGroupAdministrators());
    }

    public String getWorkflowProjectUserGroup() {
        return this.getParameter(PARAM_WORKFLOW_PROJECT_USER_GROUP, OpenCms.getDefaultUsers().getGroupAdministrators());
    }

    @Override
    public CmsWorkflowResources getWorkflowResources(CmsObject cms, CmsWorkflow workflow, CmsPublishOptions options, boolean canOverrideWorkflow, boolean ignoreLimit) {
        String workflowKey = workflow.getId();
        String overrideId = null;
        Integer tooManyCount = null;
        if (WORKFLOW_RELEASE.equals(workflowKey)) {
            boolean tooMany = false;
            CmsWorkflowResources workflowResourcesBean = super.getWorkflowResources(cms, workflow, options, canOverrideWorkflow, ignoreLimit);
            List<CmsResource> result = workflowResourcesBean.getWorkflowResources();
            tooMany = workflowResourcesBean.isTooMany();
            if (tooMany) {
                tooManyCount = workflowResourcesBean.getTooManyCount();
            }
            if (canOverrideWorkflow && !workflowResourcesBean.isTooMany()) {
                boolean override = false;
                for (CmsResource permCheckResource : result) {
                    try {
                        boolean canPublish = cms.hasPermissions(permCheckResource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH);
                        if (canPublish) {
                            override = true;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Can't check permissions for " + permCheckResource.getRootPath() + ":" + e.getLocalizedMessage()), (Throwable)e);
                    }
                    if (!override) continue;
                    CmsWorkflowResources overrideWorkflowResources = this.getWorkflowResources(cms, this.getWorkflows(cms).get("WORKFLOW_PUBLISH"), options, false, false);
                    tooMany = overrideWorkflowResources.isTooMany();
                    tooManyCount = overrideWorkflowResources.getTooManyCount();
                    result = overrideWorkflowResources.getWorkflowResources();
                    overrideId = "WORKFLOW_PUBLISH";
                }
            }
            CmsWorkflowResources realResult = new CmsWorkflowResources(result, this.getWorkflows(cms).get(overrideId), tooManyCount);
            return realResult;
        }
        CmsWorkflowResources realResult = super.getWorkflowResources(cms, workflow, options, canOverrideWorkflow, ignoreLimit);
        return realResult;
    }

    @Override
    public Map<String, CmsWorkflow> getWorkflows(CmsObject cms) {
        Map<String, CmsWorkflow> parentWorkflows = super.getWorkflows(cms);
        LinkedHashMap<String, CmsWorkflow> result = new LinkedHashMap();
        String releaseLabel = this.getLabel(cms, "GUI_WORKFLOW_ACTION_RELEASE_0");
        CmsWorkflowAction release = new CmsWorkflowAction(ACTION_RELEASE, releaseLabel, true);
        ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
        actions.add(release);
        CmsWorkflow releaseWorkflow = new CmsWorkflow(WORKFLOW_RELEASE, releaseLabel, actions);
        try {
            boolean isProjectManager = this.isProjectManager(cms);
            if (isProjectManager) {
                result.putAll(parentWorkflows);
                result.put(WORKFLOW_RELEASE, releaseWorkflow);
            } else {
                result.put(WORKFLOW_RELEASE, releaseWorkflow);
                result.putAll(parentWorkflows);
            }
        }
        catch (CmsException e) {
            result = parentWorkflows;
        }
        return result;
    }

    @Override
    public void initialize(CmsObject adminCms) {
        super.initialize(adminCms);
        OpenCms.getPublishManager().addPublishListener(new CmsPublishEventAdapter(){

            @Override
            public void onFinish(CmsPublishJobRunning publishJob) {
                CmsExtendedWorkflowManager.this.onFinishPublishJob(publishJob);
            }

            @Override
            public void onStart(CmsPublishJobEnqueued publishJob) {
                CmsExtendedWorkflowManager.this.onStartPublishJob(publishJob);
            }
        });
    }

    protected CmsWorkflowResponse actionRelease(CmsObject userCms, List<CmsResource> resources) throws CmsException {
        this.checkNewParentsInList(userCms, resources);
        String projectName = this.generateProjectName(userCms);
        String projectDescription = this.generateProjectDescription(userCms);
        CmsObject offlineAdminCms = OpenCms.initCmsObject(this.m_adminCms);
        offlineAdminCms.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
        String managerGroup = this.getWorkflowProjectManagerGroup();
        String userGroup = this.getWorkflowProjectUserGroup();
        CmsProject workflowProject = this.m_adminCms.createProject(projectName, projectDescription, userGroup, managerGroup, CmsProject.PROJECT_TYPE_WORKFLOW);
        CmsObject newProjectCms = OpenCms.initCmsObject(offlineAdminCms);
        newProjectCms.getRequestContext().setCurrentProject(workflowProject);
        newProjectCms.getRequestContext().setSiteRoot("");
        newProjectCms.copyResourceToProject("/");
        CmsUser admin = offlineAdminCms.getRequestContext().getCurrentUser();
        this.clearLocks(userCms.getRequestContext().getCurrentProject(), resources);
        for (CmsResource resource : resources) {
            CmsLock lock = offlineAdminCms.getLock(resource);
            if (lock.isUnlocked()) {
                offlineAdminCms.lockResource(resource);
            } else if (!lock.isOwnedBy(admin)) {
                offlineAdminCms.changeLock(resource);
            }
            offlineAdminCms.writeProjectLastModified(resource, workflowProject);
            offlineAdminCms.unlockResource(resource);
        }
        for (CmsUser user : this.getNotificationMailRecipients()) {
            this.sendNotification(userCms, user, workflowProject, resources);
        }
        return new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), workflowProject.getUuid());
    }

    protected void checkNewParentsInList(CmsObject userCms, List<CmsResource> resources) throws CmsException {
        HashMap<String, CmsResource> resourcesByPath = new HashMap<String, CmsResource>();
        CmsObject rootCms = OpenCms.initCmsObject(this.m_adminCms);
        rootCms.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
        rootCms.getRequestContext().setSiteRoot("");
        for (CmsResource resource : resources) {
            resourcesByPath.put(resource.getRootPath(), resource);
        }
        for (CmsResource resource : resources) {
            String parentPath;
            CmsResource parent;
            if (!resource.getState().isNew() || (parent = (CmsResource)resourcesByPath.get(parentPath = CmsResource.getParentFolder(resource.getRootPath()))) != null || !(parent = rootCms.readResource(parentPath)).getState().isNew()) continue;
            throw new CmsNewParentNotInWorkflowException(Messages.get().container("ERR_NEW_PARENT_NOT_IN_WORKFLOW_1", resource.getRootPath()));
        }
    }

    protected void cleanupEmptyWorkflowProjects(List<CmsProject> projects) throws CmsException {
        if (projects == null) {
            projects = OpenCms.getOrgUnitManager().getAllManageableProjects(this.m_adminCms, "", true);
        }
        for (CmsProject project : projects) {
            if (!project.isWorkflowProject() || !this.isProjectEmpty(project)) continue;
            this.m_adminCms.deleteProject(project.getUuid());
        }
    }

    protected void cleanupProjectIfEmpty(CmsProject project) throws CmsException {
        if (project.getType().getMode() == CmsProject.PROJECT_TYPE_WORKFLOW.getMode() && this.isProjectEmpty(project)) {
            LOG.info((Object)("Removing project " + project.getName() + " because it is an empty workflow project."));
            this.m_adminCms.deleteProject(project.getUuid());
        }
    }

    protected void clearLocks(CmsProject project, List<CmsResource> resources) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(this.m_adminCms);
        rootCms.getRequestContext().setCurrentProject(project);
        rootCms.getRequestContext().setSiteRoot("");
        for (CmsResource resource : resources) {
            CmsLock lock = rootCms.getLock(resource);
            if (lock.isUnlocked()) continue;
            String currentPath = resource.getRootPath();
            while (lock.isInherited()) {
                currentPath = CmsResource.getParentFolder(currentPath);
                lock = rootCms.getLock(currentPath);
            }
            rootCms.changeLock(currentPath);
            rootCms.unlockResource(currentPath);
        }
    }

    protected boolean existsProject(String projectName) {
        try {
            this.m_adminCms.readProject(projectName);
            return true;
        }
        catch (CmsException e) {
            return false;
        }
    }

    protected String generateProjectDescription(CmsObject userCms) {
        CmsUser user = userCms.getRequestContext().getCurrentUser();
        OpenCms.getLocaleManager();
        Locale locale = CmsLocaleManager.getDefaultLocale();
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        DateFormat format = DateFormat.getDateTimeInstance(3, 2, locale);
        String dateString = format.format(date);
        String result = Messages.get().getBundle(locale).key("GUI_WORKFLOW_PROJECT_DESCRIPTION_2", user.getName(), dateString);
        return result;
    }

    protected String generateProjectName(CmsObject userCms) {
        String projectName = this.generateProjectName(userCms, true);
        if (this.existsProject(projectName)) {
            projectName = this.generateProjectName(userCms, false);
        }
        return projectName;
    }

    protected String generateProjectName(CmsObject userCms, boolean shortTime) {
        CmsUser user = userCms.getRequestContext().getCurrentUser();
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        OpenCms.getLocaleManager();
        Locale locale = CmsLocaleManager.getDefaultLocale();
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        DateFormat timeFormat = DateFormat.getTimeInstance(shortTime ? 3 : 2, locale);
        String dateStr = dateFormat.format(date) + " " + timeFormat.format(date);
        String username = user.getName();
        String result = Messages.get().getBundle(locale).key("GUI_WORKFLOW_PROJECT_NAME_2", username, dateStr);
        result = result.replaceAll("/", "|");
        return result;
    }

    protected List<CmsUser> getNotificationMailRecipients() {
        String group = this.getWorkflowProjectManagerGroup();
        CmsObject cms = this.m_adminCms;
        try {
            List<CmsUser> users = cms.getUsersOfGroup(group);
            return users;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new ArrayList<CmsUser>();
        }
    }

    protected String getNotificationResource(CmsObject cms) {
        String result = this.getParameter(PARAM_NOTIFICATION_CONTENT, OpenCms.getSystemInfo().getConfigFilePath(cms, "notification/workflow-notification"));
        return result;
    }

    protected CmsWorkflowResponse getPublishBrokenRelationsResponse(CmsObject userCms, List<CmsPublishResource> publishResources) {
        ArrayList<CmsWorkflowAction> actions = new ArrayList<CmsWorkflowAction>();
        String forcePublishLabel = Messages.get().getBundle(this.getLocale(userCms)).key("GUI_WORKFLOW_ACTION_FORCE_PUBLISH_0");
        CmsWorkflowAction forcePublish = new CmsWorkflowAction("forcepublish", forcePublishLabel, true, true);
        actions.add(forcePublish);
        return new CmsWorkflowResponse(false, Messages.get().getBundle(this.getLocale(userCms)).key("GUI_BROKEN_LINKS_0"), publishResources, actions, null);
    }

    protected CmsWorkflowResponse getSuccessResponse() {
        return new CmsWorkflowResponse(true, "", new ArrayList<CmsPublishResource>(), new ArrayList<CmsWorkflowAction>(), null);
    }

    protected boolean isProjectEmpty(CmsProject project) throws CmsException {
        List<CmsResource> resources = this.m_adminCms.readProjectView(project.getUuid(), CmsResourceState.STATE_KEEP);
        return resources.isEmpty();
    }

    protected boolean isProjectManager(CmsObject userCms) throws CmsException {
        CmsGroup managerGroup = this.m_adminCms.readGroup(this.getWorkflowProjectManagerGroup());
        List<CmsGroup> groups = this.m_adminCms.getGroupsOfUser(userCms.getRequestContext().getCurrentUser().getName(), false);
        return groups.contains(managerGroup);
    }

    protected void onFinishPublishJob(CmsPublishJobRunning publishJob) {
        try {
            this.cleanupEmptyWorkflowProjects(null);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void onStartPublishJob(CmsPublishJobEnqueued publishJob) {
    }

    protected void sendNotification(CmsObject userCms, CmsUser recipient, CmsProject workflowProject, List<CmsResource> resources) {
        try {
            String linkHref = OpenCms.getLinkManager().getServerLink(userCms, "/system/workplace/commons/publish.jsp?publishProjectId=" + workflowProject.getUuid() + "&" + "confirm" + "=true");
            CmsWorkflowNotification notification = new CmsWorkflowNotification(this.m_adminCms, userCms, recipient, this.getNotificationResource(this.m_adminCms), workflowProject, resources, linkHref);
            notification.send();
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
        }
    }
}

