/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsLog;

public class CmsAccountInfo {
    private static final Log LOG = CmsLog.getLog(CmsAccountInfo.class);
    private String m_addInfoKey;
    private boolean m_editable;
    private Field m_field;

    public CmsAccountInfo(Field field, String addInfoKey, boolean editable) {
        this.m_field = field;
        this.m_addInfoKey = addInfoKey;
        this.m_editable = editable;
    }

    public CmsAccountInfo(String field, String addInfoKey, String editable) {
        this.m_field = Field.valueOf(field);
        this.m_addInfoKey = addInfoKey;
        this.m_editable = Boolean.parseBoolean(editable);
    }

    public String getAddInfoKey() {
        return this.m_addInfoKey;
    }

    public Field getField() {
        return this.m_field;
    }

    public String getValue(CmsUser user) {
        String value = null;
        if (this.isAdditionalInfo()) {
            value = (String)user.getAdditionalInfo(this.getAddInfoKey());
        } else {
            try {
                PropertyUtilsBean propUtils = new PropertyUtilsBean();
                value = (String)propUtils.getProperty((Object)user, this.getField().name());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error((Object)"Error reading account info field.", (Throwable)e);
            }
        }
        return value;
    }

    public boolean isAdditionalInfo() {
        return Field.addinfo.equals((Object)this.m_field);
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public static enum Field {
        addinfo,
        address,
        city,
        country,
        email,
        firstname,
        institution,
        lastname,
        zipcode;

    }
}

