/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;

public class CmsWorkplaceLoginHandler
implements I_CmsResourceInit {
    public static final String LOGIN_HANDLER = "/system/login";
    public static final String LOGIN_FORM = "/system/login/index.html";

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        if (resource != null) {
            return resource;
        }
        String uri = cms.getRequestContext().getUri();
        if (!uri.startsWith(LOGIN_HANDLER)) {
            return resource;
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("/");
            resource = cms.readResource(LOGIN_FORM);
        }
        catch (CmsException e) {
            throw new CmsResourceInitException(e.getMessageContainer(), (Throwable)e);
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
            if (resource != null) {
                cms.getRequestContext().setUri(cms.getSitePath(resource));
            }
        }
        String ou = uri.substring(LOGIN_HANDLER.length());
        if (!ou.startsWith("/")) {
            ou = "/" + ou;
        }
        if (!ou.endsWith("/")) {
            ou = ou + "/";
        }
        req.setAttribute("ocPredefOuFqn", (Object)ou);
        return resource;
    }
}

