/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.I_CmsWorkplaceMessageBundleProvider;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsWorkplaceMessages
extends CmsMultiMessages {
    public static final String GUI_NEW_RESOURCE_TITLE_PREFIX = "title.new";
    public static final String PREFIX_BUNDLE_MESSAGES = ".messages";
    public static final String PREFIX_BUNDLE_WORKPLACE = ".workplace";
    public static final String WORKPLACE_BUNDLE_NAME = CmsWorkplaceMessages.class.getName();
    private static Log LOG = CmsLog.getLog(CmsWorkplaceMessages.class.getName());

    public CmsWorkplaceMessages(Locale locale) {
        super(locale);
        this.setBundleName(WORKPLACE_BUNDLE_NAME);
        this.addMessages(CmsWorkplaceMessages.collectModuleMessages(locale));
    }

    public static String getNewResourceTitle(CmsWorkplace wp, String name) {
        String title = wp.key(GUI_NEW_RESOURCE_TITLE_PREFIX + name.toLowerCase());
        if (CmsMessages.isUnknownKey(title)) {
            title = wp.key("GUI_TITLE_NEWFILEOTHER_0");
        }
        return title;
    }

    public static String getResourceTypeDescription(CmsWorkplace wp, String name) {
        String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(name).getInfo();
        return wp.keyDefault(key, name);
    }

    public static String getResourceTypeDescription(Locale locale, String name) {
        String key;
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(name);
        if (settings != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(key = settings.getInfo())) {
            return OpenCms.getWorkplaceManager().getMessages(locale).keyDefault(key, name);
        }
        return "";
    }

    public static String getResourceTypeName(CmsWorkplace wp, String name) {
        CmsExplorerTypeSettings typeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(name);
        if (typeSettings == null) {
            return name;
        }
        String key = typeSettings.getKey();
        return wp.keyDefault(key, name);
    }

    public static String getResourceTypeName(Locale locale, String name) {
        CmsExplorerTypeSettings typeSettings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(name);
        if (typeSettings == null) {
            return name;
        }
        String key = typeSettings.getKey();
        return OpenCms.getWorkplaceManager().getMessages(locale).keyDefault(key, name);
    }

    private static List<CmsMessages> collectModuleMessages(Locale locale) {
        ArrayList<CmsMessages> result = new ArrayList<CmsMessages>();
        HashSet<String> names = new HashSet<String>();
        Set<String> modules = OpenCms.getModuleManager().getModuleNames();
        if (modules != null) {
            names.addAll(modules);
        }
        Iterator<I_CmsWorkplaceMessageBundleProvider> providers = ServiceLoader.load(I_CmsWorkplaceMessageBundleProvider.class).iterator();
        while (providers.hasNext()) {
            try {
                I_CmsWorkplaceMessageBundleProvider provider = providers.next();
                names.addAll(provider.getMessageBundleNames());
            }
            catch (Throwable t) {
                LOG.error((Object)"Error loading workplace messages bundle names from classpath.", t);
            }
        }
        for (String baseName : names) {
            String bundleName = baseName + PREFIX_BUNDLE_WORKPLACE;
            CmsMessages msg = new CmsMessages(bundleName, locale);
            if (msg.isInitialized()) {
                result.add(msg);
            }
            if (!(msg = new CmsMessages(bundleName = baseName + PREFIX_BUNDLE_MESSAGES, locale)).isInitialized()) continue;
            result.add(msg);
        }
        I_CmsMessageBundle[] coreMsgs = A_CmsMessageBundle.getOpenCmsMessageBundles();
        for (int i = 0; i < coreMsgs.length; ++i) {
            I_CmsMessageBundle bundle = coreMsgs[i];
            result.add(bundle.getBundle(locale));
        }
        if (OpenCms.getADEManager().isInitialized()) {
            Set<String> bundleNames = OpenCms.getADEManager().getConfiguredWorkplaceBundles();
            for (String bundleName : bundleNames) {
                CmsMessages msg = new CmsMessages(bundleName, locale);
                if (!msg.isInitialized()) continue;
                result.add(msg);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsWorkplaceMessages) {
            CmsMessages other = (CmsMessages)obj;
            return other.getLocale().equals(this.getLocale());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getLocale().hashCode();
    }
}

