/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.CmsException;
import org.opencms.workplace.comparison.CmsElementComparison;
import org.opencms.workplace.comparison.CmsResourceComparison;
import org.opencms.workplace.comparison.CmsXmlContentElementComparison;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXmlDocumentComparison
extends CmsResourceComparison {
    private List<CmsElementComparison> m_elements;

    public CmsXmlDocumentComparison(CmsObject cms, CmsFile res1, CmsFile res2) throws CmsException {
        A_CmsXmlDocument resource2;
        A_CmsXmlDocument resource1;
        List<CmsElementComparison> elements1 = null;
        List<CmsElementComparison> elements2 = null;
        if (CmsResourceTypeXmlPage.isXmlPage(res1) && CmsResourceTypeXmlPage.isXmlPage(res2)) {
            resource1 = CmsXmlPageFactory.unmarshal(cms, res1);
            resource2 = CmsXmlPageFactory.unmarshal(cms, res2);
            elements1 = this.getElements(resource1);
            elements2 = this.getElements(resource2);
        } else {
            resource1 = CmsXmlContentFactory.unmarshal(cms, res1);
            CmsXmlContentElementPathExtractor visitor = new CmsXmlContentElementPathExtractor();
            ((CmsXmlContent)resource1).visitAllValuesWith(visitor);
            elements1 = visitor.getElementPaths();
            resource2 = CmsXmlContentFactory.unmarshal(cms, res2);
            visitor = new CmsXmlContentElementPathExtractor();
            ((CmsXmlContent)resource2).visitAllValuesWith(visitor);
            elements2 = visitor.getElementPaths();
        }
        ArrayList<CmsElementComparison> removed = new ArrayList<CmsElementComparison>(elements1);
        removed.removeAll(elements2);
        for (CmsElementComparison elem : removed) {
            elem.setStatus("removed");
            String value = resource1.getValue(elem.getName(), elem.getLocale()).getStringValue(cms);
            elem.setVersion1(value);
            elem.setVersion2("");
        }
        ArrayList<CmsElementComparison> added = new ArrayList<CmsElementComparison>(elements2);
        added.removeAll(elements1);
        for (CmsElementComparison elem : added) {
            elem.setStatus("added");
            elem.setVersion1("");
            I_CmsXmlContentValue contentValue = resource2.getValue(elem.getName(), elem.getLocale());
            String value = contentValue.getStringValue(cms);
            elem.setVersion2(value);
        }
        ArrayList<CmsElementComparison> union = new ArrayList<CmsElementComparison>(elements1);
        union.retainAll(elements2);
        for (CmsElementComparison elem : new ArrayList<CmsElementComparison>(union)) {
            String value1 = resource1.getValue(elem.getName(), elem.getLocale()).getStringValue(cms);
            String value2 = resource2.getValue(elem.getName(), elem.getLocale()).getStringValue(cms);
            if (value1 == null) {
                value1 = "";
            }
            if (value2 == null) {
                value2 = "";
            }
            elem.setVersion1(value1);
            elem.setVersion2(value2);
            if (!value1.equals(value2)) {
                elem.setStatus("changed");
                continue;
            }
            elem.setStatus("unchanged");
        }
        this.m_elements = new ArrayList<CmsElementComparison>(removed);
        this.m_elements.addAll(added);
        this.m_elements.addAll(union);
        Collections.sort(this.m_elements);
    }

    public List<CmsElementComparison> getElements() {
        if (this.m_elements == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_elements);
    }

    private List<CmsElementComparison> getElements(I_CmsXmlDocument xmlPage) {
        ArrayList<CmsElementComparison> elements = new ArrayList<CmsElementComparison>();
        for (Locale locale : xmlPage.getLocales()) {
            for (String elementName : xmlPage.getNames(locale)) {
                elements.add(new CmsElementComparison(locale, elementName));
            }
        }
        return elements;
    }

    static class CmsXmlContentElementPathExtractor
    implements I_CmsXmlContentValueVisitor {
        private List<CmsElementComparison> m_elementPaths = new ArrayList<CmsElementComparison>();

        CmsXmlContentElementPathExtractor() {
        }

        @Override
        public void visit(I_CmsXmlContentValue value) {
            if (value.isSimpleType()) {
                this.m_elementPaths.add(new CmsXmlContentElementComparison(value.getLocale(), value.getPath(), value.getTypeName()));
            }
        }

        List<CmsElementComparison> getElementPaths() {
            return this.m_elementPaths;
        }
    }
}

