/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.I_CmsCollectorInfoFactory;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.editors.directedit.A_CmsDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditPermissions;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsAdvancedDirectEditProvider
extends A_CmsDirectEditProvider {
    private static final Log LOG = CmsLog.getLog(CmsAdvancedDirectEditProvider.class);
    protected int m_lastPermissionMode;
    protected boolean m_useIds;
    private Random m_random = new Random();

    public String endDirectEditDisabled() {
        return "";
    }

    public String endDirectEditEnabled() {
        return "<div class=\"oc-editable-end\"></div>\n";
    }

    public synchronized String getRandomId() {
        return "editable_" + Math.abs(this.m_random.nextLong());
    }

    @Override
    public CmsDirectEditResourceInfo getResourceInfo(String resourceName) {
        try {
            boolean locked;
            if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            if (CmsResource.isTemporaryFileName(resourceName)) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            if (!this.m_cms.isInsideCurrentProject(resourceName)) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            CmsResource resource = this.m_cms.readResource(resourceName, CmsResourceFilter.ALL);
            if (!OpenCms.getResourceManager().getResourceType(resource.getTypeId()).isDirectEditable() && !resource.isFolder()) {
                return CmsDirectEditResourceInfo.INACTIVE;
            }
            CmsLock lock = this.m_cms.getLock(resource);
            boolean bl = locked = !lock.isUnlocked() && !lock.isOwnedInProjectBy(this.m_cms.getRequestContext().getCurrentUser(), this.m_cms.getRequestContext().getCurrentProject());
            if (locked) {
                return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.DISABLED, resource, lock);
            }
            return new CmsDirectEditResourceInfo(CmsDirectEditPermissions.ENABLED, resource, lock);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CALC_EDIT_MODE_FAILED_1", resourceName), (Throwable)e);
            }
            return CmsDirectEditResourceInfo.INACTIVE;
        }
    }

    @Override
    public void insertDirectEditEnd(PageContext context) throws JspException {
        String content;
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                content = this.endDirectEditEnabled();
                break;
            }
            default: {
                content = null;
            }
        }
        this.m_lastPermissionMode = 0;
        this.print(context, content);
    }

    @Override
    public void insertDirectEditIncludes(PageContext context, CmsDirectEditParams params) throws JspException {
    }

    @Override
    public void insertDirectEditListMetadata(PageContext context, I_CmsContentLoadCollectorInfo info) throws JspException {
        if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return;
        }
        I_CmsCollectorInfoFactory collectorInfoFactory = (I_CmsCollectorInfoFactory)AutoBeanFactorySource.create(I_CmsCollectorInfoFactory.class);
        AutoBean<I_CmsContentLoadCollectorInfo> collectorInfoAutoBean = collectorInfoFactory.wrapCollectorInfo(info);
        String serializedCollectorInfo = AutoBeanCodex.encode(collectorInfoAutoBean).getPayload();
        String marker = "<div class='oc-collector-info' style='display: none !important;' data-oc-collector='" + CmsEncoder.escapeXml(serializedCollectorInfo) + "'></div>";
        this.print(context, marker);
    }

    @Override
    public boolean insertDirectEditStart(PageContext context, CmsDirectEditParams params) throws JspException {
        String content;
        CmsDirectEditResourceInfo resourceInfo = this.getResourceInfo(params.getResourceName());
        this.m_lastPermissionMode = resourceInfo.getPermissions().getPermission();
        switch (this.m_lastPermissionMode) {
            case 1: 
            case 2: {
                try {
                    CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance(context.getRequest());
                    CmsJspStandardContextBean.CmsContainerElementWrapper element = contextBean.getElement();
                    if (element != null && ((CmsContainerElementBean)element).getId().equals(resourceInfo.getResource().getStructureId())) {
                        params.m_element = ((CmsContainerElementBean)element).editorHash();
                        params.setContainerElement(element);
                    }
                    content = this.startDirectEditEnabled(params, resourceInfo);
                    break;
                }
                catch (JSONException e) {
                    throw new JspException((Throwable)e);
                }
            }
            default: {
                content = null;
            }
        }
        this.print(context, content);
        return content != null;
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return false;
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsAdvancedDirectEditProvider result = new CmsAdvancedDirectEditProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        StringBuffer result = new StringBuffer(256);
        result.append("<!-- EDIT BLOCK START (DISABLED): ");
        result.append(params.m_resourceName);
        result.append(" [");
        result.append(resourceInfo.getResource().getState());
        result.append("] ");
        if (!resourceInfo.getLock().isUnlocked()) {
            result.append(" locked ");
            result.append(resourceInfo.getLock().getProject().getName());
        }
        result.append(" -->\n");
        return result.toString();
    }

    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) throws JSONException {
        String editLocale = this.m_cms.getRequestContext().getLocale().toString();
        String editId = this.getNextDirectEditId();
        String editNewLink = CmsEncoder.encode(params.getLinkForNew());
        JSONObject editableData = new JSONObject();
        CmsResource resource = resourceInfo.getResource();
        boolean writable = false;
        if (resource != null) {
            try {
                writable = this.m_cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        editableData.put("editId", editId);
        CmsContainerElementBean containerElement = params.getContainerElement();
        if (containerElement != null) {
            editableData.put("ATTR_ELEMENT_ID", containerElement.editorHash());
        }
        editableData.put("structureId", resourceInfo.getResource().getStructureId());
        editableData.put("sitePath", params.getResourceName());
        editableData.put("elementlanguage", editLocale);
        editableData.put("elementname", params.getElement());
        editableData.put("newlink", editNewLink);
        editableData.put("hasResource", resource != null);
        editableData.put("hasEdit", params.getButtonSelection().isShowEdit() && writable);
        editableData.put("hasDelete", params.getButtonSelection().isShowDelete() && writable);
        editableData.put("hasNew", params.getButtonSelection().isShowNew());
        editableData.put("newtitle", this.m_messages.key("GUI_EDITOR_TITLE_NEW_0"));
        editableData.put("unreleaseOrExpired", !resourceInfo.getResource().isReleasedAndNotExpired(System.currentTimeMillis()));
        if (params.getId() != null) {
            editableData.put("contextId", params.getId().toString());
        }
        editableData.put("postCreateHandler", params.getPostCreateHandler());
        CmsUUID viewId = CmsUUID.getNullUUID();
        boolean hasEditHandler = false;
        if (resourceInfo.getResource() != null && resourceInfo.getResource().isFile()) {
            CmsADEConfigData configData;
            CmsResourceTypeConfig typeConfig;
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resourceInfo.getResource());
            if (type instanceof CmsResourceTypeXmlContent) {
                boolean bl = hasEditHandler = ((CmsResourceTypeXmlContent)type).getEditHandler(this.m_cms) != null;
            }
            if ((typeConfig = (configData = OpenCms.getADEManager().lookupConfiguration(this.m_cms, resourceInfo.getResource().getRootPath())).getResourceType(OpenCms.getResourceManager().getResourceType(resourceInfo.getResource()).getTypeName())) != null) {
                viewId = typeConfig.getElementView();
            }
        }
        editableData.put("elementView", viewId);
        editableData.put("hasEditHandler", hasEditHandler);
        if (this.m_lastPermissionMode == 1) {
            try {
                String noEditReason = new CmsResourceUtil(this.m_cms, resourceInfo.getResource()).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms), true);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(noEditReason)) {
                    editableData.put("noEditReason", noEditReason);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        StringBuffer result = new StringBuffer(512);
        if (this.m_useIds) {
            result.append("<div id=\"" + this.getRandomId() + "\" class='" + "oc-editable" + "' " + "data-oc-editable" + "='").append(editableData.toString()).append("'></div>\n");
        } else {
            result.append("<div class='oc-editable' data-oc-editable='").append(editableData.toString()).append("'></div>\n");
        }
        return result.toString();
    }
}

