/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.editors.directedit.A_CmsDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.workplace.editors.directedit.CmsDirectEditResourceInfo;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

public class CmsDirectEditDefaultProvider
extends A_CmsDirectEditProvider {
    private static final Log LOG = CmsLog.getLog(CmsDirectEditDefaultProvider.class);
    protected int m_lastPermissionMode;
    private String m_headerInclude;

    public String endDirectEditDisabled() {
        return "</div>\n<!-- EDIT BLOCK END (DISABLED) -->\n";
    }

    public String endDirectEditEnabled() {
        return "</div>\n<!-- EDIT BLOCK END (ENABLED) -->\n";
    }

    public String getDirectEditIncludes(CmsDirectEditParams params) {
        CmsMacroResolver resolver = this.prepareMacroResolverForIncludes(params);
        return resolver.resolveMacros(this.m_headerInclude);
    }

    @Override
    public void init(CmsObject cms, CmsDirectEditMode mode, String fileName) {
        super.init(cms, mode, fileName);
        CmsMemoryObjectCache cache = CmsMemoryObjectCache.getInstance();
        this.m_headerInclude = (String)cache.getCachedObject(CmsDirectEditDefaultProvider.class, this.m_fileName);
        if (this.m_headerInclude == null) {
            try {
                CmsFile file = this.m_cms.readFile(this.m_fileName);
                this.m_headerInclude = this.getContentAsString(file);
                cache.putCachedObject(CmsDirectEditDefaultProvider.class, this.m_fileName, this.m_headerInclude);
            }
            catch (CmsException e) {
                this.m_headerInclude = "";
                LOG.error((Object)Messages.get().getBundle().key("LOG_DIRECT_EDIT_NO_HEADER_1", fileName), (Throwable)e);
            }
        }
    }

    @Override
    public void insertDirectEditEnd(PageContext context) throws JspException {
        String content;
        switch (this.m_lastPermissionMode) {
            case 1: {
                content = this.endDirectEditDisabled();
                break;
            }
            case 2: {
                content = this.endDirectEditEnabled();
                break;
            }
            default: {
                content = null;
            }
        }
        this.m_lastPermissionMode = 0;
        this.print(context, content);
    }

    @Override
    public void insertDirectEditIncludes(PageContext context, CmsDirectEditParams params) throws JspException {
        this.print(context, this.getDirectEditIncludes(params));
    }

    @Override
    public boolean insertDirectEditStart(PageContext context, CmsDirectEditParams params) throws JspException {
        String content;
        CmsDirectEditResourceInfo resourceInfo = this.getResourceInfo(params.getResourceName());
        this.m_lastPermissionMode = resourceInfo.getPermissions().getPermission();
        switch (this.m_lastPermissionMode) {
            case 1: {
                content = this.startDirectEditDisabled(params, resourceInfo);
                break;
            }
            case 2: {
                content = this.startDirectEditEnabled(params, resourceInfo);
                break;
            }
            default: {
                content = null;
            }
        }
        this.print(context, content);
        return content != null;
    }

    @Override
    public boolean isManual(CmsDirectEditMode mode) {
        return false;
    }

    @Override
    public I_CmsDirectEditProvider newInstance() {
        CmsDirectEditDefaultProvider result = new CmsDirectEditDefaultProvider();
        result.m_configurationParameters = this.m_configurationParameters;
        return result;
    }

    public String startDirectEditDisabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        String editId = this.getNextDirectEditId();
        StringBuffer result = new StringBuffer(256);
        result.append("<!-- EDIT BLOCK START (DISABLED): ");
        result.append(params.m_resourceName);
        result.append(" [");
        result.append(resourceInfo.getResource().getState());
        result.append("] ");
        if (!resourceInfo.getLock().isUnlocked()) {
            result.append(" locked ");
            result.append(resourceInfo.getLock().getProject().getName());
        }
        result.append(" -->\n");
        result.append("<script type=\"text/javascript\">\n");
        result.append("registerButtonOcms(\"").append(editId).append("\");\n");
        result.append("</script>\n");
        result.append("<div class=\"ocms_de_bt\" id=\"buttons_").append(editId).append("\">\n");
        result.append("<span onmouseover=\"activateOcms('").append(editId).append("');\" onmouseout=\"deactivateOcms('").append(editId).append("');\">\n");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" id=\"table_").append(editId).append("\"><tr>\n");
        result.append("<td class=\"ocms_de\"><span class=\"ocms_disabled\">");
        if (this.m_editButtonStyle == 1) {
            result.append("<span class=\"ocms_combobutton\" style=\"background-image: url('").append(CmsWorkplace.getSkinUri()).append("buttons/directedit_in.png');\">&nbsp;").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("</span>");
        } else if (this.m_editButtonStyle == 2) {
            result.append("<span class=\"ocms_combobutton\" style=\"padding-left: 4px;\">").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("</span>");
        } else {
            result.append("<img border=\"0\" src=\"").append(CmsWorkplace.getSkinUri()).append("buttons/directedit_in.png\" title=\"").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_LOCKED_0")).append("\" alt=\"\"/>");
        }
        result.append("</span></td>\n");
        result.append("</tr></table>\n");
        result.append("</span>\n");
        result.append("</div>\n");
        result.append("<div id=\"").append(editId).append("\" class=\"ocms_de_norm\">\n");
        return result.toString();
    }

    public String startDirectEditEnabled(CmsDirectEditParams params, CmsDirectEditResourceInfo resourceInfo) {
        String editLocale = this.m_cms.getRequestContext().getLocale().toString();
        String editId = this.getNextDirectEditId();
        StringBuffer result = new StringBuffer(512);
        String uri = this.m_cms.getRequestContext().getUri();
        String editLink = this.getLink(params.getLinkForEdit());
        String editNewLink = CmsEncoder.encode(params.getLinkForNew());
        result.append("<!-- EDIT BLOCK START (ENABLED): ");
        result.append(params.m_resourceName);
        result.append(" [");
        result.append(resourceInfo.getResource().getState());
        result.append("]");
        if (!resourceInfo.getLock().isUnlocked()) {
            result.append(" locked ");
            result.append(resourceInfo.getLock().getProject().getName());
        }
        result.append(" -->\n");
        result.append("<script type=\"text/javascript\">\n");
        result.append("registerButtonOcms(\"").append(editId).append("\");\n");
        result.append("</script>\n");
        result.append("<div class=\"ocms_de_bt\" id=\"buttons_").append(editId).append("\">\n");
        result.append("<form name=\"form_").append(editId).append("\" id=\"form_").append(editId).append("\" method=\"post\" action=\"").append(editLink).append("\" class=\"ocms_nomargin\" target=\"_top\">\n");
        result.append("<input type=\"hidden\" name=\"resource\" value=\"").append(params.getResourceName()).append("\"/>\n");
        result.append("<input type=\"hidden\" name=\"directedit\" value=\"true\"/>\n");
        result.append("<input type=\"hidden\" name=\"elementlanguage\" value=\"").append(editLocale).append("\"/>\n");
        result.append("<input type=\"hidden\" name=\"elementname\" value=\"").append(params.getElement()).append("\"/>\n");
        result.append("<input type=\"hidden\" name=\"backlink\" value=\"").append(uri).append("\"/>\n");
        result.append("<input type=\"hidden\" name=\"newlink\"/>\n");
        result.append("<input type=\"hidden\" name=\"closelink\"/>\n");
        result.append("<input type=\"hidden\" name=\"redirect\" value=\"true\"/>\n");
        result.append("<input type=\"hidden\" name=\"editortitle\"/>\n");
        result.append("</form>\n");
        result.append("<table onmouseover=\"activateOcms('").append(editId).append("');\" onmouseout=\"deactivateOcms('").append(editId).append("');\"");
        result.append(" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" id=\"table_").append(editId).append("\"><tr>\n");
        if (params.getButtonSelection().isShowEdit()) {
            result.append("<td class=\"ocms_de\"><a href=\"#\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("edit").append("');\" class=\"ocms_button\"><span class=\"ocms_over\" onmouseover=\"className='ocms_over'\" onmouseout=\"className='ocms_over'\" onmousedown=\"className='ocms_push'\" onmouseup=\"className='ocms_over'\">");
            if (this.m_editButtonStyle == 1) {
                result.append("<span id=\"bt_").append(editId).append("\" class=\"ocms_combobutton\" style=\"background-image: url('").append(CmsWorkplace.getSkinUri()).append("buttons/directedit_cl.png');\">&nbsp;").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_EDIT_0")).append("</span>");
            } else if (this.m_editButtonStyle == 2) {
                result.append("<span class=\"ocms_combobutton\" style=\"padding-left: 4px;\">").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_EDIT_0")).append("</span>");
            } else {
                result.append("<span id=\"bt_").append(editId).append("\" class=\"ocms_combobutton\" style=\"padding-left: 15px; padding-right: 1px; background-image: url('").append(CmsWorkplace.getSkinUri()).append("buttons/directedit_cl.png'); background-position: 0px 0px;\" title=\"").append(this.m_messages.key("GUI_EDITOR_FRONTEND_BUTTON_EDIT_0")).append("\">&nbsp;</span>");
            }
            result.append("</span></a></td>\n");
        }
        if (params.getButtonSelection().isShowDelete()) {
            result.append("<td class=\"ocms_de\"><a href=\"#\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("delete").append("');\" class=\"ocms_button\"><span class=\"ocms_over\" onmouseover=\"className='ocms_over'\" onmouseout=\"className='ocms_over'\" onmousedown=\"className='ocms_push'\" onmouseup=\"className='ocms_over'\">");
            if (this.m_editButtonStyle == 1) {
                result.append("<span id=\"del_").append(editId).append("\" class=\"ocms_combobutton\" style=\"background-image: url('").append(CmsWorkplace.getSkinUri()).append("buttons/deletecontent.png');\">&nbsp;").append(this.m_messages.key("GUI_BUTTON_DELETE_0")).append("</span>");
            } else if (this.m_editButtonStyle == 2) {
                result.append("<span class=\"ocms_combobutton\" style=\"padding-left: 4px;\">").append(this.m_messages.key("GUI_BUTTON_DELETE_0")).append("</span>");
            } else {
                result.append("<img border=\"0\" src=\"").append(CmsWorkplace.getSkinUri()).append("buttons/deletecontent.png\" title=\"").append(this.m_messages.key("GUI_BUTTON_DELETE_0")).append("\" alt=\"\"/>");
            }
            result.append("</span></a></td>\n");
        }
        if (params.getButtonSelection().isShowNew()) {
            result.append("<td class=\"ocms_de\"><a href=\"#\" onclick=\"javascript:submitOcms('").append(editId).append("', '").append("new").append("', '").append(editNewLink).append("');\" class=\"ocms_button\"><span class=\"ocms_over\" onmouseover=\"className='ocms_over'\" onmouseout=\"className='ocms_over'\" onmousedown=\"className='ocms_push'\" onmouseup=\"className='ocms_over'\">");
            if (this.m_editButtonStyle == 1) {
                result.append("<span id=\"new_").append(editId).append("\" class=\"ocms_combobutton\" style=\"background-image: url('").append(CmsWorkplace.getSkinUri()).append("buttons/new.png');\">&nbsp;").append(this.m_messages.key("GUI_BUTTON_NEW_0")).append("</span>");
            } else if (this.m_editButtonStyle == 2) {
                result.append("<span class=\"ocms_combobutton\" style=\"padding-left: 4px;\">").append(this.m_messages.key("GUI_BUTTON_NEW_0")).append("</span>");
            } else {
                result.append("<img border=\"0\" src=\"").append(CmsWorkplace.getSkinUri()).append("buttons/new.png\" title=\"").append(this.m_messages.key("GUI_BUTTON_NEW_0")).append("\" alt=\"\"/>");
            }
            result.append("</span></a></td>");
        }
        result.append("</tr></table>\n");
        result.append("</div>\n");
        result.append("<div id=\"").append(editId).append("\" class=\"ocms_de_norm\">");
        return result.toString();
    }

    protected String getContentAsString(CmsFile file) throws CmsException {
        CmsProperty p = this.m_cms.readPropertyObject(file, "content-encoding", true);
        String e = p.getValue();
        if (e == null) {
            e = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.createString(file.getContents(), e);
    }

    protected CmsMacroResolver prepareMacroResolverForIncludes(CmsDirectEditParams params) {
        String closeLink = this.getLink(params.getLinkForClose());
        String deleteLink = this.getLink(params.getLinkForDelete());
        String titleForNew = this.m_messages.key("GUI_EDITOR_TITLE_NEW_0");
        String skinUri = CmsWorkplace.getSkinUri();
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro("closeLink", closeLink);
        resolver.addMacro("deleteLink", deleteLink);
        resolver.addMacro("titleForNew", titleForNew);
        resolver.addMacro("skinUri", skinUri);
        return resolver;
    }
}

