/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CmsXmlEntityResolver
implements EntityResolver,
I_CmsEventListener {
    public static final int CONTENT_DEFINITION_CACHE_SIZE = 2048;
    public static final String INTERNAL_SCHEME = "internal://";
    public static final String OPENCMS_SCHEME = "opencms://";
    private static final String[][] LEGACY_TRANSLATIONS = new String[][]{{"opencms://system/modules/org.opencms.ade.config/schemas/", "internal://org/opencms/xml/adeconfig/"}, {"opencms://system/modules/org.opencms.ade.containerpage/schemas/", "internal://org/opencms/xml/containerpage/"}, {"opencms://system/modules/org.opencms.ade.sitemap/schemas/", "internal://org/opencms/xml/adeconfig/sitemap/"}, {"opencms://system/modules/org.opencms.ugc/schemas/", "internal://org/opencms/ugc/"}, {"opencms://system/modules/org.opencms.jsp.search/schemas/", "internal://org/opencms/jsp/search/"}};
    private static final Log LOG = CmsLog.getLog(CmsXmlEntityResolver.class);
    private static Map<String, CmsXmlContentDefinition> m_cacheContentDefinitions;
    private static Map<String, byte[]> m_cachePermanent;
    private static Map<String, byte[]> m_cacheTemporary;
    private static final String XMLPAGE_OLD_DTD_LOCATION = "org/opencms/xml/page/xmlpage.dtd";
    private static final String XMLPAGE_OLD_DTD_SYSTEM_ID_1 = "http://www.opencms.org/dtd/6.0/xmlpage.dtd";
    private static final String XMLPAGE_OLD_DTD_SYSTEM_ID_2 = "/system/shared/page.dtd";
    private static final String XMLPAGE_XSD_LOCATION = "org/opencms/xml/page/xmlpage.xsd";
    private CmsObject m_cms;

    public CmsXmlEntityResolver(CmsObject cms) {
        CmsXmlEntityResolver.initCaches();
        this.m_cms = cms;
    }

    public static void cacheSystemId(String systemId, byte[] content) {
        CmsXmlEntityResolver.initCaches();
        m_cachePermanent.put(systemId, content);
    }

    public static boolean isCachedSystemId(String systemId) {
        if (m_cachePermanent != null) {
            return m_cachePermanent.containsKey(systemId);
        }
        return false;
    }

    public static boolean isInternalId(String schema) {
        String translatedId = CmsXmlEntityResolver.translateLegacySystemId(schema);
        return translatedId.startsWith(INTERNAL_SCHEME);
    }

    protected static void initialize(CmsObject adminCms, byte[] typeSchemaBytes) {
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(adminCms);
        OpenCms.addCmsEventListener(resolver, new int[]{5, 2, 11, 22, 25});
        CmsXmlEntityResolver.cacheSystemId("opencms://opencms-xmlcontent.xsd", typeSchemaBytes);
    }

    private static void initCaches() {
        if (m_cacheTemporary == null) {
            m_cacheTemporary = CmsMemoryMonitor.createLRUCacheMap(1024);
            m_cachePermanent = new ConcurrentHashMap<String, byte[]>(32);
            m_cacheContentDefinitions = CmsMemoryMonitor.createLRUCacheMap(2048);
        }
        if (OpenCms.getRunLevel() > 1 && OpenCms.getMemoryMonitor() != null && !OpenCms.getMemoryMonitor().isMonitoring(CmsXmlEntityResolver.class.getName() + ".cacheTemporary")) {
            Map cacheTemporary = CmsMemoryMonitor.createLRUCacheMap(128);
            cacheTemporary.putAll(m_cacheTemporary);
            m_cacheTemporary = cacheTemporary;
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cacheTemporary", cacheTemporary);
            ConcurrentHashMap<String, byte[]> cachePermanent = new ConcurrentHashMap<String, byte[]>(32);
            cachePermanent.putAll(m_cachePermanent);
            m_cachePermanent = cachePermanent;
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cachePermanent", cachePermanent);
            Map cacheContentDefinitions = CmsMemoryMonitor.createLRUCacheMap(2048);
            cacheContentDefinitions.putAll(m_cacheContentDefinitions);
            m_cacheContentDefinitions = cacheContentDefinitions;
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cacheContentDefinitions", cacheContentDefinitions);
        }
    }

    private static String translateLegacySystemId(String systemId) {
        String result = systemId;
        for (String[] translation : LEGACY_TRANSLATIONS) {
            if (!systemId.startsWith(translation[0])) continue;
            result = translation[1] + systemId.substring(translation[0].length());
            break;
        }
        if (OpenCms.getRepositoryManager() != null) {
            result = OpenCms.getResourceManager().getXsdTranslator().translateResource(result);
        }
        return result;
    }

    public void cacheContentDefinition(String systemId, CmsXmlContentDefinition contentDefinition) {
        String cacheKey = this.getCacheKeyForCurrentProject(systemId);
        m_cacheContentDefinitions.put(cacheKey, contentDefinition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_CACHED_SYSTEM_ID_1", cacheKey));
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                if (!this.isSchemaDefinitionInPublishList(publishHistoryId)) break;
                m_cacheTemporary.clear();
                m_cacheContentDefinitions.clear();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_FLUSHED_CACHES_0"));
                break;
            }
            case 5: {
                m_cacheTemporary.clear();
                m_cacheContentDefinitions.clear();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_FLUSHED_CACHES_0"));
                break;
            }
            case 11: {
                Object change = event.getData().get("change");
                if (change != null && change.equals(new Integer(0))) {
                    return;
                }
                CmsResource resource = (CmsResource)event.getData().get("resource");
                this.uncacheSystemId(resource.getRootPath());
                break;
            }
            case 22: 
            case 25: {
                List resources = CmsCollectionsGenericWrapper.list(event.getData().get("resources"));
                for (int i = 0; i < resources.size(); ++i) {
                    CmsResource resource = (CmsResource)resources.get(i);
                    this.uncacheSystemId(resource.getRootPath());
                }
                break;
            }
        }
    }

    public CmsXmlContentDefinition getCachedContentDefinition(String systemId) {
        String cacheKey = this.getCacheKeyForCurrentProject(systemId);
        CmsXmlContentDefinition result = m_cacheContentDefinitions.get(cacheKey);
        if (result != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CACHE_LOOKUP_SUCCEEDED_1", cacheKey));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        byte[] content = m_cachePermanent.get(systemId = CmsXmlEntityResolver.translateLegacySystemId(systemId));
        if (content != null) {
            return this.createInputSource(content, systemId);
        }
        if (systemId.equals("http://www.opencms.org/dtd/6.0/xmlpage.xsd")) {
            try (InputStream stream3 = this.getClass().getClassLoader().getResourceAsStream(XMLPAGE_XSD_LOCATION);){
                content = CmsFileUtil.readFully(stream3);
                m_cachePermanent.put(systemId, content);
                InputSource inputSource3 = this.createInputSource(content, systemId);
                return inputSource3;
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLPAGE_XSD_NOT_FOUND_1", XMLPAGE_XSD_LOCATION), t);
                return null;
            }
        }
        if (systemId.equals(XMLPAGE_OLD_DTD_SYSTEM_ID_1) || systemId.endsWith(XMLPAGE_OLD_DTD_SYSTEM_ID_2)) {
            try (InputStream stream2 = this.getClass().getClassLoader().getResourceAsStream(XMLPAGE_OLD_DTD_LOCATION);){
                content = CmsFileUtil.readFully(stream2);
                m_cachePermanent.put(systemId, content);
                InputSource inputSource2 = this.createInputSource(content, systemId);
                return inputSource2;
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLPAGE_DTD_NOT_FOUND_1", XMLPAGE_OLD_DTD_LOCATION), t);
                return null;
            }
        }
        if (this.m_cms != null && systemId.startsWith(OPENCMS_SCHEME)) {
            String cacheSystemId = systemId.substring(OPENCMS_SCHEME.length() - 1);
            String cacheKey = this.getCacheKey(cacheSystemId, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject());
            content = m_cacheTemporary.get(cacheKey);
            if (content != null) {
                return this.createInputSource(content, systemId);
            }
            String storedSiteRoot22 = this.m_cms.getRequestContext().getSiteRoot();
            try {
                this.m_cms.getRequestContext().setSiteRoot("/");
                CmsFile file = this.m_cms.readFile(cacheSystemId, CmsResourceFilter.IGNORE_EXPIRATION);
                content = file.getContents();
                m_cacheTemporary.put(cacheKey, content);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_CACHED_SYS_ID_1", cacheKey));
                }
                InputSource inputSource4 = this.createInputSource(content, systemId);
                return inputSource4;
            }
            catch (CmsException e) {
                throw new IOException(Messages.get().getBundle().key("LOG_ENTITY_RESOLVE_FAILED_1", systemId), e);
            }
            finally {
                this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot22);
            }
        }
        if (systemId.startsWith(INTERNAL_SCHEME)) {
            String location = systemId.substring(INTERNAL_SCHEME.length());
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(location);){
                content = CmsFileUtil.readFully(stream);
                m_cachePermanent.put(systemId, content);
                InputSource inputSource = this.createInputSource(content, systemId);
                return inputSource;
            }
            catch (Throwable t) {
                LOG.error((Object)t.getLocalizedMessage(), t);
                return null;
            }
        }
        if (!systemId.substring(0, systemId.lastIndexOf("/") + 1).equalsIgnoreCase("http://www.opencms.org/dtd/6.0/")) return null;
        String location = null;
        try {
            String dtdFilename = systemId.substring(systemId.lastIndexOf("/") + 1);
            location = "org/opencms/configuration/" + dtdFilename;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(location);
            content = CmsFileUtil.readFully(stream);
            m_cachePermanent.put(systemId, content);
            return this.createInputSource(content, systemId);
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_DTD_NOT_FOUND_1", location), t);
        }
        return null;
    }

    public void uncacheSystemId(String systemId) {
        Object o = m_cacheTemporary.remove(this.getCacheKey(systemId, false));
        if (null != o) {
            m_cacheContentDefinitions.clear();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_UNCACHED_SYS_ID_1", this.getCacheKey(systemId, false)));
            }
        } else {
            o = m_cacheContentDefinitions.remove(this.getCacheKey(systemId, false));
            if (null != o && LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_UNCACHED_CONTENT_DEF_1", this.getCacheKey(systemId, false)));
            }
        }
    }

    InputSource createInputSource(byte[] data, String systemId) {
        InputSource result = new InputSource(new ByteArrayInputStream(data));
        result.setSystemId(systemId);
        return result;
    }

    private String getCacheKey(String systemId, boolean online) {
        if (online) {
            return "online_".concat(systemId);
        }
        return "offline_".concat(systemId);
    }

    private String getCacheKeyForCurrentProject(String systemId) {
        boolean project;
        boolean bl = project = this.m_cms != null ? this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() : false;
        if (systemId.startsWith(OPENCMS_SCHEME)) {
            systemId = systemId.substring(OPENCMS_SCHEME.length() - 1);
        }
        return this.getCacheKey(systemId, project);
    }

    private boolean isSchemaDefinitionInPublishList(CmsUUID publishHistoryId) {
        if (this.m_cms == null) {
            return true;
        }
        try {
            List<CmsPublishedResource> publishedResources = this.m_cms.readPublishedResources(publishHistoryId);
            for (CmsPublishedResource cmsPublishedResource : publishedResources) {
                String resourceRootPath = cmsPublishedResource.getRootPath();
                String resourceRootPathLowerCase = resourceRootPath.toLowerCase();
                if (!resourceRootPathLowerCase.endsWith(".xsd") && !resourceRootPathLowerCase.endsWith(".dtd") && !m_cacheTemporary.containsKey(this.getCacheKey(resourceRootPath, true))) continue;
                return true;
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

