/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsXmlMessages
extends CmsMessages {
    private static final Log LOG = CmsLog.getLog(CmsXmlMessages.class);
    private Locale m_locale;
    private CmsXmlContent m_localizationContent;
    private CmsMessages m_messages;
    private String m_pathPrefix;

    public CmsXmlMessages(CmsMessages messages, String configurationFileName, String pathPrefix, Locale locale) {
        this.m_messages = messages;
        this.initLocalizationContent(configurationFileName);
        this.initPathPrefix(pathPrefix);
        this.m_locale = locale;
    }

    public CmsXmlMessages(String bundleName, String configurationFileName, String pathPrefix, Locale locale) {
        this.m_messages = new CmsMessages(bundleName, locale);
        this.initLocalizationContent(configurationFileName);
        this.initPathPrefix(pathPrefix);
        this.m_locale = locale;
    }

    public CmsMessages getMessages() {
        return this.m_messages;
    }

    @Override
    public String key(String keyName) {
        if (this.hasConfigValue(keyName)) {
            return this.getConfigValue(keyName);
        }
        return this.m_messages.key(keyName);
    }

    @Override
    public String key(String key, Object arg0) {
        if (this.hasConfigValue(key)) {
            return this.getConfigValue(key, new Object[]{arg0});
        }
        return this.m_messages.key(key, arg0);
    }

    @Override
    public String key(String key, Object arg0, Object arg1) {
        if (this.hasConfigValue(key)) {
            return this.getConfigValue(key, new Object[]{arg0, arg1});
        }
        return this.m_messages.key(key, arg0, arg1);
    }

    @Override
    public String key(String key, Object arg0, Object arg1, Object arg2) {
        if (this.hasConfigValue(key)) {
            return this.getConfigValue(key, new Object[]{arg0, arg1, arg2});
        }
        return this.m_messages.key(key, arg0, arg1, arg2);
    }

    @Override
    public String key(String key, Object[] args) {
        if (this.hasConfigValue(key)) {
            return this.getConfigValue(key, args);
        }
        return this.m_messages.key(key, args);
    }

    @Override
    public String keyDefault(String keyName, String defaultValue) {
        if (this.hasConfigValue(keyName)) {
            return this.getConfigValue(keyName);
        }
        return this.m_messages.keyDefault(keyName, defaultValue);
    }

    public void setMessages(CmsMessages messages) {
        this.m_messages = messages;
    }

    protected String getConfigValue(String key) {
        block3: {
            if (this.m_localizationContent != null) {
                try {
                    return this.m_localizationContent.getStringValue(null, this.m_pathPrefix + key, this.m_locale);
                }
                catch (NullPointerException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_NULL_CMSOBJECT_0"));
                }
            }
        }
        return null;
    }

    protected String getConfigValue(String key, Object[] args) {
        String value = this.getConfigValue(key);
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        for (int i = 0; i < args.length; ++i) {
            resolver.addMacro(String.valueOf(i), args[i].toString());
        }
        return resolver.resolveMacros(value);
    }

    protected boolean hasConfigValue(String key) {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getConfigValue(key));
    }

    protected void initLocalizationContent(String configurationFileName) {
        CmsObject cms;
        block6: {
            cms = null;
            try {
                cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)Messages.get().getBundle().key("ERR_INVALID_INIT_USER_1", OpenCms.getDefaultUsers().getUserGuest()));
            }
        }
        if (cms != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(configurationFileName)) {
            Object o = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(cms, configurationFileName);
            if (o != null) {
                this.m_localizationContent = (CmsXmlContent)o;
                return;
            }
            try {
                CmsFile configFile = cms.readFile(configurationFileName);
                this.m_localizationContent = CmsXmlContentFactory.unmarshal(cms, configFile);
                CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(cms, configurationFileName, this.m_localizationContent);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
    }

    protected void initPathPrefix(String pathPrefix) {
        this.m_pathPrefix = CmsStringUtil.isNotEmptyOrWhitespaceOnly(pathPrefix) ? pathPrefix : "";
    }
}

