/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsFormatterBean
implements I_CmsFormatterBean {
    public static final int DEFAULT_CONFIGURATION_RANK = 1000;
    public static final int DEFAULT_SCHEMA_RANK = 10000;
    public static final String PREVIEW_TYPE = "_PREVIEW_";
    public static final int PREVIEW_WIDTH = 640;
    public static final String WILDCARD_TYPE = "*";
    protected Set<String> m_containerTypes;
    protected Set<String> m_cssHeadIncludes = new LinkedHashSet<String>();
    protected String m_description;
    protected String m_displayType;
    protected String m_id;
    protected String m_inlineCss;
    protected String m_inlineJavascript;
    protected boolean m_isAutoEnabled;
    protected boolean m_isDetail;
    protected boolean m_isFromFormatterConfigFile;
    protected boolean m_isPreviewFormatter;
    protected List<String> m_javascriptHeadIncludes = new ArrayList<String>();
    protected String m_jspRootPath;
    protected CmsUUID m_jspStructureId;
    protected String m_location;
    protected boolean m_matchAll;
    protected int m_maxWidth;
    protected List<CmsMetaMapping> m_metaMappings;
    protected int m_minWidth;
    protected boolean m_nestedFormatterSettings;
    protected String m_niceName;
    protected int m_rank;
    protected Collection<String> m_resourceTypeNames;
    protected boolean m_search;
    protected Map<String, CmsXmlContentProperty> m_settings = new LinkedHashMap<String, CmsXmlContentProperty>();
    protected boolean m_strictContainers;
    protected boolean m_useMetaMappingsForNormalElements;
    private boolean m_isAllowsSettingsInEditor;
    private Map<String, String> m_attributes = Collections.emptyMap();

    public CmsFormatterBean(Set<String> containerTypes, String jspRootPath, CmsUUID jspStructureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location, List<String> cssHeadIncludes, String inlineCss, List<String> javascriptHeadIncludes, String inlineJavascript, String niceName, String description, Collection<String> resourceTypeNames, int rank, String id, Map<String, CmsXmlContentProperty> settings, boolean isFromConfigFile, boolean isAutoEnabled, boolean isDetail, String displayType, boolean isAllowsSettingsInEditor, boolean strictContainers, boolean nestedFormatterSettings, List<CmsMetaMapping> metaMappings, Map<String, String> attributes, boolean useMetaMappingsForNormalElements) {
        this.m_jspRootPath = jspRootPath;
        this.m_jspStructureId = jspStructureId;
        this.m_containerTypes = containerTypes;
        this.m_minWidth = minWidth;
        this.m_maxWidth = maxWidth;
        this.m_isPreviewFormatter = preview;
        this.m_search = searchContent;
        this.m_location = location;
        this.m_description = description;
        this.m_id = id;
        this.m_niceName = niceName;
        this.m_resourceTypeNames = resourceTypeNames;
        this.m_rank = rank;
        this.m_inlineCss = inlineCss;
        this.m_inlineJavascript = inlineJavascript;
        this.m_javascriptHeadIncludes.addAll(javascriptHeadIncludes);
        this.m_cssHeadIncludes.addAll(cssHeadIncludes);
        this.m_settings.putAll(settings);
        this.m_isFromFormatterConfigFile = isFromConfigFile;
        this.m_isAutoEnabled = isAutoEnabled;
        this.m_isDetail = isDetail;
        this.m_displayType = displayType;
        this.m_nestedFormatterSettings = nestedFormatterSettings;
        this.m_strictContainers = strictContainers;
        this.m_metaMappings = metaMappings;
        this.m_useMetaMappingsForNormalElements = useMetaMappingsForNormalElements;
        this.m_isAllowsSettingsInEditor = isAllowsSettingsInEditor;
        this.m_attributes = attributes != null ? attributes : Collections.emptyMap();
    }

    public CmsFormatterBean(String containerType, String rootPath, CmsUUID structureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location) {
        this(CmsFormatterBean.isWildcardType(containerType) ? Collections.emptySet() : Collections.singleton(containerType), rootPath, structureId, minWidth, maxWidth, preview, searchContent, location, Collections.emptyList(), "", Collections.emptyList(), "", null, rootPath, Collections.emptySet(), 1000, null, Collections.emptyMap(), false, false, true, null, false, false, false, null, null, false);
    }

    public CmsFormatterBean(String containerType, String jspRootPath, String minWidthStr, String maxWidthStr, String preview, String searchContent, String location) {
        this.m_jspRootPath = jspRootPath;
        this.m_containerTypes = Collections.singleton(containerType);
        if (CmsFormatterBean.isWildcardType(containerType)) {
            this.m_containerTypes = Collections.emptySet();
        }
        this.m_minWidth = -1;
        this.m_maxWidth = Integer.MAX_VALUE;
        if (this.m_containerTypes.isEmpty()) {
            try {
                this.m_minWidth = Integer.parseInt(minWidthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_isPreviewFormatter = Boolean.valueOf(preview);
        this.m_search = CmsStringUtil.isEmptyOrWhitespaceOnly(searchContent) ? true : Boolean.valueOf(searchContent);
        this.m_location = location;
        this.m_rank = 10000;
    }

    CmsFormatterBean(String jspRootPath, CmsUUID jspStructureId, String location, boolean preview) {
        this(Collections.emptySet(), jspRootPath, jspStructureId, -1, Integer.MAX_VALUE, preview, false, location, Collections.emptyList(), "", Collections.emptyList(), "", null, jspRootPath, Collections.emptySet(), 10000, null, Collections.emptyMap(), false, false, true, null, false, false, false, null, Collections.emptyMap(), false);
        this.m_matchAll = true;
    }

    public static boolean isPreviewType(String containerType) {
        return PREVIEW_TYPE.equals(containerType);
    }

    private static boolean isWildcardType(String containerType) {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(containerType) || WILDCARD_TYPE.equals(containerType);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public Set<String> getContainerTypes() {
        return this.m_containerTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.m_containerTypes);
    }

    @Override
    public Set<String> getCssHeadIncludes() {
        return Collections.unmodifiableSet(this.m_cssHeadIncludes);
    }

    @Override
    public String getDescription(Locale locale) {
        if (locale == null) {
            return this.m_description;
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        return resolver.resolveMacros(this.m_description);
    }

    @Override
    public String getDisplayType() {
        return this.m_displayType;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getInlineCss() {
        return this.m_inlineCss;
    }

    @Override
    public String getInlineJavascript() {
        return this.m_inlineJavascript;
    }

    @Override
    public List<String> getJavascriptHeadIncludes() {
        return Collections.unmodifiableList(this.m_javascriptHeadIncludes);
    }

    @Override
    public String getJspRootPath() {
        return this.m_jspRootPath;
    }

    @Override
    public CmsUUID getJspStructureId() {
        return this.m_jspStructureId;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    @Override
    public List<CmsMetaMapping> getMetaMappings() {
        return this.m_metaMappings;
    }

    @Override
    public int getMinWidth() {
        return this.m_minWidth;
    }

    @Override
    public String getNiceName(Locale locale) {
        if (locale == null) {
            return this.m_niceName;
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        return resolver.resolveMacros(this.m_niceName);
    }

    @Override
    public int getRank() {
        return this.m_rank;
    }

    @Override
    public Collection<String> getResourceTypeNames() {
        return this.m_resourceTypeNames;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings() {
        return Collections.unmodifiableMap(this.m_settings);
    }

    public int hashCode() {
        return this.getContainerTypes().hashCode() ^ (this.m_minWidth * 33 ^ this.m_maxWidth);
    }

    @Override
    public boolean hasNestedFormatterSettings() {
        return this.m_nestedFormatterSettings;
    }

    @Override
    public boolean isAllowsSettingsInEditor() {
        return this.m_isAllowsSettingsInEditor;
    }

    @Override
    public boolean isAutoEnabled() {
        return this.m_isAutoEnabled;
    }

    @Override
    public boolean isDetailFormatter() {
        return this.m_isDetail;
    }

    @Override
    public boolean isDisplayFormatter() {
        return this.m_displayType != null;
    }

    @Override
    public boolean isFromFormatterConfigFile() {
        return this.m_isFromFormatterConfigFile;
    }

    @Override
    public boolean isMatchAll() {
        return this.m_matchAll || this.m_containerTypes != null && this.m_containerTypes.contains(WILDCARD_TYPE);
    }

    @Override
    public boolean isPreviewFormatter() {
        return this.m_isPreviewFormatter;
    }

    @Override
    public boolean isSearchContent() {
        return this.m_search;
    }

    public boolean isStrictContainers() {
        return this.m_strictContainers;
    }

    @Override
    public boolean isTypeFormatter() {
        return !this.getContainerTypes().isEmpty();
    }

    @Override
    public void setJspStructureId(CmsUUID jspStructureId) {
        this.m_jspStructureId = jspStructureId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public boolean useMetaMappingsForNormalElements() {
        return this.m_useMetaMappingsForNormalElements;
    }
}

