/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsSchemaFormatterBeanWrapper
implements I_CmsFormatterBean {
    private static final Log LOG = CmsLog.getLog(CmsSchemaFormatterBeanWrapper.class);
    private CmsObject m_cms;
    private I_CmsXmlContentHandler m_contentHandler;
    private CmsResource m_elementResource;
    private I_CmsFormatterBean m_wrappedFormatter;

    public CmsSchemaFormatterBeanWrapper(CmsObject cms, I_CmsFormatterBean wrappedBean, I_CmsXmlContentHandler contentHandler, CmsResource resource) {
        this.m_elementResource = resource;
        this.m_contentHandler = contentHandler;
        this.m_wrappedFormatter = wrappedBean;
        this.m_cms = cms;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public Set<String> getContainerTypes() {
        return this.m_wrappedFormatter.getContainerTypes();
    }

    @Override
    public Set<String> getCssHeadIncludes() {
        try {
            return this.m_contentHandler.getCSSHeadIncludes(this.m_cms, this.m_elementResource);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public String getDescription(Locale locale) {
        return this.m_wrappedFormatter.getDescription(locale);
    }

    @Override
    public String getDisplayType() {
        return null;
    }

    @Override
    public String getId() {
        return this.m_wrappedFormatter.getId();
    }

    @Override
    public String getInlineCss() {
        return "";
    }

    @Override
    public String getInlineJavascript() {
        return "";
    }

    @Override
    public List<String> getJavascriptHeadIncludes() {
        try {
            return new ArrayList<String>(this.m_contentHandler.getJSHeadIncludes(this.m_cms, this.m_elementResource));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getJspRootPath() {
        return this.m_wrappedFormatter.getJspRootPath();
    }

    @Override
    public CmsUUID getJspStructureId() {
        return this.m_wrappedFormatter.getJspStructureId();
    }

    @Override
    public String getLocation() {
        return this.m_wrappedFormatter.getLocation();
    }

    @Override
    public int getMaxWidth() {
        return this.m_wrappedFormatter.getMaxWidth();
    }

    @Override
    public List<CmsMetaMapping> getMetaMappings() {
        return null;
    }

    @Override
    public int getMinWidth() {
        return this.m_wrappedFormatter.getMinWidth();
    }

    @Override
    public String getNiceName(Locale locale) {
        return this.m_wrappedFormatter.getNiceName(locale);
    }

    @Override
    public int getRank() {
        return this.m_wrappedFormatter.getRank();
    }

    @Override
    public Collection<String> getResourceTypeNames() {
        try {
            return Collections.singleton(OpenCms.getResourceManager().getResourceType(this.m_elementResource).getTypeName());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.singleton("xmlcontent");
        }
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings() {
        return this.m_contentHandler.getSettings(this.m_cms, this.m_elementResource);
    }

    @Override
    public boolean hasNestedFormatterSettings() {
        return false;
    }

    @Override
    public boolean isAllowsSettingsInEditor() {
        return false;
    }

    @Override
    public boolean isAutoEnabled() {
        return this.m_wrappedFormatter.isAutoEnabled();
    }

    @Override
    public boolean isDetailFormatter() {
        return true;
    }

    @Override
    public boolean isDisplayFormatter() {
        return false;
    }

    @Override
    public boolean isFromFormatterConfigFile() {
        return this.m_wrappedFormatter.isFromFormatterConfigFile();
    }

    @Override
    public boolean isMatchAll() {
        return this.m_wrappedFormatter.isMatchAll();
    }

    @Override
    public boolean isPreviewFormatter() {
        return this.m_wrappedFormatter.isPreviewFormatter();
    }

    @Override
    public boolean isSearchContent() {
        return this.m_wrappedFormatter.isSearchContent();
    }

    @Override
    public boolean isTypeFormatter() {
        return this.m_wrappedFormatter.isTypeFormatter();
    }

    @Override
    public void setJspStructureId(CmsUUID jspStructureId) {
        this.m_wrappedFormatter.setJspStructureId(jspStructureId);
    }

    @Override
    public boolean useMetaMappingsForNormalElements() {
        return false;
    }
}

