/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentMacroVisitor;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public class CmsXmlContainerPage
extends CmsXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsXmlContainerPage.class);
    private Map<Locale, CmsContainerPageBean> m_cntPages;

    protected CmsXmlContainerPage() {
    }

    protected CmsXmlContainerPage(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        this.m_document = document;
        this.m_contentDefinition = this.getContentDefinition(resolver);
        this.initDocument(cms, this.m_document, encoding, this.m_contentDefinition);
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsFile modelFile = cms.readFile(modelUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsXmlContainerPage model = CmsXmlContainerPageFactory.unmarshal(cms, modelFile);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        this.m_contentDefinition = model.getContentDefinition();
        Document document = (Document)model.m_document.clone();
        this.initDocument(cms, document, model.getEncoding(), this.m_contentDefinition);
        this.visitAllValuesWith(new CmsXmlContentMacroVisitor(cms, macroResolver));
        if (!this.hasLocale(locale)) {
            try {
                this.addLocale(cms, locale);
            }
            catch (CmsXmlException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
        Document document = this.m_contentDefinition.createDocument(cms, this, CmsLocaleManager.MASTER_LOCALE);
        this.initDocument(cms, document, encoding, this.m_contentDefinition);
    }

    public byte[] createContainerPageXml(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        this.writeContainerPage(cms, cntPage);
        this.checkLinkConcistency(cms);
        return this.marshal();
    }

    public CmsContainerPageBean getContainerPage(CmsObject cms) {
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        Locale localeToLoad = null;
        if (this.m_cntPages.containsKey(masterLocale)) {
            localeToLoad = masterLocale;
        } else if (!this.m_cntPages.isEmpty()) {
            localeToLoad = this.m_cntPages.keySet().iterator().next();
        }
        if (localeToLoad == null) {
            return null;
        }
        CmsContainerPageBean result = this.m_cntPages.get(localeToLoad);
        return result;
    }

    @Override
    public boolean isAutoCorrectionEnabled() {
        return true;
    }

    public void save(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        this.save(cms, cntPage, false);
    }

    public void save(CmsObject cms, CmsContainerPageBean cntPage, boolean ifChangedOnly) throws CmsException {
        CmsFile file = this.getFile();
        byte[] data = this.createContainerPageXml(cms, cntPage);
        if (ifChangedOnly && Arrays.equals(file.getContents(), data)) {
            return;
        }
        cms.lockResourceTemporary(file);
        file.setContents(data);
        cms.writeFile(file);
    }

    public void writeContainerPage(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        CmsContainerPageBean savePage = this.cleanupContainersContainers(cms, cntPage);
        savePage = this.removeEmptyContainers(cntPage);
        for (Locale locale : this.getLocales()) {
            this.removeLocale(locale);
        }
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        this.addLocale(cms, masterLocale);
        Element parent = this.getLocaleNode(masterLocale);
        this.saveContainerPage(cms, parent, savePage);
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
    }

    protected void checkLinkConcistency(CmsObject cms) {
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        for (I_CmsXmlContentValue contentValue : this.getValues(masterLocale)) {
            if (!(contentValue instanceof CmsXmlVfsFileValue)) continue;
            CmsLink link = ((CmsXmlVfsFileValue)contentValue).getLink(cms);
            link.checkConsistency(cms);
        }
        this.initDocument();
    }

    protected CmsContainerPageBean cleanupContainersContainers(CmsObject cms, CmsContainerPageBean cntPage) {
        Map<String, CmsContainerBean> currentContainers = cntPage.getContainers();
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (String string : cntPage.getNames()) {
            CmsContainerBean container = currentContainers.get(string);
            if (container.getElements().isEmpty()) continue;
            containers.add(container);
        }
        CmsContainerPageBean currentContainerPage = this.getContainerPage(cms);
        if (currentContainerPage != null) {
            for (String cntName : currentContainerPage.getNames()) {
                Object container;
                if (currentContainers.containsKey(cntName) || ((CmsContainerBean)(container = currentContainerPage.getContainers().get(cntName))).getElements().isEmpty()) continue;
                containers.add((CmsContainerBean)container);
            }
        }
        HashMap<String, CmsContainerElementBean> hashMap = new HashMap<String, CmsContainerElementBean>();
        HashMap<String, String> parentContainers = new HashMap<String, String>();
        for (CmsContainerBean container : containers) {
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(cms);
                    if (CmsModelGroupHelper.isModelGroupResource(element.getResource())) continue;
                    hashMap.put(element.getInstanceId(), element);
                    parentContainers.put(element.getInstanceId(), container.getName());
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        Iterator cntIt = containers.iterator();
        while (cntIt.hasNext()) {
            boolean remove;
            CmsContainerBean container;
            container = (CmsContainerBean)cntIt.next();
            if (currentContainers.containsKey(container.getName()) || !container.isNestedContainer() || container.isRootContainer()) continue;
            boolean bl = remove = !hashMap.containsKey(container.getParentInstanceId()) || container.getElements().isEmpty();
            if (!remove) {
                CmsContainerElementBean element;
                element = (CmsContainerElementBean)hashMap.get(container.getParentInstanceId());
                String settingsKey = CmsFormatterConfig.getSettingsKeyForContainer((String)parentContainers.get(element.getInstanceId()));
                String formatterId = element.getIndividualSettings().get(settingsKey);
                if (CmsUUID.isValidUUID(formatterId)) {
                    I_CmsFormatterBean formatterBean = OpenCms.getADEManager().getCachedFormatters(false).getFormatters().get(new CmsUUID(formatterId));
                    boolean bl2 = remove = formatterBean instanceof CmsFormatterBean && ((CmsFormatterBean)formatterBean).isStrictContainers();
                }
            }
            if (!remove) continue;
            for (CmsContainerElementBean element : container.getElements()) {
                hashMap.remove(element.getInstanceId());
            }
            cntIt.remove();
        }
        return new CmsContainerPageBean(containers);
    }

    protected CmsResource fillResource(CmsObject cms, Element element, CmsUUID resourceId) throws CmsException {
        String xpath = element.getPath();
        int pos = xpath.lastIndexOf("/" + XmlNode.Containers.name() + "/");
        if (pos > 0) {
            xpath = xpath.substring(pos + 1);
        }
        CmsRelationType type = this.getHandler().getRelationType(xpath);
        CmsResource res = cms.readResource(resourceId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsXmlVfsFileValue.fillEntry(element, res.getStructureId(), res.getRootPath(), type);
        return res;
    }

    @Override
    protected void initDocument(CmsObject cms, Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_document = document;
        this.m_contentDefinition = definition;
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        this.m_cntPages = new LinkedHashMap<Locale, CmsContainerPageBean>();
        this.clearBookmarks();
        Iterator<Element> itCntPages = CmsXmlGenericWrapper.elementIterator(this.m_document.getRootElement());
        while (itCntPages.hasNext()) {
            Element cntPage = itCntPages.next();
            try {
                Locale locale = CmsLocaleManager.getLocale(cntPage.attribute("language").getValue());
                this.addLocale(locale);
                ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
                Iterator<Element> itCnts = CmsXmlGenericWrapper.elementIterator(cntPage, XmlNode.Containers.name());
                while (itCnts.hasNext()) {
                    Element isRootContainer;
                    Element container = itCnts.next();
                    int cntIndex = CmsXmlUtils.getXpathIndexInt(container.getUniquePath(cntPage));
                    String cntPath = CmsXmlUtils.createXpathElement(container.getName(), cntIndex);
                    I_CmsXmlSchemaType cntSchemaType = definition.getSchemaType(container.getName());
                    I_CmsXmlContentValue cntValue = cntSchemaType.createValue(this, container, locale);
                    this.addBookmark(cntPath, locale, true, cntValue);
                    CmsXmlContentDefinition cntDef = ((CmsXmlNestedContentDefinition)cntSchemaType).getNestedContentDefinition();
                    Element name = container.element(XmlNode.Name.name());
                    this.addBookmarkForElement(name, locale, container, cntPath, cntDef);
                    Element type = container.element(XmlNode.Type.name());
                    this.addBookmarkForElement(type, locale, container, cntPath, cntDef);
                    Element parentInstance = container.element(XmlNode.ParentInstanceId.name());
                    if (parentInstance != null) {
                        this.addBookmarkForElement(parentInstance, locale, container, cntPath, cntDef);
                    }
                    if ((isRootContainer = container.element(XmlNode.IsRootContainer.name())) != null) {
                        this.addBookmarkForElement(isRootContainer, locale, container, cntPath, cntDef);
                    }
                    ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
                    Iterator<Element> itElems = CmsXmlGenericWrapper.elementIterator(container, XmlNode.Elements.name());
                    while (itElems.hasNext()) {
                        Element element = itElems.next();
                        int elemIndex = CmsXmlUtils.getXpathIndexInt(element.getUniquePath(container));
                        String elemPath = CmsXmlUtils.concatXpath(cntPath, CmsXmlUtils.createXpathElement(element.getName(), elemIndex));
                        I_CmsXmlSchemaType elemSchemaType = cntDef.getSchemaType(element.getName());
                        I_CmsXmlContentValue elemValue = elemSchemaType.createValue(this, element, locale);
                        this.addBookmark(elemPath, locale, true, elemValue);
                        CmsXmlContentDefinition elemDef = ((CmsXmlNestedContentDefinition)elemSchemaType).getNestedContentDefinition();
                        Element uri = element.element(XmlNode.Uri.name());
                        this.addBookmarkForElement(uri, locale, element, elemPath, elemDef);
                        Element uriLink = uri.element("link");
                        CmsUUID elementId = null;
                        if (uriLink != null) {
                            CmsLink link = new CmsLink(uriLink);
                            if (cms != null) {
                                link.checkConsistency(cms);
                            }
                            elementId = link.getStructureId();
                        }
                        Element createNewElement = element.element(XmlNode.CreateNew.name());
                        boolean createNew = createNewElement != null && Boolean.parseBoolean(createNewElement.getStringValue());
                        Element formatter = element.element(XmlNode.Formatter.name());
                        this.addBookmarkForElement(formatter, locale, element, elemPath, elemDef);
                        Element formatterLink = formatter.element("link");
                        CmsUUID formatterId = null;
                        if (formatterLink != null) {
                            CmsLink link = new CmsLink(formatterLink);
                            if (cms != null) {
                                link.checkConsistency(cms);
                            }
                            formatterId = link.getStructureId();
                        }
                        Map<String, String> propertiesMap = CmsXmlContentPropertyHelper.readProperties(this, locale, element, elemPath, elemDef);
                        if (elementId == null) continue;
                        elements.add(new CmsContainerElementBean(elementId, formatterId, propertiesMap, createNew));
                    }
                    CmsContainerBean newContainerBean = new CmsContainerBean(name.getText(), type.getText(), parentInstance != null ? parentInstance.getText() : null, isRootContainer != null && Boolean.valueOf(isRootContainer.getText()) != false, elements);
                    containers.add(newContainerBean);
                }
                this.m_cntPages.put(locale, new CmsContainerPageBean(containers));
            }
            catch (NullPointerException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_INIT_BOOKMARKS_0"), (Throwable)e);
            }
        }
        if (cms != null) {
            this.getHandler().invalidateBrokenLinks(cms, this);
        }
    }

    @Override
    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.initDocument(null, document, encoding, definition);
    }

    protected CmsContainerPageBean removeEmptyContainers(CmsContainerPageBean cntPage) {
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : cntPage.getContainers().values()) {
            if (container.getElements().size() <= 0) continue;
            containers.add(container);
        }
        return new CmsContainerPageBean(containers);
    }

    protected void saveContainerPage(CmsObject cms, Element parent, CmsContainerPageBean cntPage) throws CmsException {
        parent.clearContent();
        ArrayList<String> containerNames = new ArrayList<String>(cntPage.getNames());
        Collections.sort(containerNames);
        for (String containerName : containerNames) {
            CmsContainerBean container = cntPage.getContainers().get(containerName);
            Element cntElement = parent.addElement(XmlNode.Containers.name());
            cntElement.addElement(XmlNode.Name.name()).addCDATA(container.getName());
            cntElement.addElement(XmlNode.Type.name()).addCDATA(container.getType());
            if (container.isNestedContainer()) {
                cntElement.addElement(XmlNode.ParentInstanceId.name()).addCDATA(container.getParentInstanceId());
            }
            if (container.isRootContainer()) {
                cntElement.addElement(XmlNode.IsRootContainer.name()).addText(Boolean.TRUE.toString());
            }
            for (CmsContainerElementBean element : container.getElements()) {
                Element elemElement = cntElement.addElement(XmlNode.Elements.name());
                Element uriElem = elemElement.addElement(XmlNode.Uri.name());
                CmsResource uriRes = this.fillResource(cms, uriElem, element.getId());
                Element formatterElem = elemElement.addElement(XmlNode.Formatter.name());
                this.fillResource(cms, formatterElem, element.getFormatterId());
                if (element.isCreateNew()) {
                    Element createNewElem = elemElement.addElement(XmlNode.CreateNew.name());
                    createNewElem.addText(Boolean.TRUE.toString());
                }
                Map<String, String> properties = element.getIndividualSettings();
                Map<String, CmsXmlContentProperty> propertiesConf = OpenCms.getADEManager().getElementSettings(cms, uriRes);
                CmsXmlContentPropertyHelper.saveProperties(cms, elemElement, properties, propertiesConf);
            }
        }
    }

    @Override
    protected void setFile(CmsFile file) {
        super.setFile(file);
    }

    public static enum XmlNode {
        Attribute,
        Containers,
        CreateNew,
        Elements,
        Formatter,
        IsRootContainer,
        Key,
        Name,
        ParentInstanceId,
        Type,
        Uri,
        Value;

    }
}

