/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsXmlContentMacroVisitor
implements I_CmsXmlContentValueVisitor {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentMacroVisitor.class);
    CmsObject m_cms;
    CmsMacroResolver m_resolver;

    public CmsXmlContentMacroVisitor(CmsObject cms, CmsMacroResolver resolver) {
        this.m_cms = cms;
        this.m_resolver = resolver;
    }

    @Override
    public void visit(I_CmsXmlContentValue value) {
        String original;
        String resolved;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_VISIT_1", value.getPath()));
        }
        if (value.isSimpleType() && !(resolved = this.m_resolver.resolveMacros(original = value.getStringValue(this.m_cms))).equals(original)) {
            value.setStringValue(this.m_cms, resolved);
        }
    }
}

