/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsMacroResolver;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsVfsFileValueBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public final class CmsXmlContentPropertyHelper
implements Cloneable {
    public static final String PAGE_PROPERTY_PREFIX = "page-property:";
    protected static final Object PROPERTY_EMPTY_MARKER = "-";
    private static final String CONF_KEYVALUE_SEPARATOR = ":";
    private static final String CONF_PARAM_SEPARATOR = "\\|";
    private static final Log LOG = CmsLog.getLog(CmsXmlContentPropertyHelper.class);

    private CmsXmlContentPropertyHelper() {
    }

    public static Map<String, String> convertPropertiesToClientFormat(CmsObject cms, Map<String, String> props, Map<String, CmsXmlContentProperty> propConfig) {
        return CmsXmlContentPropertyHelper.convertProperties(cms, props, propConfig, true);
    }

    public static Map<String, String> convertPropertiesToServerFormat(CmsObject cms, Map<String, String> props, Map<String, CmsXmlContentProperty> propConfig) {
        return CmsXmlContentPropertyHelper.convertProperties(cms, props, propConfig, false);
    }

    public static Map<String, CmsXmlContentProperty> copyPropertyConfiguration(Map<String, CmsXmlContentProperty> propConfig) {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (Map.Entry<String, CmsXmlContentProperty> entry : propConfig.entrySet()) {
            String key = entry.getKey();
            CmsXmlContentProperty propDef = entry.getValue();
            result.put(key, propDef.copy());
        }
        return result;
    }

    public static CmsUUID getIdForUri(CmsObject cms, String uri) throws CmsException {
        return cms.readResource(uri).getStructureId();
    }

    public static CmsMacroResolver getMacroResolverForProperties(final CmsObject cms, I_CmsXmlContentHandler contentHandler, CmsXmlContent content, Function<String, String> stringtemplateSource, final CmsResource containerPage) {
        Locale locale = OpenCms.getLocaleManager().getBestAvailableLocaleForXmlContent(cms, content.getFile(), content);
        CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(cms, content, locale){

            @Override
            public String getMacroValue(String macro) {
                if (macro.startsWith(CmsXmlContentPropertyHelper.PAGE_PROPERTY_PREFIX)) {
                    String remainder = macro.substring(CmsXmlContentPropertyHelper.PAGE_PROPERTY_PREFIX.length());
                    int secondColonPos = remainder.indexOf(CmsXmlContentPropertyHelper.CONF_KEYVALUE_SEPARATOR);
                    String defaultValue = "";
                    String propName = null;
                    if (secondColonPos >= 0) {
                        propName = remainder.substring(0, secondColonPos);
                        defaultValue = remainder.substring(secondColonPos + 1);
                    } else {
                        propName = remainder;
                    }
                    if (containerPage != null) {
                        try {
                            CmsProperty prop = cms.readPropertyObject(containerPage, propName, true);
                            String propValue = prop.getValue();
                            if (propValue == null || PROPERTY_EMPTY_MARKER.equals(propValue)) {
                                propValue = defaultValue;
                            }
                            return propValue;
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            return defaultValue;
                        }
                    }
                }
                return super.getMacroValue(macro);
            }
        };
        resolver.setStringTemplateSource(stringtemplateSource);
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsMultiMessages messages = new CmsMultiMessages(wpLocale);
        messages.addMessages(OpenCms.getWorkplaceManager().getMessages(wpLocale));
        messages.addMessages(content.getContentDefinition().getContentHandler().getMessages(wpLocale));
        resolver.setCmsObject(cms);
        resolver.setKeepEmptyMacros(true);
        resolver.setMessages(messages);
        return resolver;
    }

    public static Map<String, CmsXmlContentProperty> getPropertyInfo(CmsObject cms, CmsResource page, CmsResource resource) throws CmsException {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            I_CmsXmlContentHandler contentHandler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource);
            Map<String, CmsXmlContentProperty> propertiesConf = contentHandler.getSettings(cms, resource);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
            CmsMacroResolver resolver = CmsXmlContentPropertyHelper.getMacroResolverForProperties(cms, contentHandler, content, null, page);
            return CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertiesConf, resolver);
        }
        return Collections.emptyMap();
    }

    public static String getPropValueIds(CmsObject cms, String type, String value) {
        if (CmsXmlContentProperty.PropType.isVfsList(type)) {
            return CmsXmlContentPropertyHelper.convertPathsToIds(cms, value);
        }
        return value;
    }

    public static String getPropValuePaths(CmsObject cms, String type, String value) {
        if (CmsXmlContentProperty.PropType.isVfsList(type)) {
            return CmsXmlContentPropertyHelper.convertIdsToPaths(cms, value);
        }
        return value;
    }

    public static String getUriForId(CmsObject cms, CmsUUID id) throws CmsException {
        CmsResource res = cms.readResource(id);
        return cms.getSitePath(res);
    }

    public static JSONObject getWidgetConfigurationAsJSON(String widgetConfiguration) {
        JSONObject result = new JSONObject();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(widgetConfiguration)) {
            return result;
        }
        Map<String, String> confEntries = CmsStringUtil.splitAsMap(widgetConfiguration, CONF_PARAM_SEPARATOR, CONF_KEYVALUE_SEPARATOR);
        for (Map.Entry<String, String> entry : confEntries.entrySet()) {
            try {
                result.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                LOG.error((Object)Messages.get().container("ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_SCHEMA_1", widgetConfiguration), (Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, String> mergeDefaults(CmsObject cms, CmsResource resource, Map<String, String> properties, Locale locale, ServletRequest request) {
        Map<String, CmsXmlContentProperty> propertyConfig = null;
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            I_CmsFormatterBean formatter = null;
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if (!property.getKey().startsWith("formatterSettings#") || !CmsUUID.isValidUUID(property.getValue())) continue;
                formatter = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject()).getFormatters().get(new CmsUUID(property.getValue()));
                break;
            }
            try {
                propertyConfig = formatter != null ? OpenCms.getADEManager().getFormatterSettings(cms, formatter, resource, locale, request) : CmsXmlContentDefinition.getContentHandlerForResource(cms, resource).getSettings(cms, resource);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return CmsXmlContentPropertyHelper.mergeDefaults(cms, propertyConfig, properties);
    }

    public static Map<String, String> mergeDefaults(CmsObject cms, Map<String, CmsXmlContentProperty> propertyConfig, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (propertyConfig != null) {
            for (Map.Entry<String, CmsXmlContentProperty> entry : propertyConfig.entrySet()) {
                CmsXmlContentProperty prop = entry.getValue();
                String value = CmsXmlContentPropertyHelper.getPropValueIds(cms, prop.getType(), prop.getDefault());
                if (value == null) continue;
                result.put(entry.getKey(), value);
            }
        }
        result.putAll(properties);
        return result;
    }

    public static Map<String, String> readProperties(CmsObject cms, I_CmsXmlContentLocation baseLocation) {
        HashMap<String, String> result = new HashMap<String, String>();
        String elementName = CmsXmlContentProperty.XmlNode.Properties.name();
        String nameElementName = CmsXmlContentProperty.XmlNode.Name.name();
        List<I_CmsXmlContentValueLocation> propertyLocations = baseLocation.getSubValues(elementName);
        for (I_CmsXmlContentValueLocation propertyLocation : propertyLocations) {
            I_CmsXmlContentValueLocation nameLocation = propertyLocation.getSubValue(nameElementName);
            String name = nameLocation.asString(cms).trim();
            String value = null;
            I_CmsXmlContentValueLocation valueLocation = propertyLocation.getSubValue(CmsXmlContentProperty.XmlNode.Value.name());
            I_CmsXmlContentValueLocation stringLocation = valueLocation.getSubValue(CmsXmlContentProperty.XmlNode.String.name());
            I_CmsXmlContentValueLocation fileListLocation = valueLocation.getSubValue(CmsXmlContentProperty.XmlNode.FileList.name());
            if (stringLocation != null) {
                value = stringLocation.asString(cms).trim();
            } else if (fileListLocation != null) {
                ArrayList<CmsUUID> idList = new ArrayList<CmsUUID>();
                List<I_CmsXmlContentValueLocation> fileLocations = fileListLocation.getSubValues(CmsXmlContentProperty.XmlNode.Uri.name());
                for (I_CmsXmlContentValueLocation fileLocation : fileLocations) {
                    CmsUUID structureId = fileLocation.asId(cms);
                    idList.add(structureId);
                }
                value = CmsStringUtil.listAsString(idList, ",");
            }
            if (value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    public static Map<String, String> readProperties(CmsXmlContent xmlContent, Locale locale, Element element, String elemPath, CmsXmlContentDefinition elemDef) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator<Element> itProps = CmsXmlGenericWrapper.elementIterator(element, CmsXmlContentProperty.XmlNode.Properties.name());
        while (itProps.hasNext()) {
            Element property = itProps.next();
            int propIndex = CmsXmlUtils.getXpathIndexInt(property.getUniquePath(element));
            String propPath = CmsXmlUtils.concatXpath(elemPath, CmsXmlUtils.createXpathElement(property.getName(), propIndex));
            I_CmsXmlSchemaType propSchemaType = elemDef.getSchemaType(property.getName());
            I_CmsXmlContentValue propValue = propSchemaType.createValue(xmlContent, property, locale);
            xmlContent.addBookmarkForValue(propValue, propPath, locale, true);
            CmsXmlContentDefinition propDef = ((CmsXmlNestedContentDefinition)propSchemaType).getNestedContentDefinition();
            Element propName = property.element(CmsXmlContentProperty.XmlNode.Name.name());
            xmlContent.addBookmarkForElement(propName, locale, property, propPath, propDef);
            Element value = property.element(CmsXmlContentProperty.XmlNode.Value.name());
            if (value == null) continue;
            int valueIndex = CmsXmlUtils.getXpathIndexInt(value.getUniquePath(property));
            String valuePath = CmsXmlUtils.concatXpath(propPath, CmsXmlUtils.createXpathElement(value.getName(), valueIndex));
            I_CmsXmlSchemaType valueSchemaType = propDef.getSchemaType(value.getName());
            I_CmsXmlContentValue valueValue = valueSchemaType.createValue(xmlContent, value, locale);
            xmlContent.addBookmarkForValue(valueValue, valuePath, locale, true);
            CmsXmlContentDefinition valueDef = ((CmsXmlNestedContentDefinition)valueSchemaType).getNestedContentDefinition();
            String val = null;
            Element string = value.element(CmsXmlContentProperty.XmlNode.String.name());
            if (string != null) {
                xmlContent.addBookmarkForElement(string, locale, value, valuePath, valueDef);
                val = string.getTextTrim();
            } else {
                Element valueFileList = value.element(CmsXmlContentProperty.XmlNode.FileList.name());
                if (valueFileList == null) continue;
                int valueFileListIndex = CmsXmlUtils.getXpathIndexInt(valueFileList.getUniquePath(value));
                String valueFileListPath = CmsXmlUtils.concatXpath(valuePath, CmsXmlUtils.createXpathElement(valueFileList.getName(), valueFileListIndex));
                I_CmsXmlSchemaType valueFileListSchemaType = valueDef.getSchemaType(valueFileList.getName());
                I_CmsXmlContentValue valueFileListValue = valueFileListSchemaType.createValue(xmlContent, valueFileList, locale);
                xmlContent.addBookmarkForValue(valueFileListValue, valueFileListPath, locale, true);
                CmsXmlContentDefinition valueFileListDef = ((CmsXmlNestedContentDefinition)valueFileListSchemaType).getNestedContentDefinition();
                ArrayList<CmsUUID> idList = new ArrayList<CmsUUID>();
                Iterator<Element> itFiles = CmsXmlGenericWrapper.elementIterator(valueFileList, CmsXmlContentProperty.XmlNode.Uri.name());
                while (itFiles.hasNext()) {
                    Element valueUri = itFiles.next();
                    xmlContent.addBookmarkForElement(valueUri, locale, valueFileList, valueFileListPath, valueFileListDef);
                    Element valueUriLink = valueUri.element("link");
                    CmsUUID fileId = null;
                    if (valueUriLink == null) continue;
                    fileId = new CmsLink(valueUriLink).getStructureId();
                    idList.add(fileId);
                }
                val = CmsStringUtil.listAsString(idList, ",");
            }
            propertiesMap.put(propName.getTextTrim(), val);
        }
        return propertiesMap;
    }

    public static Map<String, CmsXmlContentProperty> resolveMacrosForPropertyInfo(CmsObject cms, CmsResource page, CmsResource resource, Supplier<CmsXmlContent> contentGetter, Function<String, String> stringtemplateSource, Map<String, CmsXmlContentProperty> propertiesConf) throws CmsException {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            I_CmsXmlContentHandler contentHandler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource);
            CmsMacroResolver resolver = CmsXmlContentPropertyHelper.getMacroResolverForProperties(cms, contentHandler, (CmsXmlContent)contentGetter.get(), stringtemplateSource, page);
            return CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertiesConf, resolver);
        }
        return propertiesConf;
    }

    public static Map<String, CmsXmlContentProperty> resolveMacrosInProperties(Map<String, CmsXmlContentProperty> properties, I_CmsMacroResolver resolver) {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (Map.Entry<String, CmsXmlContentProperty> entry : properties.entrySet()) {
            String key = entry.getKey();
            CmsXmlContentProperty prop = entry.getValue();
            result.put(key, CmsXmlContentPropertyHelper.resolveMacrosInProperty(prop, resolver));
        }
        return result;
    }

    public static CmsXmlContentProperty resolveMacrosInProperty(CmsXmlContentProperty property, I_CmsMacroResolver resolver) {
        String propName = property.getName();
        CmsXmlContentProperty result = new CmsXmlContentProperty(propName, property.getType(), resolver.resolveMacros(property.getWidget()), resolver.resolveMacros(property.getWidgetConfiguration()), property.getRuleRegex(), property.getRuleType(), property.getDefault(), resolver.resolveMacros(property.getNiceName()), resolver.resolveMacros(property.getDescription()), resolver.resolveMacros(property.getError()), property.isPreferFolder() ? "true" : "false");
        return result;
    }

    public static void saveProperties(CmsObject cms, Element parentElement, Map<String, String> properties, Map<String, CmsXmlContentProperty> propertiesConf) {
        for (Object propElement : parentElement.elements(CmsXmlContentProperty.XmlNode.Properties.name())) {
            parentElement.remove((Element)propElement);
        }
        TreeMap<String, String> props = new TreeMap<String, String>(properties);
        for (Map.Entry property : props.entrySet()) {
            String propName = (String)property.getKey();
            String propValue = (String)property.getValue();
            if (propValue == null || propValue.length() == 0) continue;
            Element propElement = parentElement.addElement(CmsXmlContentProperty.XmlNode.Properties.name());
            propElement.addElement(CmsXmlContentProperty.XmlNode.Name.name()).addCDATA(propName);
            Element valueElement = propElement.addElement(CmsXmlContentProperty.XmlNode.Value.name());
            boolean isVfs = false;
            CmsXmlContentProperty propDef = propertiesConf.get(propName);
            if (propDef != null) {
                isVfs = CmsXmlContentProperty.PropType.isVfsList(propDef.getType());
            }
            if (!isVfs) {
                valueElement.addElement(CmsXmlContentProperty.XmlNode.String.name()).addCDATA(propValue);
                continue;
            }
            CmsXmlContentPropertyHelper.addFileListPropertyValue(cms, valueElement, propValue);
        }
    }

    protected static void addFileListPropertyValue(CmsObject cms, Element valueElement, String propValue) {
        Element filelistElem = valueElement.addElement(CmsXmlContentProperty.XmlNode.FileList.name());
        for (String strId : CmsStringUtil.splitAsList(propValue, ",")) {
            try {
                Element fileValueElem = filelistElem.addElement(CmsXmlContentProperty.XmlNode.Uri.name());
                CmsVfsFileValueBean fileValue = CmsXmlContentPropertyHelper.getFileValueForIdOrUri(cms, strId);
                CmsRelationType type = CmsRelationType.XML_WEAK;
                CmsXmlVfsFileValue.fillEntry(fileValueElem, fileValue.getId(), fileValue.getPath(), type);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected static String convertIdsToPaths(CmsObject cms, String value) {
        if (value == null) {
            return null;
        }
        List<String> ids = CmsStringUtil.splitAsList(value, ",");
        ArrayList<String> paths = new ArrayList<String>();
        for (String id : ids) {
            try {
                String path = CmsXmlContentPropertyHelper.getUriForId(cms, new CmsUUID(id));
                paths.add(path);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return CmsStringUtil.listAsString(paths, ",");
    }

    protected static String convertPathsToIds(CmsObject cms, String value) {
        if (value == null) {
            return null;
        }
        List<String> paths = CmsStringUtil.splitAsList(value, ",");
        ArrayList<String> ids = new ArrayList<String>();
        for (String path : paths) {
            try {
                CmsUUID id = CmsXmlContentPropertyHelper.getIdForUri(cms, path);
                ids.add(id.toString());
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return CmsStringUtil.listAsString(ids, ",");
    }

    protected static Map<String, String> convertProperties(CmsObject cms, Map<String, String> props, Map<String, CmsXmlContentProperty> propConfig, boolean toClient) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String propName = entry.getKey();
            String propValue = entry.getValue();
            String type = "string";
            CmsXmlContentProperty configEntry = CmsXmlContentPropertyHelper.getPropertyConfig(propConfig, propName);
            if (configEntry != null) {
                type = configEntry.getType();
            }
            String newValue = CmsXmlContentPropertyHelper.convertStringPropertyValue(cms, propValue, type, toClient);
            result.put(propName, newValue);
        }
        return result;
    }

    protected static String convertStringPropertyValue(CmsObject cms, String propValue, String type, boolean toClient) {
        if (propValue == null) {
            return null;
        }
        if (toClient) {
            return CmsXmlContentPropertyHelper.getPropValuePaths(cms, type, propValue);
        }
        return CmsXmlContentPropertyHelper.getPropValueIds(cms, type, propValue);
    }

    protected static CmsVfsFileValueBean getFileValueForIdOrUri(CmsObject cms, String idOrUri) throws CmsException {
        CmsVfsFileValueBean result;
        if (CmsUUID.isValidUUID(idOrUri)) {
            CmsUUID id = new CmsUUID(idOrUri);
            String uri = CmsXmlContentPropertyHelper.getUriForId(cms, id);
            result = new CmsVfsFileValueBean(cms.getRequestContext().addSiteRoot(uri), id);
        } else {
            String uri = idOrUri;
            CmsUUID id = CmsXmlContentPropertyHelper.getIdForUri(cms, idOrUri);
            result = new CmsVfsFileValueBean(cms.getRequestContext().addSiteRoot(uri), id);
        }
        return result;
    }

    protected static CmsXmlContentProperty getPropertyConfig(Map<String, CmsXmlContentProperty> propertyConfig, String propName) {
        return propertyConfig.get(propName);
    }

    public static enum JsonProperty {
        defaultValue,
        description,
        error,
        niceName,
        ruleRegex,
        ruleType,
        type,
        value,
        widget,
        widgetConf;

    }
}

