/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.templatemapper;

import com.vaadin.ui.Component;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.xml.templatemapper.CmsTemplateMapperDialog;
import org.opencms.xml.templatemapper.CmsTemplateMappingContentRewriter;

public class CmsTemplateMapperAction
extends A_CmsWorkplaceAction {
    private static final Log LOG = CmsLog.getLog(CmsTemplateMapperAction.class);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        try {
            CmsTemplateMapperDialog dialog = new CmsTemplateMapperDialog(context);
            context.start(CmsVaadinUtils.getMessageText("GUI_TEMPLATEMAPPER_DIALOG_TITLE_0", new Object[0]), (Component)dialog, CmsBasicDialog.DialogWidth.wide);
            dialog.setReportThread(new CmsTemplateMappingContentRewriter(context.getCms(), context.getResources().get(0)));
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return "template-mapper";
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        CmsMenuItemVisibilityMode invisible = CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        if (!CmsTemplateMappingContentRewriter.checkConfiguredInModules()) {
            return invisible;
        }
        if (resources.size() != 1) {
            return invisible;
        }
        if (!resources.get(0).isFolder()) {
            return invisible;
        }
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return invisible;
        }
        if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER)) {
            return invisible;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_TEMPLATEMAPPER_MENU_TITLE_0";
    }
}

