/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.templatemapper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;
import org.opencms.ui.Messages;
import org.opencms.util.CmsExpiringValue;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.templatemapper.CmsTemplateMapper;

public class CmsTemplateMappingContentRewriter
extends A_CmsReportThread {
    private static CmsExpiringValue<Boolean> m_moduleCheckCache = new CmsExpiringValue(2000L);
    private static final Log LOG = CmsLog.getLog(CmsTemplateMappingContentRewriter.class);
    private String m_folder;
    private CmsResource m_folderRes;

    protected CmsTemplateMappingContentRewriter(CmsObject cms, CmsResource folder) throws CmsException {
        super(OpenCms.initCmsObject(cms), CmsTemplateMappingContentRewriter.class.getName() + "-" + Thread.currentThread().getId());
        this.m_folder = cms.getSitePath(folder);
        this.m_folderRes = folder;
        this.initHtmlReport(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    public static boolean checkConfiguredInModules() {
        Boolean result = m_moduleCheckCache.get();
        if (result == null) {
            result = CmsTemplateMappingContentRewriter.getConfiguredTemplateMapping() != null;
            m_moduleCheckCache.set(result);
        }
        return result;
    }

    public static String getConfiguredTemplateMapping() {
        CmsModule module;
        String param = null;
        Iterator<CmsModule> iterator = OpenCms.getModuleManager().getAllInstalledModules().iterator();
        while (iterator.hasNext() && (param = (module = iterator.next()).getParameter("template-mapping")) == null) {
        }
        return param;
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        CmsObject cms = this.getCms();
        I_CmsReport report = this.getReport();
        try {
            String file = CmsTemplateMappingContentRewriter.getConfiguredTemplateMapping();
            cms.readResource(file);
            CmsLockUtil.ensureLock(cms, this.m_folderRes);
            CmsTemplateMapper mapper = new CmsTemplateMapper(file);
            mapper.setForSave(true);
            List<CmsResource> pages = this.resourcesForType(this.m_folder, CmsResourceTypeXmlContainerPage.getStaticTypeName());
            int j = 0;
            for (CmsResource page : pages) {
                ++j;
                try {
                    report.println(this.message("RPT_TEMPLATEMAPPER_PROCESSING_PAGE_2", "" + j + "/" + pages.size(), page.getRootPath()));
                    CmsXmlContainerPage pageXml = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(page));
                    CmsContainerPageBean bean = pageXml.getContainerPage(cms);
                    CmsContainerPageBean transformedBean = mapper.transformContainerpageBean(cms, bean, page.getRootPath());
                    pageXml.save(cms, transformedBean);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    this.getReport().println(e);
                }
            }
            List<CmsResource> groups = this.resourcesForType(this.m_folder, "groupcontainer");
            j = 0;
            for (CmsResource group : groups) {
                try {
                    report.println(this.message("RPT_TEMPLATEMAPPER_PROCESSING_GROUP_2", "" + ++j + "/" + groups.size(), group.getRootPath()));
                    CmsXmlGroupContainer groupXml = CmsXmlGroupContainerFactory.unmarshal(cms, cms.readFile(group));
                    CmsGroupContainerBean groupContainer = groupXml.getGroupContainer(cms);
                    CmsGroupContainerBean transformedContainer = mapper.transformGroupContainer(cms, groupContainer, group.getRootPath());
                    groupXml.save(cms, transformedContainer, Locale.ENGLISH);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    this.getReport().println(e);
                }
            }
            CmsLockUtil.tryUnlock(cms, this.m_folderRes);
            report.println(this.message("RPT_TEMPLATEMAPPER_DONE_0", new String[0]));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.getReport().println(e);
        }
    }

    CmsMessageContainer message(String key, String ... args) {
        return Messages.get().container(key, args);
    }

    private List<CmsResource> resourcesForType(String folder, String name) {
        try {
            CmsObject cms = this.getCms();
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(name);
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(type);
            return cms.readResources(folder, filter);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.getReport().println(e);
            return Collections.emptyList();
        }
    }
}

