/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueCdataBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlPlainTextStringValue
extends A_CmsXmlValueCdataBase {
    public static final String TYPE_NAME = "OpenCmsPlainTextString";

    public CmsXmlPlainTextStringValue() {
    }

    public CmsXmlPlainTextStringValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlPlainTextStringValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlPlainTextStringValue(document, element, locale, this);
    }

    @Override
    public String getPlainText(CmsObject cms) {
        try {
            return CmsHtmlExtractor.extractText(this.getStringValue(cms), this.m_document.getEncoding());
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsPlainTextString\"><xsd:restriction base=\"xsd:string\" /></xsd:simpleType>";
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlPlainTextStringValue(name, minOccurs, maxOccurs);
    }
}

