/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsWidgetUtil {
    public static String generatePipeSeparatedConfigString(Map<String, String> options) {
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, String> option : options.entrySet()) {
            result.append('|');
            result.append(option.getKey());
            if (option.getValue() == null) continue;
            result.append('=').append(option.getValue());
        }
        return result.length() > 0 ? result.substring(1) : "";
    }

    public static boolean getBooleanOption(Map<String, String> configOptions, String optionKey) {
        String value;
        return configOptions.containsKey(optionKey) && ((value = configOptions.get(optionKey)) == null || Boolean.valueOf(value) != false);
    }

    public static String getStringOption(Map<String, String> configOptions, String optionKey, String defaultValue) {
        String result = configOptions.get(optionKey);
        return null != result ? result : defaultValue;
    }

    public static Map<String, String> parsePipeSeparatedConfigString(String configString) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != configString) {
            List<String> options = Arrays.asList(configString.split("\\|"));
            for (String option : options) {
                String optValue;
                String optKey;
                int firstEquals = option.indexOf("=");
                if (firstEquals >= 0) {
                    optKey = option.substring(0, firstEquals);
                    optValue = option.substring(firstEquals + 1);
                } else {
                    optKey = option.toLowerCase();
                    optValue = null;
                }
                if (optKey.length() <= 0) continue;
                result.put(optKey, optValue);
            }
        }
        return result;
    }
}

