/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsModelPageConfigWithoutResource;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.CmsTypeOrderingMode;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.galleries.CmsAddContentRestriction;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;

public class CmsADEConfigDataInternal {
    private static final Log LOG = CmsLog.getLog(CmsADEConfigDataInternal.class);
    protected boolean m_createContentsLocally;
    protected boolean m_discardInheritedModelPages;
    protected boolean m_discardInheritedTypes;
    protected CmsConfigurationReader.DiscardPropertiesMode m_discardPropertiesMode;
    protected CmsFormatterChangeSet m_formatterChangeSet = new CmsFormatterChangeSet();
    protected boolean m_includeInSiteSelector;
    protected boolean m_isModuleConfig;
    protected List<CmsUUID> m_masterConfigs;
    protected Boolean m_useFormatterKeys;
    private CmsAddContentRestriction m_addContentRestriction = CmsAddContentRestriction.EMPTY;
    private Set<CmsUUID> m_addedPlugins;
    private Map<String, AttributeValue> m_attributes = Collections.emptyMap();
    private String m_basePath;
    private CmsObject m_cms;
    private Set<CmsUUID> m_dynamicFunctions;
    private boolean m_excludeExternalDetailContents;
    private List<CmsFunctionReference> m_functionReferences = Lists.newArrayList();
    private Set<CmsUUID> m_functionsToRemove;
    private List<CmsDetailPageInfo> m_ownDetailPages = Lists.newArrayList();
    private volatile List<CmsModelPageConfig> m_ownModelPageConfig = null;
    private List<CmsModelPageConfigWithoutResource> m_ownModelPageConfigRaw = new ArrayList<CmsModelPageConfigWithoutResource>();
    private List<CmsPropertyConfig> m_ownPropertyConfigurations = Lists.newArrayList();
    private List<CmsResourceTypeConfig> m_ownResourceTypes = Lists.newArrayList();
    private boolean m_preferDetailPagesForLocalContents;
    private boolean m_removeAllFunctions;
    private boolean m_removeAllPlugins;
    private Set<CmsUUID> m_removedPlugins;
    private boolean m_removeSharedSettingOverrides;
    private CmsResource m_resource;
    private CmsUUID m_sharedSettingOverride;
    private CmsTypeOrderingMode m_typeOrderingMode;

    public CmsADEConfigDataInternal(CmsObject cms, CmsResource resource, boolean isModuleConfig, String basePath, List<CmsUUID> masterConfigs, List<CmsResourceTypeConfig> resourceTypeConfig, boolean discardInheritedTypes, List<CmsPropertyConfig> propertyConfig, CmsConfigurationReader.DiscardPropertiesMode discardPropertiesMode, List<CmsDetailPageInfo> detailPageInfos, List<CmsModelPageConfigWithoutResource> modelPages, List<CmsFunctionReference> functionReferences, boolean discardInheritedModelPages, boolean createContentsLocally, boolean preferDetailPagesForLocalContents, boolean excludeExternalDetailContents, boolean includeInSiteSelector, CmsFormatterChangeSet formatterChangeSet, boolean removeAllFunctions, Set<CmsUUID> functionIds, Set<CmsUUID> functionsToRemove, boolean removeAllPlugins, Set<CmsUUID> addedPlugins, Set<CmsUUID> removedPlugins, Boolean useFormatterKeys, CmsTypeOrderingMode orderingMode, CmsAddContentRestriction restriction, CmsUUID sharedSettingOverride, boolean removeSharedSettingOverrides, Map<String, String> attributes) {
        this.m_cms = cms;
        this.m_resource = resource;
        this.m_basePath = basePath;
        this.m_ownResourceTypes = resourceTypeConfig;
        this.m_ownPropertyConfigurations = propertyConfig;
        this.m_ownModelPageConfigRaw = modelPages;
        this.m_ownDetailPages = detailPageInfos;
        this.m_functionReferences = functionReferences;
        this.m_isModuleConfig = isModuleConfig;
        this.m_masterConfigs = masterConfigs;
        if (this.m_masterConfigs == null) {
            this.m_masterConfigs = Collections.emptyList();
        }
        this.m_discardInheritedTypes = discardInheritedTypes;
        this.m_discardPropertiesMode = discardPropertiesMode;
        this.m_discardInheritedModelPages = discardInheritedModelPages;
        this.m_createContentsLocally = createContentsLocally;
        this.m_preferDetailPagesForLocalContents = preferDetailPagesForLocalContents;
        this.m_formatterChangeSet = formatterChangeSet;
        this.m_formatterChangeSet.setDebugPath(this.m_basePath);
        this.m_dynamicFunctions = functionIds;
        this.m_functionsToRemove = functionsToRemove;
        this.m_removeAllFunctions = removeAllFunctions;
        this.m_excludeExternalDetailContents = excludeExternalDetailContents;
        this.m_includeInSiteSelector = includeInSiteSelector;
        this.m_useFormatterKeys = useFormatterKeys;
        this.m_removeAllPlugins = removeAllPlugins;
        this.m_addedPlugins = Collections.unmodifiableSet(addedPlugins);
        this.m_removedPlugins = Collections.unmodifiableSet(removedPlugins);
        this.m_sharedSettingOverride = sharedSettingOverride;
        this.m_removeSharedSettingOverrides = removeSharedSettingOverrides;
        HashMap<String, AttributeValue> attributeObjects = new HashMap<String, AttributeValue>();
        String attributeOrigin = basePath;
        if (resource != null) {
            attributeOrigin = resource.getRootPath();
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributeObjects.put(entry.getKey(), new AttributeValue(entry.getValue(), attributeOrigin));
        }
        this.m_attributes = Collections.unmodifiableMap(new HashMap(attributeObjects));
        this.m_typeOrderingMode = orderingMode;
        this.m_addContentRestriction = restriction;
    }

    public CmsADEConfigDataInternal(String basePath) {
        this.m_basePath = basePath;
    }

    protected CmsADEConfigDataInternal(CmsResource resource, boolean isModuleConfig, String basePath, List<CmsUUID> masterConfigs, List<CmsResourceTypeConfig> resourceTypeConfig, boolean discardInheritedTypes, List<CmsPropertyConfig> propertyConfig, CmsConfigurationReader.DiscardPropertiesMode discardPropertiesMode, List<CmsDetailPageInfo> detailPageInfos, List<CmsModelPageConfig> modelPages, List<CmsFunctionReference> functionReferences, boolean discardInheritedModelPages, boolean createContentsLocally, boolean preferDetailPagesForLocalContents, boolean excludeExternalDetailContents, boolean includeInSiteSelector, CmsFormatterChangeSet formatterChangeSet, boolean removeAllFunctions, Set<CmsUUID> functionIds) {
        this.m_resource = resource;
        this.m_basePath = basePath;
        this.m_ownResourceTypes = resourceTypeConfig;
        this.m_ownPropertyConfigurations = propertyConfig;
        this.m_ownModelPageConfig = modelPages;
        this.m_ownDetailPages = detailPageInfos;
        this.m_functionReferences = functionReferences;
        this.m_isModuleConfig = isModuleConfig;
        this.m_masterConfigs = masterConfigs;
        if (this.m_masterConfigs == null) {
            this.m_masterConfigs = Collections.emptyList();
        }
        this.m_discardInheritedTypes = discardInheritedTypes;
        this.m_discardPropertiesMode = discardPropertiesMode;
        this.m_discardInheritedModelPages = discardInheritedModelPages;
        this.m_createContentsLocally = createContentsLocally;
        this.m_preferDetailPagesForLocalContents = preferDetailPagesForLocalContents;
        this.m_formatterChangeSet = formatterChangeSet;
        this.m_dynamicFunctions = functionIds;
        this.m_removeAllFunctions = removeAllFunctions;
        this.m_excludeExternalDetailContents = excludeExternalDetailContents;
        this.m_includeInSiteSelector = includeInSiteSelector;
    }

    public static CmsADEConfigDataInternal emptyConfiguration(String basePath) {
        return new CmsADEConfigDataInternal(basePath);
    }

    public CmsAddContentRestriction getAddContentRestriction() {
        return this.m_addContentRestriction;
    }

    public Set<CmsUUID> getAddedPlugins() {
        return this.m_addedPlugins;
    }

    public Map<String, AttributeValue> getAttributes() {
        return this.m_attributes;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public CmsConfigurationReader.DiscardPropertiesMode getDiscardPropertiesMode() {
        return this.m_discardPropertiesMode;
    }

    public Collection<CmsUUID> getDynamicFunctions() {
        if (this.m_dynamicFunctions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_dynamicFunctions);
    }

    public CmsFormatterChangeSet getFormatterChangeSet() {
        return this.m_formatterChangeSet;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return this.m_functionReferences;
    }

    public Collection<CmsUUID> getFunctionsToRemove() {
        return this.m_functionsToRemove;
    }

    public List<CmsUUID> getMasterConfigs() {
        return Collections.unmodifiableList(this.m_masterConfigs);
    }

    public List<CmsDetailPageInfo> getOwnDetailPages() {
        return this.m_ownDetailPages;
    }

    public List<CmsModelPageConfig> getOwnModelPageConfig() {
        if (this.m_ownModelPageConfig == null) {
            ArrayList<CmsModelPageConfig> result = new ArrayList<CmsModelPageConfig>();
            for (CmsModelPageConfigWithoutResource modelPage : this.m_ownModelPageConfigRaw) {
                try {
                    CmsResource resource = this.m_cms.readResource(modelPage.getStructureId());
                    result.add(new CmsModelPageConfig(resource, modelPage.isDefault(), modelPage.isDisabled()));
                }
                catch (Exception e) {
                    LOG.warn((Object)("can't read model page for base path " + this.m_basePath + ": " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            this.m_ownModelPageConfig = result;
            return result;
        }
        return this.m_ownModelPageConfig;
    }

    public List<CmsPropertyConfig> getOwnPropertyConfigurations() {
        return this.m_ownPropertyConfigurations;
    }

    public List<CmsResourceTypeConfig> getOwnResourceTypes() {
        return this.m_ownResourceTypes;
    }

    public Set<CmsUUID> getRemovedPlugins() {
        return this.m_removedPlugins;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public CmsUUID getSharedSettingOverride() {
        return this.m_sharedSettingOverride;
    }

    public CmsTypeOrderingMode getTypeOrderingMode() {
        return this.m_typeOrderingMode;
    }

    public Boolean getUseFormatterKeys() {
        return this.m_useFormatterKeys;
    }

    public boolean isCreateContentsLocally() {
        return this.m_createContentsLocally;
    }

    public boolean isDiscardInheritedModelPages() {
        return this.m_discardInheritedModelPages;
    }

    public boolean isDiscardInheritedProperties() {
        return this.m_discardPropertiesMode != CmsConfigurationReader.DiscardPropertiesMode.keep;
    }

    public boolean isDiscardInheritedTypes() {
        return this.m_discardInheritedTypes;
    }

    public boolean isExcludeExternalDetailContents() {
        return this.m_excludeExternalDetailContents;
    }

    public boolean isIncludeInSiteSelector() {
        return this.m_includeInSiteSelector;
    }

    public boolean isModuleConfig() {
        return this.m_isModuleConfig;
    }

    public boolean isPreferDetailPagesForLocalContents() {
        return this.m_preferDetailPagesForLocalContents;
    }

    public boolean isRemoveAllFunctions() {
        return this.m_removeAllFunctions;
    }

    public boolean isRemoveAllPlugins() {
        return this.m_removeAllPlugins;
    }

    public boolean isRemoveSharedSettingOverrides() {
        return this.m_removeSharedSettingOverrides;
    }

    protected void mergeParent(CmsADEConfigDataInternal parent) {
        List<Object> parentTypes = null;
        parentTypes = parent != null ? parent.m_ownResourceTypes : Collections.emptyList();
        List<Object> parentProperties = null;
        parentProperties = parent != null ? parent.m_ownPropertyConfigurations : Collections.emptyList();
        List<Object> parentModelPages = null;
        parentModelPages = parent != null ? parent.m_ownModelPageConfig : Collections.emptyList();
        List<Object> parentFunctionRefs = null;
        parentFunctionRefs = parent != null ? parent.m_functionReferences : Collections.emptyList();
        this.m_ownResourceTypes = CmsADEConfigData.combineConfigurationElements(parentTypes, this.m_ownResourceTypes, false);
        this.m_ownPropertyConfigurations = CmsADEConfigData.combineConfigurationElements(parentProperties, this.m_ownPropertyConfigurations, false);
        this.m_ownModelPageConfig = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_ownModelPageConfig, false);
        this.m_functionReferences = CmsADEConfigData.combineConfigurationElements(parentFunctionRefs, this.m_functionReferences, false);
    }

    protected void processModuleOrdering() {
        Collections.sort(this.m_ownResourceTypes, new Comparator<CmsResourceTypeConfig>(){

            @Override
            public int compare(CmsResourceTypeConfig a, CmsResourceTypeConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getTypeName()), (Comparable)((Object)b.getTypeName())).result();
            }
        });
        Collections.sort(this.m_ownPropertyConfigurations, new Comparator<CmsPropertyConfig>(){

            @Override
            public int compare(CmsPropertyConfig a, CmsPropertyConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
        Collections.sort(this.m_functionReferences, new Comparator<CmsFunctionReference>(){

            @Override
            public int compare(CmsFunctionReference a, CmsFunctionReference b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
    }

    public static class AttributeValue {
        private String m_origin;
        private String m_value;

        public AttributeValue(String value, String origin) {
            this.m_value = value;
            this.m_origin = origin;
        }

        public String getOrigin() {
            return this.m_origin;
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            return "[" + this.m_value + " (from: " + this.m_origin + ")]";
        }
    }
}

