/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsContentFolderDescriptor;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfigWithoutResource;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.CmsTypeOrderingMode;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.galleries.CmsAddContentRestriction;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;

public class CmsConfigurationReader {
    public static final Locale DEFAULT_LOCALE = CmsLocaleManager.getLocale("en");
    public static final String N_ADD_CONTENT_RESTRICTION = "AddContentRestriction";
    public static final String N_ADD_FORMATTER = "AddFormatter";
    public static final String N_ADD_FORMATTERS = "AddFormatters";
    public static final String N_ADD_PLUGIN = "AddPlugin";
    public static final String N_ADD_PLUGINS = "AddPlugins";
    public static final String N_ATTRIBUTE = "Attribute";
    public static final String N_CREATE_CONTENTS_LOCALLY = "CreateContentsLocally";
    public static final String N_DEFAULT = "Default";
    public static final String N_DESCRIPTION = "Description";
    public static final String N_DETAIL_PAGE = "DetailPage";
    public static final String N_DETAIL_PAGES_DISABLED = "DetailPagesDisabled";
    public static final String N_SHARED_SETTING_OVERRIDE = "SharedSettingOverride";
    public static final String N_REMOVE_ALL_SHARED_SETTING_OVERRIDES = "RemoveAllSharedSettingOverrides";
    public static final String N_DISABLED = "Disabled";
    public static final String N_DISCARD_MODEL_PAGES = "DiscardModelPages";
    public static final String N_DISCARD_PROPERTIES = "DiscardProperties";
    public static final String N_DISCARD_TYPES = "DiscardTypes";
    public static final String N_DISPLAY_NAME = "DisplayName";
    public static final String N_ELEMENT_VIEW = "ElementView";
    public static final String N_ERROR = "Error";
    public static final String N_EXCLUDE_EXTERNAL_DETAIL_CONTENTS = "ExcludeExternalDetailContents";
    public static final String N_FOLDER = "Folder";
    public static final String N_FORMATTER = "Formatter";
    public static final String N_FUNCTION = "Function";
    public static final String N_FUNCTION_DEFAULT_PAGE = "FunctionDefaultPage";
    public static final String N_FUNCTION_REF = "FunctionRef";
    public static final String N_INCLUDE_IN_SITE_SELECTOR = "IncludeInSiteSelector";
    public static final String N_IS_DEFAULT = "IsDefault";
    public static final String N_IS_PREVIEW = "IsPreview";
    public static final String N_JSP = "Jsp";
    public static final String N_KEY = "Key";
    public static final String N_LOCALIZATION = "Localization";
    public static final String N_MASTER_CONFIG = "MasterConfig";
    public static final String N_MAX_WIDTH = "MaxWidth";
    public static final String N_MIN_WIDTH = "MinWidth";
    public static final String N_MODEL_PAGE = "ModelPage";
    public static final String N_NAME = "Name";
    public static final String N_NAME_PATTERN = "NamePattern";
    public static final String N_ORDER = "Order";
    public static final String N_PAGE = "Page";
    public static final String N_PATH = "Path";
    public static final String N_PLUGIN = "Plugin";
    public static final String N_PREFER_DETAIL_PAGES_FOR_LOCAL_CONTENTS = "PreferDetailPagesForLocalContents";
    public static final String N_PREFER_FOLDER = "PreferFolder";
    public static final String N_PROPERTY = "Property";
    public static final String N_PROPERTY_NAME = "PropertyName";
    public static final String N_REMOVE_ALL_FORMATTERS = "RemoveAllFormatters";
    public static final String N_REMOVE_ALL_FUNCTIONS = "RemoveAllFunctions";
    public static final String N_REMOVE_ALL_PLUGINS = "RemoveAllPlugins";
    public static final String N_REMOVE_FORMATTER = "RemoveFormatter";
    public static final String N_REMOVE_FORMATTERS = "RemoveFormatters";
    public static final String N_REMOVE_FUNCTIONS = "RemoveFunctions";
    public static final String N_REMOVE_PLUGIN = "RemovePlugin";
    public static final String N_REMOVE_PLUGINS = "RemovePlugins";
    public static final String N_RESOURCE_TYPE = "ResourceType";
    public static final String N_RULE_REGEX = "RuleRegex";
    public static final String N_RULE_TYPE = "RuleType";
    public static final String N_TYPE = "Type";
    public static final String N_TYPE_NAME = "TypeName";
    public static final String N_TYPE_ORDERING_MODE = "TypeOrderingMode";
    public static final String N_USE_FORMATTER_KEYS = "UseFormatterKeys";
    public static final String N_VALUE = "Value";
    public static final String N_VISIBILITY = "Visibility";
    public static final String N_WIDGET = "Widget";
    public static final String N_WIDGET_CONFIG = "WidgetConfig";
    public static final String VIEW_SCHEME = "view://";
    private static final Log LOG = CmsLog.getLog(CmsConfigurationReader.class);
    private static final String N_COPY_IN_MODELS = "CopyInModels";
    private static final String N_ELEMENT_DELETE_MODE = "ElementDeleteMode";
    private static final String N_INCLUDE_NAME = "IncludeName";
    private static final String N_PAGE_RELATIVE = "PageRelative";
    private static final String N_SHOW_IN_DEFAULT_VIEW = "ShowInDefaultView";
    private CmsObject m_cms;
    private List<CmsDetailPageInfo> m_detailPageConfigs = new ArrayList<CmsDetailPageInfo>();
    private List<CmsFunctionReference> m_functionReferences = new ArrayList<CmsFunctionReference>();
    private List<CmsModelPageConfigWithoutResource> m_modelPageConfigs = new ArrayList<CmsModelPageConfigWithoutResource>();
    private List<CmsPropertyConfig> m_propertyConfigs = new ArrayList<CmsPropertyConfig>();
    private List<CmsResourceTypeConfig> m_resourceTypeConfigs = new ArrayList<CmsResourceTypeConfig>();

    public CmsConfigurationReader(CmsObject cms) {
        this.m_cms = cms;
    }

    public static String getString(CmsObject cms, I_CmsXmlContentValueLocation location) {
        if (location == null) {
            return null;
        }
        return location.asString(cms);
    }

    public static CmsPropertyConfig parseProperty(CmsObject cms, I_CmsXmlContentLocation field) {
        CmsXmlContentProperty.Visibility visibility;
        String name = CmsConfigurationReader.getString(cms, field.getSubValue(N_PROPERTY_NAME));
        String includeName = CmsConfigurationReader.getString(cms, field.getSubValue(N_INCLUDE_NAME));
        String widget = CmsConfigurationReader.getString(cms, field.getSubValue(N_WIDGET));
        String widgetConfig = CmsConfigurationReader.getString(cms, field.getSubValue(N_WIDGET_CONFIG));
        String ruleRegex = CmsConfigurationReader.getString(cms, field.getSubValue(N_RULE_REGEX));
        String ruleType = CmsConfigurationReader.getString(cms, field.getSubValue(N_RULE_TYPE));
        String default1 = CmsConfigurationReader.getString(cms, field.getSubValue(N_DEFAULT));
        String error = CmsConfigurationReader.getString(cms, field.getSubValue(N_ERROR));
        String niceName = CmsConfigurationReader.getString(cms, field.getSubValue(N_DISPLAY_NAME));
        String description = CmsConfigurationReader.getString(cms, field.getSubValue(N_DESCRIPTION));
        String preferFolder = CmsConfigurationReader.getString(cms, field.getSubValue(N_PREFER_FOLDER));
        String disabledStr = CmsConfigurationReader.getString(cms, field.getSubValue(N_DISABLED));
        boolean disabled = disabledStr != null && Boolean.parseBoolean(disabledStr);
        String orderStr = CmsConfigurationReader.getString(cms, field.getSubValue(N_ORDER));
        int order = 10000;
        try {
            order = Integer.parseInt(orderStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String visibilityStr = CmsConfigurationReader.getString(cms, field.getSubValue(N_VISIBILITY));
        try {
            if ("both".equals(visibilityStr)) {
                visibilityStr = CmsXmlContentProperty.Visibility.elementAndParentIndividual.name();
            } else if ("parent".equals(visibilityStr)) {
                visibilityStr = CmsXmlContentProperty.Visibility.parentShared.name();
            }
            visibility = CmsXmlContentProperty.Visibility.valueOf(visibilityStr);
        }
        catch (Exception e) {
            visibility = null;
        }
        CmsXmlContentProperty prop = new CmsXmlContentProperty(name, "string", visibility, widget, widgetConfig, ruleRegex, ruleType, default1, niceName, description, error, preferFolder).withIncludeName(includeName);
        CmsPropertyConfig propConfig = new CmsPropertyConfig(prop, disabled, order);
        return propConfig;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return new ArrayList<CmsFunctionReference>(this.m_functionReferences);
    }

    public List<CmsModelPageConfigWithoutResource> getModelPageConfigs() {
        return this.m_modelPageConfigs;
    }

    public Set<String> parseAddFormatters(I_CmsXmlContentLocation node) {
        HashSet<String> addFormatters = new HashSet<String>();
        for (I_CmsXmlContentValueLocation addLoc : node.getSubValues("AddFormatters/AddFormatter")) {
            CmsUUID structureId;
            CmsXmlVfsFileValue value = (CmsXmlVfsFileValue)addLoc.getValue();
            CmsLink link = value.getLink(this.m_cms);
            if (link == null || (structureId = link.getStructureId()) == null) continue;
            addFormatters.add(structureId.toString());
        }
        return addFormatters;
    }

    public CmsADEConfigDataInternal parseConfiguration(String basePath, CmsXmlContent content) throws CmsException {
        this.m_detailPageConfigs = Lists.newArrayList();
        this.m_functionReferences = Lists.newArrayList();
        this.m_modelPageConfigs = Lists.newArrayList();
        this.m_propertyConfigs = Lists.newArrayList();
        this.m_resourceTypeConfigs = Lists.newArrayList();
        if (!content.hasLocale(DEFAULT_LOCALE)) {
            return CmsADEConfigDataInternal.emptyConfiguration(basePath);
        }
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, DEFAULT_LOCALE);
        for (I_CmsXmlContentValueLocation i_CmsXmlContentValueLocation : root.getSubValues(N_RESOURCE_TYPE)) {
            try {
                this.parseResourceTypeConfig(basePath, i_CmsXmlContentValueLocation);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentValueLocation i_CmsXmlContentValueLocation : root.getSubValues(N_MODEL_PAGE)) {
            try {
                this.parseModelPage(i_CmsXmlContentValueLocation);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentLocation i_CmsXmlContentLocation : root.getSubValues(N_DETAIL_PAGE)) {
            try {
                this.parseDetailPage(i_CmsXmlContentLocation);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (I_CmsXmlContentLocation i_CmsXmlContentLocation : root.getSubValues(N_FUNCTION_REF)) {
            this.parseFunctionReference(i_CmsXmlContentLocation);
        }
        CmsUUID sharedSettingOverride = null;
        for (I_CmsXmlContentValueLocation node : root.getSubValues(N_SHARED_SETTING_OVERRIDE)) {
            sharedSettingOverride = ((CmsXmlVfsFileValue)node.getValue()).getLink(this.m_cms).getStructureId();
        }
        boolean bl = this.getBoolean(root, N_REMOVE_ALL_SHARED_SETTING_OVERRIDES);
        boolean removeFunctions = false;
        removeFunctions = this.getBoolean(root, N_REMOVE_ALL_FUNCTIONS);
        LinkedHashSet<CmsUUID> functions = new LinkedHashSet<CmsUUID>();
        for (I_CmsXmlContentValueLocation i_CmsXmlContentValueLocation : root.getSubValues(N_FUNCTION)) {
            CmsUUID structureId;
            CmsXmlVfsFileValue value = (CmsXmlVfsFileValue)i_CmsXmlContentValueLocation.getValue();
            CmsLink link = value.getLink(this.m_cms);
            if (link == null || (structureId = link.getStructureId()) == null) continue;
            functions.add(link.getStructureId());
        }
        LinkedHashSet<CmsUUID> functionsToRemove = new LinkedHashSet<CmsUUID>();
        for (I_CmsXmlContentValueLocation parent : root.getSubValues(N_REMOVE_FUNCTIONS)) {
            for (I_CmsXmlContentValueLocation node : parent.getSubValues(N_FUNCTION)) {
                CmsUUID structureId;
                CmsXmlVfsFileValue value = (CmsXmlVfsFileValue)node.getValue();
                CmsLink link = value.getLink(this.m_cms);
                if (link == null || (structureId = link.getStructureId()) == null) continue;
                functionsToRemove.add(link.getStructureId());
            }
        }
        boolean bl2 = this.getBoolean(root, N_REMOVE_ALL_PLUGINS);
        Set<CmsUUID> pluginsToRemove = this.readInternalLinkListTargetIds(root, N_REMOVE_PLUGINS, N_PLUGIN);
        Set<CmsUUID> pluginsToAdd = this.readInternalLinkListTargetIds(root, N_ADD_PLUGINS, N_PLUGIN);
        boolean removeAllFormatters = this.getBoolean(root, N_REMOVE_ALL_FORMATTERS);
        CmsFormatterChangeSet formatterChangeSet = this.parseFormatterChangeSet(basePath, root, removeAllFormatters, removeFunctions, functions, functionsToRemove);
        boolean discardInheritedTypes = this.getBoolean(root, N_DISCARD_TYPES);
        I_CmsXmlContentValueLocation discardPropertiesLoc = root.getSubValue(N_DISCARD_PROPERTIES);
        DiscardPropertiesMode discardPropertiesMode = DiscardPropertiesMode.keep;
        if (discardPropertiesLoc != null) {
            String discardPropertiesStr = discardPropertiesLoc.getValue().getStringValue(this.m_cms);
            for (DiscardPropertiesMode discardMode : DiscardPropertiesMode.values()) {
                if (!discardMode.getStringValue().contentEquals(discardPropertiesStr)) continue;
                discardPropertiesMode = discardMode;
            }
        }
        for (I_CmsXmlContentLocation i_CmsXmlContentLocation : root.getSubValues(N_PROPERTY)) {
            this.parseProperty(i_CmsXmlContentLocation, discardPropertiesMode);
        }
        boolean discardInheritedModelPages = this.getBoolean(root, N_DISCARD_MODEL_PAGES);
        boolean bl3 = this.getBoolean(root, N_CREATE_CONTENTS_LOCALLY);
        boolean preferDetailPagesForLocalContents = this.getBoolean(root, N_PREFER_DETAIL_PAGES_FOR_LOCAL_CONTENTS);
        boolean exludeExternalDetailContents = this.getBoolean(root, N_EXCLUDE_EXTERNAL_DETAIL_CONTENTS);
        boolean includeInSiteSelector = this.getBoolean(root, N_INCLUDE_IN_SITE_SELECTOR);
        I_CmsXmlContentValueLocation typeOrderingLoc = root.getSubValue(N_TYPE_ORDERING_MODE);
        CmsTypeOrderingMode typeOrderingMode = null;
        if (typeOrderingLoc != null) {
            boolean byDisplayOrder = Boolean.parseBoolean(typeOrderingLoc.getValue().getStringValue(this.m_cms));
            typeOrderingMode = byDisplayOrder ? CmsTypeOrderingMode.byDisplayOrder : CmsTypeOrderingMode.latestOnTop;
        }
        I_CmsXmlContentValueLocation useFormatterKeysLoc = root.getSubValue(N_USE_FORMATTER_KEYS);
        Boolean useFormatterKeys = null;
        if (useFormatterKeysLoc != null) {
            useFormatterKeys = Boolean.valueOf(useFormatterKeysLoc.getValue().getStringValue(this.m_cms));
        }
        boolean isModuleConfig = OpenCms.getResourceManager().getResourceType(content.getFile().getTypeId()).getTypeName().equals("module_config");
        ArrayList<CmsUUID> masterConfigIds = new ArrayList<CmsUUID>();
        for (I_CmsXmlContentValueLocation i_CmsXmlContentValueLocation : root.getSubValues(N_MASTER_CONFIG)) {
            CmsUUID id = i_CmsXmlContentValueLocation.asId(this.m_cms);
            if (id == null) continue;
            masterConfigIds.add(id);
        }
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (I_CmsXmlContentValueLocation mappingLoc : root.getSubValues(N_ATTRIBUTE)) {
            String key = this.getString(mappingLoc.getSubValue(N_KEY)).trim();
            String value = this.getString(mappingLoc.getSubValue(N_VALUE)).trim();
            attributes.put(key, value);
        }
        CmsAddContentRestriction cmsAddContentRestriction = CmsAddContentRestriction.read(this.m_cms, root, N_ADD_CONTENT_RESTRICTION);
        CmsADEConfigDataInternal result = new CmsADEConfigDataInternal(this.m_cms, content.getFile(), isModuleConfig, basePath, masterConfigIds, this.m_resourceTypeConfigs, discardInheritedTypes, this.m_propertyConfigs, discardPropertiesMode, this.m_detailPageConfigs, this.m_modelPageConfigs, this.m_functionReferences, discardInheritedModelPages, bl3, preferDetailPagesForLocalContents, exludeExternalDetailContents, includeInSiteSelector, formatterChangeSet, removeFunctions, functions, functionsToRemove, bl2, pluginsToAdd, pluginsToRemove, useFormatterKeys, typeOrderingMode, cmsAddContentRestriction, sharedSettingOverride, bl, attributes);
        return result;
    }

    public CmsContentFolderDescriptor parseFolderOrName(String basePath, I_CmsXmlContentLocation location) throws CmsException {
        if (location == null) {
            return null;
        }
        I_CmsXmlContentValueLocation nameLoc = location.getSubValue(N_NAME);
        I_CmsXmlContentValueLocation pathLoc = location.getSubValue(N_PATH);
        I_CmsXmlContentValueLocation pageRelativeLoc = location.getSubValue(N_PAGE_RELATIVE);
        if (nameLoc != null) {
            String name = nameLoc.asString(this.m_cms);
            return new CmsContentFolderDescriptor(basePath == null ? null : CmsStringUtil.joinPaths(basePath, ".content"), name);
        }
        if (pathLoc != null) {
            String path = pathLoc.asString(this.m_cms);
            CmsResource folder = this.m_cms.readResource(path);
            return new CmsContentFolderDescriptor(folder);
        }
        if (pageRelativeLoc != null) {
            return CmsContentFolderDescriptor.createPageRelativeFolderDescriptor();
        }
        return null;
    }

    public CmsFormatterBean parseFormatter(String typeName, I_CmsXmlContentLocation node) {
        String type = this.getString(node.getSubValue(N_TYPE));
        String minWidth = this.getString(node.getSubValue(N_MIN_WIDTH));
        String maxWidth = this.getString(node.getSubValue(N_MAX_WIDTH));
        boolean preview = false;
        I_CmsXmlContentValueLocation previewLoc = node.getSubValue(N_IS_PREVIEW);
        preview = previewLoc != null && Boolean.parseBoolean(previewLoc.asString(this.m_cms));
        String jsp = this.m_cms.getRequestContext().addSiteRoot(this.getString(node.getSubValue(N_JSP)));
        boolean searchContent = true;
        CmsFormatterBean formatterBean = new CmsFormatterBean(type, jsp, minWidth, maxWidth, "" + preview, "" + searchContent, null);
        return formatterBean;
    }

    public void parseModelPage(I_CmsXmlContentLocation node) {
        CmsXmlVfsFileValue pageValue = (CmsXmlVfsFileValue)node.getSubValue(N_PAGE).getValue();
        CmsLink link = pageValue.getUncheckedLink();
        if (link == null || link.getStructureId() == null) {
            return;
        }
        I_CmsXmlContentValueLocation disabledLoc = node.getSubValue(N_DISABLED);
        boolean disabled = disabledLoc != null && Boolean.parseBoolean(disabledLoc.asString(this.m_cms));
        I_CmsXmlContentValueLocation defaultLoc = node.getSubValue(N_IS_DEFAULT);
        boolean isDefault = defaultLoc != null && Boolean.parseBoolean(defaultLoc.asString(this.m_cms));
        CmsModelPageConfigWithoutResource modelPage = new CmsModelPageConfigWithoutResource(link.getStructureId(), isDefault, disabled);
        this.m_modelPageConfigs.add(modelPage);
    }

    public Set<String> parseRemoveFormatters(I_CmsXmlContentLocation node) {
        HashSet<String> removeFormatters = new HashSet<String>();
        for (I_CmsXmlContentValueLocation removeLoc : node.getSubValues("RemoveFormatters/RemoveFormatter")) {
            CmsUUID structureId;
            CmsXmlVfsFileValue value = (CmsXmlVfsFileValue)removeLoc.getValue();
            CmsLink link = value.getLink(this.m_cms);
            if (link == null || (structureId = link.getStructureId()) == null) continue;
            removeFormatters.add(structureId.toString());
        }
        return removeFormatters;
    }

    public void parseResourceTypeConfig(String basePath, I_CmsXmlContentLocation node) throws CmsException {
        CmsXmlVfsFileValue locationValue;
        CmsLink link;
        String disabledStr;
        I_CmsXmlContentValueLocation typeNameLoc = node.getSubValue(N_TYPE_NAME);
        String typeName = typeNameLoc.asString(this.m_cms);
        CmsContentFolderDescriptor folderOrName = this.parseFolderOrName(basePath, node.getSubValue(N_FOLDER));
        I_CmsXmlContentValueLocation disabledLoc = node.getSubValue(N_DISABLED);
        boolean disabled = false;
        boolean addDisabled = false;
        boolean createDisabled = false;
        String string = disabledStr = disabledLoc == null ? null : disabledLoc.asString(this.m_cms);
        if (disabledStr != null && "add".equalsIgnoreCase(disabledStr.trim())) {
            addDisabled = true;
        } else if (disabledStr != null && "create".equalsIgnoreCase(disabledStr.trim())) {
            createDisabled = true;
        } else {
            disabled = Boolean.parseBoolean(disabledStr);
        }
        I_CmsXmlContentValueLocation namePatternLoc = node.getSubValue(N_NAME_PATTERN);
        String namePattern = null;
        if (namePatternLoc != null) {
            namePattern = namePatternLoc.asString(this.m_cms);
        }
        boolean detailPagesDisabled = false;
        I_CmsXmlContentValueLocation detailDisabledLoc = node.getSubValue(N_DETAIL_PAGES_DISABLED);
        if (detailDisabledLoc != null) {
            String detailPagesDisabledStr = detailDisabledLoc.asString(this.m_cms);
            detailPagesDisabled = Boolean.parseBoolean(detailPagesDisabledStr);
        }
        Integer order = null;
        I_CmsXmlContentValueLocation orderLoc = node.getSubValue(N_ORDER);
        if (orderLoc != null) {
            try {
                String orderStr = orderLoc.asString(this.m_cms);
                order = Integer.valueOf(orderStr);
            }
            catch (NumberFormatException orderStr) {
                // empty catch block
            }
        }
        I_CmsXmlContentValueLocation elementViewLoc = node.getSubValue(N_ELEMENT_VIEW);
        CmsUUID elementView = null;
        if (elementViewLoc != null) {
            try {
                CmsXmlVarLinkValue elementViewValue = (CmsXmlVarLinkValue)elementViewLoc.getValue();
                String stringValue = elementViewValue.getStringValue(this.m_cms);
                elementView = "".equals(stringValue) ? CmsUUID.getNullUUID() : (stringValue.startsWith(VIEW_SCHEME) ? new CmsUUID(stringValue.substring(VIEW_SCHEME.length())) : elementViewValue.getLink(this.m_cms).getStructureId());
            }
            catch (Exception elementViewValue) {
                // empty catch block
            }
        }
        I_CmsXmlContentValueLocation locationLoc = node.getSubValue(N_LOCALIZATION);
        String localization = null;
        if (locationLoc != null && null != (link = (locationValue = (CmsXmlVfsFileValue)locationLoc.getValue()).getLink(this.m_cms))) {
            String localeSuffix;
            int lastSlashIndex;
            String stringValue = link.getSitePath(this.m_cms);
            String fileName = stringValue.substring((lastSlashIndex = stringValue.lastIndexOf("/")) + 1);
            if (CmsFileUtil.getExtension(fileName).equals(".properties")) {
                fileName = fileName.substring(0, fileName.length() - ".properties".length());
            }
            if ((localeSuffix = CmsStringUtil.getLocaleSuffixForName(fileName)) != null && fileName.endsWith(localeSuffix)) {
                fileName = fileName.substring(0, fileName.length() - localeSuffix.length() - 1);
            }
            localization = fileName;
        }
        I_CmsXmlContentValueLocation showDefaultViewLoc = node.getSubValue(N_SHOW_IN_DEFAULT_VIEW);
        Boolean showInDefaultView = null;
        if (showDefaultViewLoc != null) {
            showInDefaultView = Boolean.parseBoolean(showDefaultViewLoc.getValue().getStringValue(this.m_cms));
        }
        I_CmsXmlContentValueLocation copyInModelsLoc = node.getSubValue(N_COPY_IN_MODELS);
        Boolean copyInModels = null;
        if (copyInModelsLoc != null) {
            copyInModels = Boolean.parseBoolean(copyInModelsLoc.getValue().getStringValue(this.m_cms));
        }
        I_CmsXmlContentValueLocation elementDeleteModeLoc = node.getSubValue(N_ELEMENT_DELETE_MODE);
        CmsCntPageData.ElementDeleteMode elementDeleteMode = null;
        if (elementDeleteModeLoc != null) {
            try {
                elementDeleteMode = CmsCntPageData.ElementDeleteMode.valueOf(elementDeleteModeLoc.getValue().getStringValue(this.m_cms));
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<CmsFormatterBean> formatters = new ArrayList<CmsFormatterBean>();
        for (I_CmsXmlContentValueLocation formatterLoc : node.getSubValues(N_FORMATTER)) {
            CmsFormatterBean formatter = this.parseFormatter(typeName, formatterLoc);
            formatters.add(formatter);
        }
        CmsResourceTypeConfig typeConfig = new CmsResourceTypeConfig(typeName, disabled, folderOrName, namePattern, detailPagesDisabled, addDisabled, createDisabled, elementView, localization, showInDefaultView, copyInModels, order, elementDeleteMode);
        this.m_resourceTypeConfigs.add(typeConfig);
    }

    public CmsADEConfigDataInternal parseSitemapConfiguration(String basePath, CmsResource configRes) throws CmsException {
        LOG.info((Object)("Parsing configuration " + configRes.getRootPath()));
        CmsFile configFile = this.m_cms.readFile(configRes);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, configFile);
        return this.parseConfiguration(basePath, content);
    }

    public List<CmsADEConfigDataInternal> readModuleConfigurations() {
        ArrayList<CmsADEConfigDataInternal> configurations = new ArrayList<CmsADEConfigDataInternal>();
        List<CmsModule> modules = OpenCms.getModuleManager().getAllInstalledModules();
        long beginTime = System.currentTimeMillis();
        for (CmsModule module : modules) {
            String configPath = module.getConfigurationPath();
            if (!this.m_cms.existsResource(configPath)) continue;
            try {
                CmsResource configFile = this.m_cms.readResource(configPath);
                LOG.info((Object)("Found module configuration " + configPath + " for module " + module.getName()));
                CmsADEConfigDataInternal config = this.parseSitemapConfiguration(null, configFile);
                configurations.add(config);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsRuntimeException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.debug((Object)("readModuleConfiguations took " + (endTime - beginTime) + "ms"));
        return configurations;
    }

    protected boolean getBoolean(I_CmsXmlContentLocation parent, String name) {
        I_CmsXmlContentValueLocation location = parent.getSubValue(name);
        if (location == null) {
            return false;
        }
        String value = location.getValue().getStringValue(this.m_cms);
        return Boolean.parseBoolean(value);
    }

    protected String getString(I_CmsXmlContentValueLocation location) {
        return CmsConfigurationReader.getString(this.m_cms, location);
    }

    protected void parseDetailPage(I_CmsXmlContentLocation node) {
        I_CmsXmlContentValueLocation pageLoc = node.getSubValue(N_PAGE);
        String typeName = this.getString(node.getSubValue(N_TYPE));
        CmsXmlVfsFileValue detailPageValue = (CmsXmlVfsFileValue)pageLoc.getValue();
        CmsLink uncheckedLink = detailPageValue.getUncheckedLink();
        if (uncheckedLink == null) {
            LOG.warn((Object)("Missing detail page link in " + CmsLog.eval(LOG, () -> node.getDocument().getFile().getRootPath())));
            return;
        }
        String page = uncheckedLink.getTarget();
        CmsUUID structureId = uncheckedLink.getStructureId();
        if (structureId == null) {
            return;
        }
        String iconClasses = typeName.startsWith("function@") ? CmsIconUtil.getIconClasses("function", null, false) : CmsIconUtil.getIconClasses(typeName, null, false);
        CmsDetailPageInfo detailPage = new CmsDetailPageInfo(structureId, page, typeName, iconClasses);
        this.m_detailPageConfigs.add(detailPage);
    }

    protected CmsFormatterChangeSet parseFormatterChangeSet(String basePath, I_CmsXmlContentLocation node, boolean removeAllFormatters, boolean removeFunctions, Set<CmsUUID> functions, Set<CmsUUID> functionsToRemove) {
        Set<String> addFormatters = this.parseAddFormatters(node);
        addFormatters.addAll(this.readLocalFormatters(node));
        HashSet<String> removeFormatters = removeAllFormatters ? new HashSet() : this.parseRemoveFormatters(node);
        String siteRoot = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(basePath)) {
            siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
        }
        CmsFormatterChangeSet result = new CmsFormatterChangeSet(removeFormatters, addFormatters, siteRoot, removeAllFormatters, removeFunctions, functions, functionsToRemove);
        return result;
    }

    protected void parseFunctionReference(I_CmsXmlContentLocation node) {
        String name = node.getSubValue(N_NAME).asString(this.m_cms);
        CmsUUID functionId = node.getSubValue(N_FUNCTION).asId(this.m_cms);
        CmsUUID functionDefaultPageId = null;
        I_CmsXmlContentValueLocation defaultPageValue = node.getSubValue(N_FUNCTION_DEFAULT_PAGE);
        if (defaultPageValue != null) {
            functionDefaultPageId = defaultPageValue.asId(this.m_cms);
        }
        I_CmsXmlContentValueLocation orderNode = node.getSubValue(N_ORDER);
        int order = 10000;
        if (orderNode != null) {
            String orderStr = orderNode.asString(this.m_cms);
            try {
                order = Integer.parseInt(orderStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_functionReferences.add(new CmsFunctionReference(name, functionId, functionDefaultPageId, order));
    }

    private void parseProperty(I_CmsXmlContentLocation field, DiscardPropertiesMode mode) {
        CmsPropertyConfig propConfig = CmsConfigurationReader.parseProperty(this.m_cms, field);
        if (mode == DiscardPropertiesMode.top) {
            propConfig = propConfig.cloneWithTop(true);
        }
        this.m_propertyConfigs.add(propConfig);
    }

    private Set<CmsUUID> readInternalLinkListTargetIds(I_CmsXmlContentLocation root, String childName, String grandchildName) {
        LinkedHashSet<CmsUUID> result = new LinkedHashSet<CmsUUID>();
        for (I_CmsXmlContentValueLocation parent : root.getSubValues(childName)) {
            for (I_CmsXmlContentValueLocation node : parent.getSubValues(grandchildName)) {
                CmsUUID structureId;
                CmsXmlVfsFileValue value = (CmsXmlVfsFileValue)node.getValue();
                CmsLink link = value.getLink(this.m_cms);
                if (link == null || (structureId = link.getStructureId()) == null) continue;
                result.add(link.getStructureId());
            }
        }
        return result;
    }

    private Set<String> readLocalFormatters(I_CmsXmlContentLocation node) {
        HashSet<String> addFormatters = new HashSet<String>();
        String path = this.m_cms.getSitePath(node.getDocument().getFile());
        path = CmsStringUtil.joinPaths(CmsResource.getParentFolder(path), ".formatters");
        try {
            if (this.m_cms.existsResource(path, CmsResourceFilter.IGNORE_EXPIRATION)) {
                I_CmsResourceType macroType = OpenCms.getResourceManager().getResourceType("macro_formatter");
                CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(macroType);
                List<CmsResource> macroFormatters = this.m_cms.readResources(path, filter);
                for (CmsResource formatter : macroFormatters) {
                    addFormatters.add(formatter.getStructureId().toString());
                }
                I_CmsResourceType flexType = OpenCms.getResourceManager().getResourceType("flex_formatter");
                CmsResourceFilter filterFlex = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(flexType);
                List<CmsResource> flexFormatters = this.m_cms.readResources(path, filterFlex);
                for (CmsResource formatter : flexFormatters) {
                    addFormatters.add(formatter.getStructureId().toString());
                }
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return addFormatters;
    }

    static enum DiscardPropertiesMode {
        discard("true"),
        keep("false"),
        top("top");

        private String m_stringValue;

        private DiscardPropertiesMode(String stringValue) {
            this.m_stringValue = stringValue;
        }

        public String getStringValue() {
            return this.m_stringValue;
        }
    }
}

