/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.ade.configuration.formatters.CmsFormatterIndex;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsFormatterChangeSet {
    public static final String PREFIX_TYPE = "type_";
    private String m_debugPath;
    private Set<CmsUUID> m_functions;
    private Set<CmsUUID> m_functionsToRemove = new HashSet<CmsUUID>();
    private Pattern m_pathPattern;
    private boolean m_removeAllNonExplicitlyAdded;
    private boolean m_removeFunctions;
    private Map<String, Boolean> m_typeUpdateSet = new HashMap<String, Boolean>();
    private Map<CmsUUID, Boolean> m_updateSet = new HashMap<CmsUUID, Boolean>();

    public CmsFormatterChangeSet() {
    }

    public CmsFormatterChangeSet(Collection<String> toRemove, Collection<String> toAdd, String siteRoot, boolean removeAllNonExplicitlyAdded, boolean removeFunctions, Set<CmsUUID> functions, Set<CmsUUID> functionsToRemove) {
        this();
        this.m_removeFunctions = removeFunctions;
        this.m_functions = functions;
        this.m_functionsToRemove = functionsToRemove != null ? functionsToRemove : new HashSet();
        this.initialize(toRemove, toAdd, siteRoot, removeAllNonExplicitlyAdded);
    }

    public static String keyForType(String typeName) {
        return PREFIX_TYPE + typeName;
    }

    public void applyToFormatters(CmsFormatterIndex formatterIndex, CmsFormatterConfigurationCacheState externalFormatters) {
        formatterIndex.removeIf(formatter -> {
            if (formatter instanceof CmsFunctionFormatterBean && this.m_removeFunctions) {
                return true;
            }
            return !(formatter instanceof CmsFunctionFormatterBean) && this.m_removeAllNonExplicitlyAdded;
        });
        HashMap<CmsUUID, Boolean> updateSetWithFunctions = new HashMap<CmsUUID, Boolean>(this.m_updateSet);
        for (CmsUUID cmsUUID : this.m_functionsToRemove) {
            updateSetWithFunctions.put(cmsUUID, Boolean.FALSE);
        }
        if (this.m_functions != null) {
            for (CmsUUID cmsUUID : this.m_functions) {
                updateSetWithFunctions.put(cmsUUID, Boolean.TRUE);
            }
        }
        for (Map.Entry entry : updateSetWithFunctions.entrySet()) {
            CmsUUID id = (CmsUUID)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            if (value.booleanValue()) {
                I_CmsFormatterBean addedFormatter = externalFormatters.getFormatters().get(id);
                if (addedFormatter == null) continue;
                formatterIndex.addFormatter(addedFormatter);
                continue;
            }
            formatterIndex.remove(id);
        }
        if (this.m_pathPattern != null) {
            formatterIndex.removeIf(formatter -> {
                String location = formatter.getLocation();
                return location != null && !this.m_pathPattern.matcher(location).matches();
            });
        }
    }

    public void applyToTypes(Set<String> types) {
        if (this.m_removeAllNonExplicitlyAdded) {
            types.removeIf(type -> !"function".equals(type));
        }
        for (Map.Entry<String, Boolean> typeUpdateEntry : this.m_typeUpdateSet.entrySet()) {
            String typeName = typeUpdateEntry.getKey();
            Boolean add = typeUpdateEntry.getValue();
            if (add.booleanValue()) {
                types.add(typeName);
                continue;
            }
            types.remove(typeName);
        }
    }

    public void setDebugPath(String debugPath) {
        this.m_debugPath = debugPath;
    }

    private void initialize(Collection<String> toRemove, Collection<String> toAdd, String siteRoot, boolean removeAllNonExplicitlyAdded) {
        this.m_removeAllNonExplicitlyAdded = removeAllNonExplicitlyAdded;
        for (String removeKey : toRemove) {
            if (CmsUUID.isValidUUID(removeKey)) {
                this.m_updateSet.put(new CmsUUID(removeKey), Boolean.FALSE);
                continue;
            }
            if (!removeKey.startsWith(PREFIX_TYPE)) continue;
            this.m_typeUpdateSet.put(this.removePrefix(removeKey), Boolean.FALSE);
        }
        for (String addKey : toAdd) {
            if (CmsUUID.isValidUUID(addKey)) {
                this.m_updateSet.put(new CmsUUID(addKey), Boolean.TRUE);
                continue;
            }
            if (!addKey.startsWith(PREFIX_TYPE)) continue;
            this.m_typeUpdateSet.put(this.removePrefix(addKey), Boolean.TRUE);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(siteRoot)) {
            if (!siteRoot.endsWith("/")) {
                siteRoot = siteRoot + "/";
            }
            String regex = "^(/system/|" + OpenCms.getSiteManager().getSharedFolder() + "|" + siteRoot + ").*";
            this.m_pathPattern = Pattern.compile(regex);
        }
    }

    private String removePrefix(String key) {
        if (key.startsWith(PREFIX_TYPE)) {
            return key.substring(PREFIX_TYPE.length());
        }
        return key;
    }
}

